/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.asn;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;

public final class Utils {
    public static long readTransactionId(AsnInputStream ais) throws AsnException, IOException {
        byte[] data = ais.readOctetString();
        byte[] longRep = new byte[8];
        System.arraycopy(data, 0, longRep, longRep.length - data.length, data.length);
        ByteBuffer bb = ByteBuffer.wrap(longRep);
        return bb.getLong();
    }

    public static void writeTransactionId(AsnOutputStream aos, long txId, int tagClass, int tag) throws AsnException, IOException {
        byte[] data = new byte[4];
        data[3] = (byte)txId;
        data[2] = (byte)(txId >> 8);
        data[1] = (byte)(txId >> 16);
        data[0] = (byte)(txId >> 24);
        aos.writeOctetString(tagClass, tag, data);
    }

    public static long decodeTransactionId(byte[] data, boolean swapBytes) {
        byte[] longRep = new byte[8];
        if (swapBytes) {
            System.arraycopy(data, 0, longRep, longRep.length - data.length, data.length);
        } else {
            longRep[4] = data[3];
            longRep[5] = data[2];
            longRep[6] = data[1];
            longRep[7] = data[0];
        }
        ByteBuffer bb = ByteBuffer.wrap(longRep);
        return bb.getLong();
    }

    public static byte[] encodeTransactionId(long txId, boolean swapBytes) {
        byte[] data = new byte[4];
        if (swapBytes) {
            data[3] = (byte)txId;
            data[2] = (byte)(txId >> 8);
            data[1] = (byte)(txId >> 16);
            data[0] = (byte)(txId >> 24);
        } else {
            data[0] = (byte)txId;
            data[1] = (byte)(txId >> 8);
            data[2] = (byte)(txId >> 16);
            data[3] = (byte)(txId >> 24);
        }
        return data;
    }
}

