/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.asn;

import java.io.IOException;
import java.util.Arrays;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.tcap.asn.ApplicationContextName;
import org.restcomm.protocols.ss7.tcap.asn.EncodeException;
import org.restcomm.protocols.ss7.tcap.asn.ParseException;
import org.restcomm.protocols.ss7.tcap.asn.comp.PAbortCauseType;

public class ApplicationContextNameImpl
implements ApplicationContextName {
    private long[] oid;

    @Override
    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 6 || localAis.getTagClass() != 0) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding ApplicationContextName: bad tag or tagClass, found tag=" + tag + ", tagClass=" + localAis.getTagClass());
            }
            this.oid = localAis.readObjectIdentifier();
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException while decoding ApplicationContextName: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException while decoding ApplicationContextName: " + e.getMessage(), e);
        }
    }

    @Override
    public void encode(AsnOutputStream aos) throws EncodeException {
        if (this.oid == null) {
            throw new EncodeException("Error while decoding ApplicationContextName: No OID value set");
        }
        try {
            aos.writeTag(2, false, 1);
            int pos = aos.StartContentDefiniteLength();
            aos.writeObjectIdentifier(this.oid);
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new EncodeException("IOException while encoding ApplicationContextName: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new EncodeException("IOException while encoding ApplicationContextName: " + e.getMessage(), e);
        }
    }

    @Override
    public long[] getOid() {
        return this.oid;
    }

    @Override
    public void setOid(long[] oid) {
        this.oid = oid;
    }

    public String getStringValue() {
        return Arrays.toString(this.oid);
    }

    public String toString() {
        return "ApplicationContextName[oid=" + Arrays.toString(this.oid) + "]";
    }
}

