/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.restcomm.protocols.ss7.indicator.GlobalTitleIndicator;
import org.restcomm.protocols.ss7.indicator.NatureOfAddress;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.parameter.AbstractGlobalTitle;
import org.restcomm.protocols.ss7.sccp.impl.parameter.BCDEvenEncodingScheme;
import org.restcomm.protocols.ss7.sccp.impl.parameter.BCDOddEncodingScheme;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.parameter.GlobalTitle0001;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;

public class GlobalTitle0001Impl
extends AbstractGlobalTitle
implements GlobalTitle0001 {
    private NatureOfAddress natureOfAddress;
    protected static final XMLFormat<GlobalTitle0001Impl> XML = new XMLFormat<GlobalTitle0001Impl>(GlobalTitle0001Impl.class){

        @Override
        public void write(GlobalTitle0001Impl ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("nai", ai.natureOfAddress.getValue());
            xml.setAttribute("digits", ai.digits);
        }

        @Override
        public void read(XMLFormat.InputElement xml, GlobalTitle0001Impl ai) throws XMLStreamException {
            try {
                ai.natureOfAddress = NatureOfAddress.valueOf(xml.getAttribute("nai").toInt());
            }
            catch (IllegalArgumentException e) {
                throw new XMLStreamException(e);
            }
            ai.digits = xml.getAttribute("digits").toString();
        }
    };

    public GlobalTitle0001Impl() {
    }

    public GlobalTitle0001Impl(String digits, NatureOfAddress natureOfAddress) {
        if (natureOfAddress == null) {
            throw new IllegalArgumentException();
        }
        if (digits == null) {
            throw new IllegalArgumentException();
        }
        this.natureOfAddress = natureOfAddress;
        this.digits = digits;
        this.encodingScheme = this.digits.length() % 2 == 1 ? BCDOddEncodingScheme.INSTANCE : BCDEvenEncodingScheme.INSTANCE;
    }

    @Override
    public GlobalTitleIndicator getGlobalTitleIndicator() {
        return GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_NATURE_OF_ADDRESS_INDICATOR_ONLY;
    }

    @Override
    public NatureOfAddress getNatureOfAddress() {
        return this.natureOfAddress;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            int b = in.read() & 0xFF;
            this.natureOfAddress = NatureOfAddress.valueOf(b & 0x7F);
            this.encodingScheme = (b & 0x80) > 0 ? BCDOddEncodingScheme.INSTANCE : BCDEvenEncodingScheme.INSTANCE;
            this.digits = this.encodingScheme.decode(in);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void encode(OutputStream out, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (this.natureOfAddress == null) {
                throw new IllegalStateException();
            }
            boolean odd = this.digits.length() % 2 != 0;
            int b = 0;
            if (odd) {
                b |= 0xFFFFFF80;
            }
            out.write((byte)(b |= (byte)this.natureOfAddress.getValue()));
            if (this.digits == null) {
                throw new IllegalStateException();
            }
            this.encodingScheme.encode(this.digits, out);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.natureOfAddress == null ? 0 : this.natureOfAddress.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalTitle0001Impl other = (GlobalTitle0001Impl)obj;
        return this.natureOfAddress == other.natureOfAddress;
    }

    public String toString() {
        return "GlobalTitle0001Impl [digits=" + this.digits + ", natureOfAddress=" + (Object)((Object)this.natureOfAddress) + ", encodingScheme=" + this.encodingScheme + "]";
    }
}

