/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.callhandling;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.callhandling.CCBSIndicators;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;

public class CCBSIndicatorsImpl
extends SequenceBase
implements CCBSIndicators {
    private static final int _TAG_ccbsPossible = 0;
    private static final int _TAG_keepCCBSCallIndicator = 1;
    private static final int _TAG_mapExtensionContainer = 2;
    private boolean ccbsPossible;
    private boolean keepCCBSCallIndicator;
    private MAPExtensionContainer mapExtensionContainer;

    public CCBSIndicatorsImpl() {
        super("CCBSIndicators");
    }

    public CCBSIndicatorsImpl(boolean ccbsPossible, boolean keepCCBSCallIndicator, MAPExtensionContainer mapExtensionContainer) {
        super("CCBSIndicators");
        this.ccbsPossible = ccbsPossible;
        this.keepCCBSCallIndicator = keepCCBSCallIndicator;
        this.mapExtensionContainer = mapExtensionContainer;
    }

    @Override
    public boolean getCCBSPossible() {
        return this.ccbsPossible;
    }

    @Override
    public boolean getKeepCCBSCallIndicator() {
        return this.keepCCBSCallIndicator;
    }

    @Override
    public MAPExtensionContainer getMAPExtensionContainer() {
        return this.mapExtensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ccbsPossible = false;
        this.keepCCBSCallIndicator = false;
        this.mapExtensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block8: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ccbsPossible: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ais.readNull();
                            this.ccbsPossible = true;
                            continue block8;
                        }
                        case 1: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".keepCCBSCallIndicator: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ais.readNull();
                            this.keepCCBSCallIndicator = true;
                            continue block8;
                        }
                        case 2: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".mapExtensionContainer: Parameter mapExtensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.mapExtensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.mapExtensionContainer).decodeAll(ais);
                            continue block8;
                        }
                    }
                    ais.advanceElement();
                    continue block8;
                }
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.ccbsPossible) {
                asnOs.writeNull(2, 0);
            }
            if (this.keepCCBSCallIndicator) {
                asnOs.writeNull(2, 1);
            }
            if (this.mapExtensionContainer != null) {
                ((MAPExtensionContainerImpl)this.mapExtensionContainer).encodeAll(asnOs, 2, 2);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.ccbsPossible) {
            sb.append("ccbsPossible, ");
        }
        if (this.keepCCBSCallIndicator) {
            sb.append("keepCCBSCallIndicator, ");
        }
        if (this.mapExtensionContainer != null) {
            sb.append("mapExtensionContainer=");
            sb.append(this.mapExtensionContainer.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

