/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.ServerChannel;
import io.netty.channel.sctp.SctpChannelOption;
import io.netty.channel.sctp.SctpServerChannel;
import io.netty.channel.sctp.nio.NioSctpServerChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.Server;
import org.mobicents.protocols.sctp.netty.NettySctpManagementImpl;
import org.mobicents.protocols.sctp.netty.NettySctpServerChannelInitializer;
import org.mobicents.protocols.sctp.netty.NettyTcpServerChannelInitializer;

public class NettyServerImpl
implements Server {
    private static final Logger logger = Logger.getLogger(NettyServerImpl.class.getName());
    private static final String COMMA = ", ";
    private static final String NAME = "name";
    private static final String HOST_ADDRESS = "hostAddress";
    private static final String HOST_PORT = "hostPort";
    private static final String IPCHANNEL_TYPE = "ipChannelType";
    private static final String ASSOCIATIONS = "associations";
    private static final String EXTRA_HOST_ADDRESS = "extraHostAddress";
    private static final String ACCEPT_ANONYMOUS_CONNECTIONS = "acceptAnonymousConnections";
    private static final String MAX_CONCURRENT_CONNECTIONS_COUNT = "maxConcurrentConnectionsCount";
    private static final String STARTED = "started";
    private static final String EXTRA_HOST_ADDRESS_SIZE = "extraHostAddresseSize";
    private String name;
    private String hostAddress;
    private int hostport;
    private volatile boolean started = false;
    private IpChannelType ipChannelType;
    private boolean acceptAnonymousConnections;
    private int maxConcurrentConnectionsCount;
    private String[] extraHostAddresses;
    private NettySctpManagementImpl management = null;
    protected FastList<String> associations = new FastList();
    protected FastList<Association> anonymAssociations = new FastList();
    private SctpServerChannel serverChannelSctp;
    private NioServerSocketChannel serverChannelTcp;
    protected static final XMLFormat<NettyServerImpl> SERVER_XML = new XMLFormat<NettyServerImpl>(NettyServerImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, NettyServerImpl server) throws XMLStreamException {
            server.name = xml.getAttribute(NettyServerImpl.NAME, "");
            server.started = xml.getAttribute(NettyServerImpl.STARTED, false);
            server.hostAddress = xml.getAttribute(NettyServerImpl.HOST_ADDRESS, "");
            server.hostport = xml.getAttribute(NettyServerImpl.HOST_PORT, 0);
            server.ipChannelType = IpChannelType.getInstance(xml.getAttribute(NettyServerImpl.IPCHANNEL_TYPE, IpChannelType.SCTP.getCode()));
            if (server.ipChannelType == null) {
                throw new XMLStreamException("Bad value for server.ipChannelType");
            }
            server.acceptAnonymousConnections = xml.getAttribute(NettyServerImpl.ACCEPT_ANONYMOUS_CONNECTIONS, false);
            server.maxConcurrentConnectionsCount = xml.getAttribute(NettyServerImpl.MAX_CONCURRENT_CONNECTIONS_COUNT, 0);
            int extraHostAddressesSize = xml.getAttribute(NettyServerImpl.EXTRA_HOST_ADDRESS_SIZE, 0);
            NettyServerImpl.access$702(server, new String[extraHostAddressesSize]);
            for (int i = 0; i < extraHostAddressesSize; ++i) {
                ((NettyServerImpl)server).extraHostAddresses[i] = xml.get(NettyServerImpl.EXTRA_HOST_ADDRESS, String.class);
            }
            server.associations = xml.get(NettyServerImpl.ASSOCIATIONS, FastList.class);
        }

        @Override
        public void write(NettyServerImpl server, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(NettyServerImpl.NAME, server.name);
            xml.setAttribute(NettyServerImpl.STARTED, server.started);
            xml.setAttribute(NettyServerImpl.HOST_ADDRESS, server.hostAddress);
            xml.setAttribute(NettyServerImpl.HOST_PORT, server.hostport);
            xml.setAttribute(NettyServerImpl.IPCHANNEL_TYPE, server.ipChannelType.getCode());
            xml.setAttribute(NettyServerImpl.ACCEPT_ANONYMOUS_CONNECTIONS, server.acceptAnonymousConnections);
            xml.setAttribute(NettyServerImpl.MAX_CONCURRENT_CONNECTIONS_COUNT, server.maxConcurrentConnectionsCount);
            xml.setAttribute(NettyServerImpl.EXTRA_HOST_ADDRESS_SIZE, server.extraHostAddresses != null ? server.extraHostAddresses.length : 0);
            if (server.extraHostAddresses != null) {
                for (String s : server.extraHostAddresses) {
                    xml.add(s, NettyServerImpl.EXTRA_HOST_ADDRESS, String.class);
                }
            }
            xml.add(server.associations, NettyServerImpl.ASSOCIATIONS, FastList.class);
        }
    };

    public NettyServerImpl() {
    }

    public NettyServerImpl(String name, String hostAddress, int hostport, IpChannelType ipChannelType, boolean acceptAnonymousConnections, int maxConcurrentConnectionsCount, String[] extraHostAddresses) throws IOException {
        this.name = name;
        this.hostAddress = hostAddress;
        this.hostport = hostport;
        this.ipChannelType = ipChannelType;
        this.acceptAnonymousConnections = acceptAnonymousConnections;
        this.maxConcurrentConnectionsCount = maxConcurrentConnectionsCount;
        this.extraHostAddresses = extraHostAddresses;
    }

    @Override
    public IpChannelType getIpChannelType() {
        return this.ipChannelType;
    }

    public void setIpChannelType(IpChannelType ipChannelType) {
        this.ipChannelType = ipChannelType;
    }

    @Override
    public boolean isAcceptAnonymousConnections() {
        return this.acceptAnonymousConnections;
    }

    public void setAcceptAnonymousConnections(Boolean acceptAnonymousConnections) {
        this.acceptAnonymousConnections = acceptAnonymousConnections;
    }

    @Override
    public int getMaxConcurrentConnectionsCount() {
        return this.maxConcurrentConnectionsCount;
    }

    @Override
    public void setMaxConcurrentConnectionsCount(int val) {
        this.maxConcurrentConnectionsCount = val;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    @Override
    public int getHostport() {
        return this.hostport;
    }

    public void setHostport(int hostport) {
        this.hostport = hostport;
    }

    @Override
    public String[] getExtraHostAddresses() {
        return this.extraHostAddresses;
    }

    public void setExtraHostAddresses(String[] extraHostAddresses) {
        this.extraHostAddresses = extraHostAddresses;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public List<String> getAssociations() {
        return this.associations.unmodifiable();
    }

    @Override
    public List<Association> getAnonymAssociations() {
        return this.anonymAssociations.unmodifiable();
    }

    protected ServerChannel getIpChannel() {
        if (this.ipChannelType == IpChannelType.SCTP) {
            return this.serverChannelSctp;
        }
        return this.serverChannelTcp;
    }

    protected void setManagement(NettySctpManagementImpl management) {
        this.management = management;
    }

    protected void start() throws Exception {
        this.initSocket();
        this.started = true;
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Started Server=%s", this.name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() throws Exception {
        FastList<String> tempAssociations = this.associations;
        Object n = tempAssociations.head();
        FastCollection.Record end = tempAssociations.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            String assocName = (String)((FastList.Node)n).getValue();
            Association associationTemp = this.management.getAssociation(assocName);
            if (!associationTemp.isStarted()) continue;
            throw new Exception(String.format("Stop all the associations first. Association=%s is still started", associationTemp.getName()));
        }
        n = this.anonymAssociations;
        synchronized (n) {
            for (Association ass : this.anonymAssociations) {
                ass.stopAnonymousAssociation();
            }
            this.anonymAssociations.clear();
        }
        this.started = false;
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Stoped Server=%s", this.name));
        }
        if (this.getIpChannel() != null) {
            try {
                this.getIpChannel().close().sync();
            }
            catch (Exception e) {
                logger.warn(String.format("Error while stopping the Server=%s", this.name), e);
            }
        }
    }

    private void initSocket() throws Exception {
        ServerBootstrap b = new ServerBootstrap();
        b.group(this.management.getBossGroup(), this.management.getWorkerGroup());
        if (this.ipChannelType == IpChannelType.SCTP) {
            b.channel(NioSctpServerChannel.class);
            b.option(ChannelOption.SO_BACKLOG, 100);
            b.childHandler(new NettySctpServerChannelInitializer(this, this.management));
            this.applySctpOptions(b);
        } else {
            b.channel(NioServerSocketChannel.class);
            b.option(ChannelOption.SO_BACKLOG, 100);
            b.childHandler(new NettyTcpServerChannelInitializer(this, this.management));
        }
        b.handler(new LoggingHandler(LogLevel.INFO));
        InetSocketAddress localAddress = new InetSocketAddress(this.hostAddress, this.hostport);
        ChannelFuture channelFuture = b.bind(localAddress).sync();
        if (this.ipChannelType == IpChannelType.SCTP) {
            this.serverChannelSctp = (SctpServerChannel)channelFuture.channel();
            if (this.extraHostAddresses != null) {
                for (int count = 0; count < this.extraHostAddresses.length; ++count) {
                    String localSecondaryAddress = this.extraHostAddresses[count];
                    InetAddress localSecondaryInetAddress = InetAddress.getByName(localSecondaryAddress);
                    channelFuture = this.serverChannelSctp.bindAddress(localSecondaryInetAddress).sync();
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("SctpServerChannel bound to=%s ", this.serverChannelSctp.allLocalAddresses()));
            }
        } else {
            this.serverChannelTcp = (NioServerSocketChannel)channelFuture.channel();
            if (logger.isInfoEnabled()) {
                logger.info(String.format("ServerSocketChannel bound to=%s ", this.serverChannelTcp.localAddress()));
            }
        }
    }

    private void applySctpOptions(ServerBootstrap b) {
        b.childOption(SctpChannelOption.SCTP_NODELAY, this.management.getOptionSctpNodelay());
        b.childOption(SctpChannelOption.SCTP_DISABLE_FRAGMENTS, this.management.getOptionSctpDisableFragments());
        b.childOption(SctpChannelOption.SCTP_FRAGMENT_INTERLEAVE, this.management.getOptionSctpFragmentInterleave());
        b.childOption(SctpChannelOption.SCTP_INIT_MAXSTREAMS, this.management.getOptionSctpInitMaxstreams());
        b.childOption(SctpChannelOption.SO_SNDBUF, this.management.getOptionSoSndbuf());
        b.childOption(SctpChannelOption.SO_RCVBUF, this.management.getOptionSoRcvbuf());
        b.childOption(SctpChannelOption.SO_LINGER, this.management.getOptionSoLinger());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Server [name=").append(this.name).append(", started=").append(this.started).append(", hostAddress=").append(this.hostAddress).append(", hostPort=").append(this.hostport).append(", ipChannelType=").append((Object)this.ipChannelType).append(", acceptAnonymousConnections=").append(this.acceptAnonymousConnections).append(", maxConcurrentConnectionsCount=").append(this.maxConcurrentConnectionsCount).append(", associations(anonymous does not included)=[");
        FastCollection.Record n = this.associations.head();
        FastCollection.Record end = this.associations.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            sb.append((String)((FastList.Node)n).getValue());
            sb.append(COMMA);
        }
        sb.append("], extraHostAddress=[");
        if (this.extraHostAddresses != null) {
            for (int i = 0; i < this.extraHostAddresses.length; ++i) {
                String extraHostAddress = this.extraHostAddresses[i];
                sb.append(extraHostAddress);
                sb.append(COMMA);
            }
        }
        sb.append("]]");
        return sb.toString();
    }

    static /* synthetic */ String[] access$702(NettyServerImpl x0, String[] x1) {
        x0.extraHostAddresses = x1;
        return x1;
    }
}

