/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.parameter.AbstractGlobalTitle;
import org.mobicents.protocols.ss7.sccp.impl.parameter.BCDEvenEncodingScheme;
import org.mobicents.protocols.ss7.sccp.impl.parameter.BCDOddEncodingScheme;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle0010;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;

public class GlobalTitle0010Impl
extends AbstractGlobalTitle
implements GlobalTitle0010 {
    private int translationType;
    protected static final XMLFormat<GlobalTitle0010Impl> XML = new XMLFormat<GlobalTitle0010Impl>(GlobalTitle0010Impl.class){

        @Override
        public void write(GlobalTitle0010Impl ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("tt", ai.translationType);
            xml.setAttribute("digits", ai.digits);
        }

        @Override
        public void read(XMLFormat.InputElement xml, GlobalTitle0010Impl ai) throws XMLStreamException {
            ai.translationType = xml.getAttribute("tt").toInt();
            ai.digits = xml.getAttribute("digits").toString();
        }
    };

    public GlobalTitle0010Impl() {
        this.encodingScheme = BCDEvenEncodingScheme.INSTANCE;
    }

    public GlobalTitle0010Impl(String digits, int translationType) {
        this();
        if (digits == null) {
            throw new IllegalArgumentException();
        }
        this.translationType = translationType;
        this.digits = digits;
        this.encodingScheme = this.digits.length() % 2 == 1 ? BCDOddEncodingScheme.INSTANCE : BCDEvenEncodingScheme.INSTANCE;
    }

    public GlobalTitleIndicator getGlobalTitleIndicator() {
        return GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY;
    }

    public int getTranslationType() {
        return this.translationType;
    }

    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            this.translationType = in.read() & 0xFF;
            super.decode(in, factory, sccpProtocolVersion);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public void encode(OutputStream out, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            out.write(this.translationType);
            super.encode(out, removeSpc, sccpProtocolVersion);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public void decode(byte[] b, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        this.decode(new ByteArrayInputStream(b), factory, sccpProtocolVersion);
    }

    public byte[] encode(boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos, removeSpc, sccpProtocolVersion);
        return baos.toByteArray();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.translationType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalTitle0010Impl other = (GlobalTitle0010Impl)obj;
        return this.translationType == other.translationType;
    }

    public String toString() {
        return "GlobalTitle0010Impl [digits=" + this.digits + ", translationType=" + this.translationType + ", encodingScheme=" + this.encodingScheme + "]";
    }
}

