/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.Number;

public abstract class AbstractNumber
extends AbstractISUPParameter
implements Number {
    private static final String ADDRESS = "address";
    private static final String DEFAULT_ADDRESS = "";
    protected Logger logger = Logger.getLogger(this.getClass());
    protected int oddFlag;
    public static final int _FLAG_ODD = 1;
    protected String address;
    protected static final XMLFormat<AbstractNumber> ISUP_ABSTRACT_NUMBER_XML = new XMLFormat<AbstractNumber>(AbstractNumber.class){

        @Override
        public void read(XMLFormat.InputElement xml, AbstractNumber abstractNumber) throws XMLStreamException {
            abstractNumber.setAddress(xml.getAttribute(AbstractNumber.ADDRESS, AbstractNumber.DEFAULT_ADDRESS));
        }

        @Override
        public void write(AbstractNumber abstractNumber, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(AbstractNumber.ADDRESS, abstractNumber.address);
        }
    };

    public AbstractNumber() {
    }

    public AbstractNumber(byte[] representation) throws ParameterException {
        this.decode(representation);
    }

    public AbstractNumber(ByteArrayInputStream bis) throws ParameterException {
        this.decode(bis);
    }

    public AbstractNumber(String address) {
        this.setAddress(address);
    }

    public int decode(byte[] b) throws ParameterException {
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        return this.decode(bis);
    }

    protected int decode(ByteArrayInputStream bis) throws ParameterException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Decoding header");
        }
        int count = this.decodeHeader(bis);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Decoding header, read count: " + count);
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Decoding body");
        }
        count += this.decodeBody(bis);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Decoding body, read count: " + count);
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Decoding digits");
        }
        count += this.decodeDigits(bis);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Decoding digits, read count: " + count);
        }
        return count;
    }

    public byte[] encode() throws ParameterException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Encoding header");
        }
        int count = this.encodeHeader(bos);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Encoding header, write count: " + count);
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Encoding body");
        }
        count += this.encodeBody(bos);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Encoding body, write count: " + count);
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Encoding digits");
        }
        count += this.encodeDigits(bos);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Encoding digits, write count: " + count);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(bos.toByteArray());
        }
        catch (IOException e) {
            throw new ParameterException(e);
        }
        return out.toByteArray();
    }

    public int encode(ByteArrayOutputStream out) throws ParameterException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Encoding header");
        }
        int count = this.encodeHeader(bos);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Encoding header, write count: " + count);
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Encoding body");
        }
        count += this.encodeBody(bos);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Encoding body, write count: " + count);
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Encoding digits");
        }
        count += this.encodeDigits(bos);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.getClass().getSimpleName() + "]Encoding digits, write count: " + count);
        }
        try {
            out.write(bos.toByteArray());
        }
        catch (IOException e) {
            throw new ParameterException(e);
        }
        return count;
    }

    public int decodeHeader(ByteArrayInputStream bis) throws ParameterException {
        if (bis.available() == 0) {
            throw new ParameterException("No more data to read.");
        }
        int b = bis.read() & 0xFF;
        this.oddFlag = (b & 0x80) >> 7;
        return 1;
    }

    public abstract int decodeBody(ByteArrayInputStream var1) throws ParameterException;

    public int decodeDigits(ByteArrayInputStream bis) throws ParameterException {
        if (this.skipDigits()) {
            return 0;
        }
        if (bis.available() == 0) {
            throw new ParameterException("No more data to read.");
        }
        int count = 0;
        try {
            this.address = DEFAULT_ADDRESS;
            byte b = 0;
            while (bis.available() - 1 > 0) {
                b = (byte)bis.read();
                int d1 = b & 0xF;
                int d2 = (b & 0xF0) >> 4;
                this.address = this.address + Integer.toHexString(d1) + Integer.toHexString(d2);
            }
            b = (byte)(bis.read() & 0xFF);
            this.address = this.address + Integer.toHexString(b & 0xF);
            if (this.oddFlag != 1) {
                this.address = this.address + Integer.toHexString((b & 0xF0) >> 4);
            }
            this.setAddress(this.address);
        }
        catch (Exception e) {
            throw new ParameterException(e);
        }
        return count;
    }

    public int decodeDigits(ByteArrayInputStream bis, int octetsCount) throws ParameterException {
        int count;
        if (this.skipDigits()) {
            return 0;
        }
        if (bis.available() == 0) {
            throw new ParameterException("No more data to read.");
        }
        try {
            this.address = DEFAULT_ADDRESS;
            int b = 0;
            for (count = 0; octetsCount - 1 != count && bis.available() - 1 > 0; ++count) {
                b = (byte)bis.read();
                int d1 = b & 0xF;
                int d2 = (b & 0xF0) >> 4;
                this.address = this.address + Integer.toHexString(d1) + Integer.toHexString(d2);
            }
            b = bis.read() & 0xFF;
            ++count;
            this.address = this.address + Integer.toHexString(b & 0xF);
            if (this.oddFlag != 1) {
                this.address = this.address + Integer.toHexString((b & 0xF0) >> 4);
            }
            this.setAddress(this.address);
        }
        catch (Exception e) {
            throw new ParameterException(e);
        }
        if (octetsCount != count) {
            throw new ParameterException("Failed to read [" + octetsCount + "], encountered only [" + count + "]");
        }
        return count;
    }

    public int encodeHeader(ByteArrayOutputStream bos) {
        boolean isOdd;
        int b = 0;
        boolean bl = isOdd = this.oddFlag == 1;
        if (isOdd) {
            b |= 0x80;
        }
        bos.write(b);
        return 1;
    }

    public abstract int encodeBody(ByteArrayOutputStream var1);

    public int encodeDigits(ByteArrayOutputStream bos) {
        if (this.skipDigits()) {
            return 0;
        }
        boolean isOdd = this.oddFlag == 1;
        byte b = 0;
        int count = !isOdd ? this.address.length() : this.address.length() - 1;
        int bytesCount = 0;
        for (int i = 0; i < count - 1; i += 2) {
            String ds1 = this.address.substring(i, i + 1);
            String ds2 = this.address.substring(i + 1, i + 2);
            int d1 = Integer.parseInt(ds1, 16);
            int d2 = Integer.parseInt(ds2, 16);
            b = (byte)(d2 << 4 | d1);
            bos.write(b);
            ++bytesCount;
        }
        if (isOdd) {
            String ds1 = this.address.substring(count, count + 1);
            int d = Integer.parseInt(ds1);
            b = (byte)(d & 0xF);
            bos.write(b);
            ++bytesCount;
        }
        return bytesCount;
    }

    public boolean isOddFlag() {
        return this.oddFlag == 1;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        this.oddFlag = address != null ? this.address.length() % 2 : 0;
    }

    protected boolean skipDigits() {
        return false;
    }
}

