/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.AChChargingAddress;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.primitives.SendingSideID;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ApplyChargingRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.CAMELAChBillingChargingCharacteristics;
import org.mobicents.protocols.ss7.cap.primitives.AChChargingAddressImpl;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.primitives.SendingSideIDImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.CAMELAChBillingChargingCharacteristicsImpl;

public class ApplyChargingRequestImpl
extends CircuitSwitchedCallMessageImpl
implements ApplyChargingRequest {
    private static final String A_CH_BILLING_CHARGING_CHARACTERISTICS = "aChBillingChargingCharacteristics";
    private static final String PARTY_TO_CHARGE = "partyToCharge";
    private static final String A_CH_CHARGING_ADDRESS = "aChChargingAddress";
    private static final String EXTENSIONS = "extensions";
    public static final int _ID_aChBillingChargingCharacteristics = 0;
    public static final int _ID_partyToCharge = 2;
    public static final int _ID_extensions = 3;
    public static final int _ID_aChChargingAddress = 50;
    public static final String _PrimitiveName = "ApplyChargingRequestIndication";
    private CAMELAChBillingChargingCharacteristics aChBillingChargingCharacteristics;
    private SendingSideID partyToCharge;
    private CAPExtensions extensions;
    private AChChargingAddress aChChargingAddress;
    protected static final XMLFormat<ApplyChargingRequestImpl> APPLY_CHARGING_REQUEST_XML = new XMLFormat<ApplyChargingRequestImpl>(ApplyChargingRequestImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, ApplyChargingRequestImpl applyChargingRequest) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.read(xml, applyChargingRequest);
            applyChargingRequest.aChBillingChargingCharacteristics = xml.get(ApplyChargingRequestImpl.A_CH_BILLING_CHARGING_CHARACTERISTICS, CAMELAChBillingChargingCharacteristicsImpl.class);
            applyChargingRequest.partyToCharge = xml.get(ApplyChargingRequestImpl.PARTY_TO_CHARGE, SendingSideIDImpl.class);
            applyChargingRequest.aChChargingAddress = xml.get(ApplyChargingRequestImpl.A_CH_CHARGING_ADDRESS, AChChargingAddressImpl.class);
            applyChargingRequest.extensions = xml.get(ApplyChargingRequestImpl.EXTENSIONS, CAPExtensionsImpl.class);
        }

        @Override
        public void write(ApplyChargingRequestImpl applyChargingRequest, XMLFormat.OutputElement xml) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.write(applyChargingRequest, xml);
            if (applyChargingRequest.aChBillingChargingCharacteristics != null) {
                xml.add((CAMELAChBillingChargingCharacteristicsImpl)applyChargingRequest.aChBillingChargingCharacteristics, ApplyChargingRequestImpl.A_CH_BILLING_CHARGING_CHARACTERISTICS, CAMELAChBillingChargingCharacteristicsImpl.class);
            }
            if (applyChargingRequest.partyToCharge != null) {
                xml.add((SendingSideIDImpl)applyChargingRequest.partyToCharge, ApplyChargingRequestImpl.PARTY_TO_CHARGE, SendingSideIDImpl.class);
            }
            if (applyChargingRequest.aChChargingAddress != null) {
                xml.add((AChChargingAddressImpl)applyChargingRequest.aChChargingAddress, ApplyChargingRequestImpl.A_CH_CHARGING_ADDRESS, AChChargingAddressImpl.class);
            }
            if (applyChargingRequest.extensions != null) {
                xml.add((CAPExtensionsImpl)applyChargingRequest.extensions, ApplyChargingRequestImpl.EXTENSIONS, CAPExtensionsImpl.class);
            }
        }
    };

    public ApplyChargingRequestImpl() {
    }

    public ApplyChargingRequestImpl(CAMELAChBillingChargingCharacteristics aChBillingChargingCharacteristics, SendingSideID partyToCharge, CAPExtensions extensions, AChChargingAddress aChChargingAddress) {
        this.aChBillingChargingCharacteristics = aChBillingChargingCharacteristics;
        this.partyToCharge = partyToCharge;
        this.extensions = extensions;
        this.aChChargingAddress = aChChargingAddress;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.applyCharging_Request;
    }

    public int getOperationCode() {
        return 35;
    }

    public CAMELAChBillingChargingCharacteristics getAChBillingChargingCharacteristics() {
        return this.aChBillingChargingCharacteristics;
    }

    public SendingSideID getPartyToCharge() {
        return this.partyToCharge;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public AChChargingAddress getAChChargingAddress() {
        return this.aChChargingAddress;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ApplyChargingRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ApplyChargingRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ApplyChargingRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ApplyChargingRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.aChBillingChargingCharacteristics = null;
        this.partyToCharge = null;
        this.extensions = null;
        this.aChChargingAddress = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.aChBillingChargingCharacteristics = new CAMELAChBillingChargingCharacteristicsImpl();
                        ((CAMELAChBillingChargingCharacteristicsImpl)this.aChBillingChargingCharacteristics).decodeAll(ais);
                        break;
                    }
                    case 2: {
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.partyToCharge = new SendingSideIDImpl();
                        ((SendingSideIDImpl)this.partyToCharge).decodeAll(ais2);
                        break;
                    }
                    case 3: {
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    case 50: {
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.aChChargingAddress = new AChChargingAddressImpl();
                        ((AChChargingAddressImpl)this.aChChargingAddress).decodeAll(ais2);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.aChBillingChargingCharacteristics == null) {
            throw new CAPParsingComponentException("Error while decoding ApplyChargingRequestIndication: aChBillingChargingCharacteristics is mandatory but not found ", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ApplyChargingRequestIndication: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.aChBillingChargingCharacteristics == null) {
            throw new CAPException("Error while encoding ApplyChargingRequestIndication: aChBillingChargingCharacteristics must not be null");
        }
        try {
            int pos;
            if (this.aChBillingChargingCharacteristics != null) {
                ((CAMELAChBillingChargingCharacteristicsImpl)this.aChBillingChargingCharacteristics).encodeAll(aos, 2, 0);
            }
            if (this.partyToCharge != null) {
                aos.writeTag(2, false, 2);
                pos = aos.StartContentDefiniteLength();
                ((SendingSideIDImpl)this.partyToCharge).encodeAll(aos);
                aos.FinalizeContent(pos);
            }
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 3);
            }
            if (this.aChChargingAddress != null) {
                aos.writeTag(2, false, 50);
                pos = aos.StartContentDefiniteLength();
                ((AChChargingAddressImpl)this.aChChargingAddress).encodeAll(aos);
                aos.FinalizeContent(pos);
            }
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ApplyChargingRequestIndication: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.aChBillingChargingCharacteristics != null) {
            sb.append(", aChBillingChargingCharacteristics=");
            sb.append(this.aChBillingChargingCharacteristics.toString());
        }
        if (this.partyToCharge != null) {
            sb.append(", partyToCharge=");
            sb.append(this.partyToCharge.toString());
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        if (this.aChChargingAddress != null) {
            sb.append(", aChChargingAddress=");
            sb.append(this.aChChargingAddress.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

