/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResult;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.restcomm.protocols.ss7.sccp.impl.message.MessageUtil;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpAddressedMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.CreditImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.HopCounterImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ImportanceImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ProtocolClassImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SccpAddressImpl;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.message.SccpConnCrMessage;
import org.restcomm.protocols.ss7.sccp.parameter.Credit;
import org.restcomm.protocols.ss7.sccp.parameter.HopCounter;
import org.restcomm.protocols.ss7.sccp.parameter.Importance;
import org.restcomm.protocols.ss7.sccp.parameter.LocalReference;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;
import org.restcomm.protocols.ss7.sccp.parameter.ProtocolClass;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;

public class SccpConnCrMessageImpl
extends SccpAddressedMessageImpl
implements SccpConnCrMessage {
    protected LocalReference sourceLocalReferenceNumber;
    protected ProtocolClass protocolClass;
    protected Credit credit;
    protected byte[] userData;
    protected Importance importance;

    public SccpConnCrMessageImpl(int sls, int localSsn, SccpAddress calledParty, SccpAddress callingParty, HopCounter hopCounter) {
        super(130, 1, sls, localSsn, calledParty, callingParty, hopCounter);
    }

    public SccpConnCrMessageImpl(int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(130, 1, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    @Override
    public LocalReference getSourceLocalReferenceNumber() {
        return this.sourceLocalReferenceNumber;
    }

    @Override
    public void setSourceLocalReferenceNumber(LocalReference sourceLocalReferenceNumber) {
        this.sourceLocalReferenceNumber = sourceLocalReferenceNumber;
    }

    @Override
    public ProtocolClass getProtocolClass() {
        return this.protocolClass;
    }

    @Override
    public void setProtocolClass(ProtocolClass protocolClass) {
        this.protocolClass = protocolClass;
    }

    @Override
    public Credit getCredit() {
        return this.credit;
    }

    @Override
    public void setCredit(Credit credit) {
        this.credit = credit;
    }

    @Override
    public byte[] getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(byte[] userData) {
        this.userData = userData;
    }

    @Override
    public Importance getImportance() {
        return this.importance;
    }

    @Override
    public void setImportance(Importance importance) {
        this.importance = importance;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = new byte[3];
            in.read(buffer);
            LocalReferenceImpl ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.sourceLocalReferenceNumber = ref;
            buffer = new byte[1];
            in.read(buffer);
            ProtocolClassImpl protocol = new ProtocolClassImpl();
            protocol.decode(buffer, factory, sccpProtocolVersion);
            this.protocolClass = protocol;
            int cpaPointer = in.read() & 0xFF;
            in.mark(in.available());
            in.skip(cpaPointer - 1);
            int len = in.read() & 0xFF;
            buffer = new byte[len];
            in.read(buffer);
            this.calledParty = this.createAddress(buffer, factory, sccpProtocolVersion);
            in.reset();
            int pointer = in.read() & 0xFF;
            in.mark(in.available());
            if (pointer == 0) {
                return;
            }
            if ((long)(pointer - 1) != in.skip(pointer - 1)) {
                throw new IOException("Not enough data in buffer");
            }
            int paramCode = 0;
            while ((paramCode = in.read() & 0xFF) != 0) {
                if (paramCode != 9 && paramCode != 4 && paramCode != 15 && paramCode != 17 && paramCode != 18) {
                    throw new ParseException(String.format("Code %d is not supported for CR message", paramCode));
                }
                len = in.read() & 0xFF;
                buffer = new byte[len];
                in.read(buffer);
                this.decodeOptional(paramCode, buffer, sccpProtocolVersion, factory);
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public EncodingResultData encode(SccpStackImpl sccpStackImpl, LongMessageRuleType longMessageRuleType, int maxMtp3UserDataLength, Logger logger, boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] b;
            int fieldsLen;
            int availLen;
            if (this.type == 0) {
                return new EncodingResultData(EncodingResult.MessageTypeMissing, null, null, null);
            }
            if (this.sourceLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.SourceLocalReferenceNumberMissing, null, null, null);
            }
            if (this.protocolClass == null) {
                return new EncodingResultData(EncodingResult.ProtocolClassMissing, null, null, null);
            }
            if (this.calledParty == null) {
                return new EncodingResultData(EncodingResult.CalledPartyAddressMissing, null, null, null);
            }
            byte[] cdp = ((SccpAddressImpl)this.calledParty).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] cnp = new byte[]{};
            if (this.callingParty != null) {
                cnp = ((SccpAddressImpl)this.callingParty).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            }
            byte[] slr = ((LocalReferenceImpl)this.sourceLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] protocol = ((ProtocolClassImpl)this.protocolClass).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] bf = new byte[]{};
            if (this.userData != null) {
                bf = this.userData;
            }
            if ((availLen = maxMtp3UserDataLength - (fieldsLen = MessageUtil.calculateCrFieldsLengthWithoutData(cdp.length, this.credit != null, cnp.length, this.hopCounter != null, this.importance != null))) > 130) {
                availLen = 130;
            }
            if (bf.length > availLen) {
                if (logger.isEnabledFor(Level.WARN)) {
                    logger.warn(String.format("Failure when sending a CR message: message is too long. SccpMessageSegment=%s", this));
                }
                return new EncodingResultData(EncodingResult.SegmentationNotSupported, null, null, null);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(fieldsLen + bf.length);
            out.write(this.type);
            out.write(slr);
            out.write(protocol);
            int len = 2;
            out.write(len);
            boolean optionalPresent = false;
            if (this.credit != null || this.callingParty != null || this.userData != null || this.hopCounter != null || this.importance != null) {
                out.write(len += cdp.length);
                optionalPresent = true;
            } else {
                out.write(0);
            }
            out.write(cdp.length);
            out.write(cdp);
            if (this.credit != null) {
                out.write(9);
                b = ((CreditImpl)this.credit).encode(removeSPC, sccpProtocolVersion);
                out.write(b.length);
                out.write(b);
            }
            if (this.callingParty != null) {
                out.write(4);
                b = ((SccpAddressImpl)this.callingParty).encode(removeSPC, sccpProtocolVersion);
                out.write(b.length);
                out.write(b);
            }
            if (this.userData != null) {
                out.write(15);
                out.write(this.userData.length);
                out.write(this.userData);
            }
            if (this.hopCounter != null) {
                out.write(17);
                b = this.hopCounter.encode(removeSPC, sccpProtocolVersion);
                out.write(b.length);
                out.write(b);
            }
            if (this.importance != null) {
                out.write(18);
                b = ((ImportanceImpl)this.importance).encode(removeSPC, sccpProtocolVersion);
                out.write(b.length);
                out.write(b);
            }
            if (optionalPresent) {
                out.write(0);
            }
            return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    protected void decodeOptional(int code, byte[] buffer, SccpProtocolVersion sccpProtocolVersion, ParameterFactory factory) throws ParseException {
        switch (code) {
            case 9: {
                CreditImpl cred = new CreditImpl();
                cred.decode(buffer, factory, sccpProtocolVersion);
                this.credit = cred;
                break;
            }
            case 4: {
                SccpAddressImpl address = new SccpAddressImpl();
                address.decode(buffer, factory, sccpProtocolVersion);
                this.callingParty = address;
                break;
            }
            case 3: {
                SccpAddressImpl address2 = new SccpAddressImpl();
                address2.decode(buffer, factory, sccpProtocolVersion);
                this.calledParty = address2;
                break;
            }
            case 15: {
                this.userData = buffer;
                break;
            }
            case 17: {
                HopCounterImpl counter;
                this.hopCounter = counter = new HopCounterImpl(buffer[0]);
                break;
            }
            case 18: {
                ImportanceImpl imp = new ImportanceImpl();
                imp.decode(buffer, null, sccpProtocolVersion);
                this.importance = imp;
                break;
            }
            default: {
                throw new ParseException("Unknown optional parameter code: " + code);
            }
        }
    }

    protected SccpAddress createAddress(byte[] buffer, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        SccpAddressImpl addressImpl = new SccpAddressImpl();
        addressImpl.decode(buffer, factory, sccpProtocolVersion);
        return addressImpl;
    }

    @Override
    public boolean reduceHopCounter() {
        if (this.hopCounter != null) {
            int val = this.hopCounter.getValue();
            if (--val <= 0) {
                val = 0;
            }
            this.hopCounter.setValue(val);
            if (val == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean getSccpCreatesSls() {
        return false;
    }

    @Override
    public boolean getReturnMessageOnError() {
        throw new IllegalStateException();
    }

    @Override
    public void clearReturnMessageOnError() {
        throw new IllegalStateException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sccp Msg [Type=CR");
        sb.append(" networkId=");
        sb.append(this.networkId);
        sb.append(" sls=");
        sb.append(this.sls);
        sb.append(" incomingOpc=");
        sb.append(this.incomingOpc);
        sb.append(" incomingDpc=");
        sb.append(this.incomingDpc);
        sb.append(" outgoingDpc=");
        sb.append(this.outgoingDpc);
        sb.append(" CallingAddress(");
        sb.append(this.callingParty);
        sb.append(") CalledParty(");
        sb.append(this.calledParty);
        sb.append(")");
        sb.append(" DataLen=");
        if (this.userData != null) {
            sb.append(this.userData.length);
        }
        sb.append(" sourceLR=");
        if (this.sourceLocalReferenceNumber != null) {
            sb.append(this.sourceLocalReferenceNumber.getValue());
        }
        sb.append(" protocolClass=");
        if (this.protocolClass != null) {
            sb.append(this.protocolClass.getProtocolClass());
        }
        sb.append(" credit=");
        if (this.credit != null) {
            sb.append(this.credit.getValue());
        }
        sb.append(" importance=");
        if (this.importance != null) {
            sb.append(this.importance.getValue());
        }
        sb.append(" hopCounter=");
        if (this.hopCounter != null) {
            sb.append(this.hopCounter.getValue());
        }
        sb.append(" isMtpOriginated=");
        sb.append(this.isMtpOriginated);
        sb.append("]");
        return sb.toString();
    }
}

