/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.ApplicationTransport;

public class ApplicationTransportImpl
extends AbstractISUPParameter
implements ApplicationTransport {
    private static final int _TURN_ON = 1;
    private static final int _TURN_OFF = 0;
    private Byte applicationContextIdentifier;
    private Byte apmSegmentationIndicator;
    private Byte segmentationLocalReference;
    private Boolean sendNotificationIndicator;
    private Boolean releaseCallIndicator;
    private Boolean segmentationIndicator;
    private byte[] encapsulatedApplicationData;

    public ApplicationTransportImpl() {
    }

    public ApplicationTransportImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length < 1) {
            throw new ParameterException("byte[] must not be null or have bigger size.");
        }
        for (int index = 0; index < 4 && index < b.length; ++index) {
            if (!((b[index] & 0x80) == 0 ? b.length - 1 == index : b.length - 1 - index > 0)) continue;
            throw new ParameterException();
        }
        this.applicationContextIdentifier = (byte)(b[0] & 0x7F);
        if (b.length == 1) {
            return b.length;
        }
        this.releaseCallIndicator = (b[1] & 1) == 1;
        this.sendNotificationIndicator = (b[1] >> 1 & 1) == 1;
        if (b.length == 2) {
            return b.length;
        }
        this.apmSegmentationIndicator = (byte)(b[2] & 0x3F);
        this.segmentationIndicator = (b[2] >> 6 & 1) == 1;
        if (b.length == 3) {
            return b.length;
        }
        this.segmentationLocalReference = (byte)(b[3] & 0x7F);
        if (b.length == 4) {
            return b.length;
        }
        this.encapsulatedApplicationData = new byte[b.length - 4];
        System.arraycopy(b, 4, this.encapsulatedApplicationData, 0, this.encapsulatedApplicationData.length);
        return b.length;
    }

    public byte[] encode() throws ParameterException {
        if (this.applicationContextIdentifier == null) {
            throw new ParameterException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean end = false;
        int value = 128;
        if (this.releaseCallIndicator != null) {
            value = 0;
        } else {
            end = true;
        }
        baos.write(value |= this.applicationContextIdentifier & 0x7F);
        if (end) {
            return baos.toByteArray();
        }
        if (this.apmSegmentationIndicator != null) {
            value = 0;
        } else {
            value = 128;
            end = true;
        }
        value |= (this.sendNotificationIndicator != false ? 1 : 0) << 1;
        baos.write(value |= this.releaseCallIndicator != false ? 1 : 0);
        if (end) {
            return baos.toByteArray();
        }
        if (this.segmentationLocalReference != null) {
            value = 0;
        } else {
            value = 128;
            end = true;
        }
        value |= (this.segmentationIndicator != false ? 1 : 0) << 6;
        baos.write(value |= this.apmSegmentationIndicator & 0x3F);
        if (end) {
            return baos.toByteArray();
        }
        if (this.encapsulatedApplicationData != null) {
            value = 0;
        } else {
            value = 128;
            end = true;
        }
        baos.write(value |= this.segmentationLocalReference & 0x7F);
        if (end) {
            return baos.toByteArray();
        }
        try {
            baos.write(this.encapsulatedApplicationData);
        }
        catch (IOException ioe) {
            throw new ParameterException(ioe);
        }
        return baos.toByteArray();
    }

    public int getCode() {
        return 120;
    }

    public Byte getApplicationContextIdentifier() {
        return this.applicationContextIdentifier;
    }

    public void setApplicationContextIdentifier(Byte v) {
        this.applicationContextIdentifier = v;
    }

    public Boolean isSendNotificationIndicator() {
        return this.sendNotificationIndicator;
    }

    public void setSendNotificationIndicator(Boolean v) {
        this.sendNotificationIndicator = v;
    }

    public Boolean isReleaseCallIndicator() {
        return this.releaseCallIndicator;
    }

    public void setReleaseCallIndicator(Boolean v) {
        this.releaseCallIndicator = v;
    }

    public Boolean isSegmentationIndicator() {
        return this.segmentationIndicator;
    }

    public void setSegmentationIndicator(Boolean v) {
        this.segmentationIndicator = v;
    }

    public Byte getAPMSegmentationIndicator() {
        return this.apmSegmentationIndicator;
    }

    public void setAPMSegmentationIndicator(Byte v) {
        this.apmSegmentationIndicator = v;
    }

    public Byte getSegmentationLocalReference() {
        return this.segmentationLocalReference;
    }

    public void setSegmentationLocalReference(Byte v) {
        this.segmentationLocalReference = v;
    }

    public byte[] getEncapsulatedApplicationInformation() {
        return this.encapsulatedApplicationData;
    }

    public void setEncapsulatedApplicationInformation(byte[] v) {
        this.encapsulatedApplicationData = v;
    }
}

