/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.gprs;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.gprs.EventReportGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.GPRSEventSpecificInformation;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.GPRSEventType;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.PDPID;
import org.mobicents.protocols.ss7.cap.service.gprs.GprsMessageImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.GPRSEventSpecificInformationImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.PDPIDImpl;
import org.mobicents.protocols.ss7.inap.api.INAPException;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentException;
import org.mobicents.protocols.ss7.inap.api.primitives.MiscCallInfo;
import org.mobicents.protocols.ss7.inap.primitives.MiscCallInfoImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class EventReportGPRSRequestImpl
extends GprsMessageImpl
implements EventReportGPRSRequest {
    public static final String _PrimitiveName = "EventReportGPRSRequest";
    public static final int _ID_gprsEventType = 0;
    public static final int _ID_miscGPRSInfo = 1;
    public static final int _ID_gprsEventSpecificInformation = 2;
    public static final int _ID_pdpID = 3;
    private GPRSEventType gprsEventType;
    private MiscCallInfo miscGPRSInfo;
    private GPRSEventSpecificInformation gprsEventSpecificInformation;
    private PDPID pdpID;

    public EventReportGPRSRequestImpl() {
    }

    public EventReportGPRSRequestImpl(GPRSEventType gprsEventType, MiscCallInfo miscGPRSInfo, GPRSEventSpecificInformation gprsEventSpecificInformation, PDPID pdpID) {
        this.gprsEventType = gprsEventType;
        this.miscGPRSInfo = miscGPRSInfo;
        this.gprsEventSpecificInformation = gprsEventSpecificInformation;
        this.pdpID = pdpID;
    }

    public GPRSEventType getGPRSEventType() {
        return this.gprsEventType;
    }

    public MiscCallInfo getMiscGPRSInfo() {
        return this.miscGPRSInfo;
    }

    public GPRSEventSpecificInformation getGPRSEventSpecificInformation() {
        return this.gprsEventSpecificInformation;
    }

    public PDPID getPDPID() {
        return this.pdpID;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.eventReportGPRS_Request;
    }

    public int getOperationCode() {
        return 80;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding EventReportGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding EventReportGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding EventReportGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (INAPParsingComponentException e) {
            throw new CAPParsingComponentException("INAPParsingComponentException when decoding EventReportGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding EventReportGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding EventReportGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding EventReportGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (INAPParsingComponentException e) {
            throw new CAPParsingComponentException("INAPParsingComponentException when decoding EventReportGPRSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException, INAPParsingComponentException {
        this.gprsEventType = null;
        this.miscGPRSInfo = null;
        this.gprsEventSpecificInformation = null;
        this.pdpID = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding EventReportGPRSRequest.gprsEventType: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.gprsEventType = GPRSEventType.getInstance(i1);
                        break;
                    }
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding EventReportGPRSRequest.miscGPRSInfo: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.miscGPRSInfo = new MiscCallInfoImpl();
                        ((MiscCallInfoImpl)this.miscGPRSInfo).decodeAll(ais);
                        break;
                    }
                    case 2: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding EventReportGPRSRequest.gprsEventSpecificInformation: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.gprsEventSpecificInformation = new GPRSEventSpecificInformationImpl();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        ((GPRSEventSpecificInformationImpl)this.gprsEventSpecificInformation).decodeAll(ais2);
                        break;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding EventReportGPRSRequest.pdpID: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.pdpID = new PDPIDImpl();
                        ((PDPIDImpl)this.pdpID).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding EventReportGPRSRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.gprsEventType == null) {
            throw new CAPException("Error while encoding EventReportGPRSRequest: gprsEventType must not be null");
        }
        if (this.miscGPRSInfo == null) {
            throw new CAPException("Error while encoding EventReportGPRSRequest: miscGPRSInfo must not be null");
        }
        try {
            asnOs.writeInteger(2, 0, this.gprsEventType.getCode());
            ((MiscCallInfoImpl)this.miscGPRSInfo).encodeAll(asnOs, 2, 1);
            if (this.gprsEventSpecificInformation != null) {
                try {
                    asnOs.writeTag(2, false, 2);
                    int pos = asnOs.StartContentDefiniteLength();
                    ((GPRSEventSpecificInformationImpl)this.gprsEventSpecificInformation).encodeAll(asnOs);
                    asnOs.FinalizeContent(pos);
                }
                catch (AsnException e) {
                    throw new CAPException("AsnException while encoding EventReportGPRSRequest parameter gprsEventSpecificInformation");
                }
            }
            if (this.pdpID != null) {
                ((PDPIDImpl)this.pdpID).encodeAll(asnOs, 2, 3);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding EventReportGPRSRequest: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding EventReportGPRSRequest: " + e.getMessage(), e);
        }
        catch (INAPException e) {
            throw new CAPException("INAPException when encoding EventReportGPRSRequest: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EventReportGPRSRequest [");
        this.addInvokeIdInfo(sb);
        if (this.gprsEventType != null) {
            sb.append(", gprsEventType=");
            sb.append(this.gprsEventType.toString());
        }
        if (this.miscGPRSInfo != null) {
            sb.append(", miscGPRSInfo=");
            sb.append(this.miscGPRSInfo.toString());
        }
        if (this.gprsEventSpecificInformation != null) {
            sb.append(", gprsEventSpecificInformation=");
            sb.append(this.gprsEventSpecificInformation.toString());
        }
        if (this.pdpID != null) {
            sb.append("pdpID=");
            sb.append(this.pdpID.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

