/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.CancelRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.CallSegmentToCancel;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.CallSegmentToCancelImpl;

public class CancelRequestImpl
extends CircuitSwitchedCallMessageImpl
implements CancelRequest {
    private static final String INVOKE_ID = "invokeID";
    private static final String ALL_REQUESTS = "allRequests";
    private static final String CALL_SEGMENT_TO_CANCEL = "callSegmentToCancel";
    public static final int _ID_invokeID = 0;
    public static final int _ID_allRequests = 1;
    public static final int _ID_callSegmentToCancel = 2;
    public static final String _PrimitiveName = "CancelRequest";
    private Integer invokeID;
    private boolean allRequests;
    private CallSegmentToCancel callSegmentToCancel;
    protected static final XMLFormat<CancelRequestImpl> CANCEL_REQUEST_XML = new XMLFormat<CancelRequestImpl>(CancelRequestImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, CancelRequestImpl cancelRequest) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.read(xml, cancelRequest);
            cancelRequest.invokeID = xml.get(CancelRequestImpl.INVOKE_ID, Integer.class);
            Boolean bval = xml.get(CancelRequestImpl.ALL_REQUESTS, Boolean.class);
            if (bval != null) {
                cancelRequest.allRequests = bval;
            }
            cancelRequest.callSegmentToCancel = xml.get(CancelRequestImpl.CALL_SEGMENT_TO_CANCEL, CallSegmentToCancelImpl.class);
        }

        @Override
        public void write(CancelRequestImpl cancelRequest, XMLFormat.OutputElement xml) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.write(cancelRequest, xml);
            xml.add(cancelRequest.invokeID, CancelRequestImpl.INVOKE_ID, Integer.class);
            if (cancelRequest.allRequests) {
                xml.add(cancelRequest.allRequests, CancelRequestImpl.ALL_REQUESTS, Boolean.class);
            }
            xml.add((CallSegmentToCancelImpl)cancelRequest.callSegmentToCancel, CancelRequestImpl.CALL_SEGMENT_TO_CANCEL, CallSegmentToCancelImpl.class);
        }
    };

    public CancelRequestImpl() {
    }

    public CancelRequestImpl(Integer invokeID) {
        this.invokeID = invokeID;
    }

    public CancelRequestImpl(boolean allRequests) {
        this.allRequests = allRequests;
    }

    public CancelRequestImpl(CallSegmentToCancel callSegmentToCancel) {
        this.callSegmentToCancel = callSegmentToCancel;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.cancel_Request;
    }

    public int getOperationCode() {
        return 53;
    }

    public Integer getInvokeID() {
        return this.invokeID;
    }

    public boolean getAllRequests() {
        return this.allRequests;
    }

    public CallSegmentToCancel getCallSegmentToCancel() {
        return this.callSegmentToCancel;
    }

    public int getTag() throws CAPException {
        if (this.invokeID != null) {
            return 0;
        }
        if (this.allRequests) {
            return 1;
        }
        if (this.callSegmentToCancel != null) {
            return 2;
        }
        throw new CAPException("Error while encoding CancelRequest: no of choices has been definite");
    }

    public int getTagClass() {
        return 2;
    }

    public boolean getIsPrimitive() {
        return this.callSegmentToCancel == null;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CancelRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CancelRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CancelRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CancelRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.invokeID = null;
        this.allRequests = false;
        this.callSegmentToCancel = null;
        if (ais.getTagClass() != 2) {
            throw new CAPParsingComponentException("Error while decoding CancelRequest: bad tagClass", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (ais.getTag()) {
            case 0: {
                this.invokeID = (int)ais.readIntegerData(length);
                break;
            }
            case 1: {
                ais.readNullData(length);
                this.allRequests = true;
                break;
            }
            case 2: {
                this.callSegmentToCancel = new CallSegmentToCancelImpl();
                ((CallSegmentToCancelImpl)this.callSegmentToCancel).decodeData(ais, length);
                break;
            }
            default: {
                throw new CAPParsingComponentException("Error while decoding CancelRequest: bad tag: " + ais.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CancelRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        int choiceCnt = 0;
        if (this.invokeID != null) {
            ++choiceCnt;
        }
        if (this.allRequests) {
            ++choiceCnt;
        }
        if (this.callSegmentToCancel != null) {
            ++choiceCnt;
        }
        if (choiceCnt != 1) {
            throw new CAPException("Error while encoding CancelRequest: only one choice must be definite, found: " + choiceCnt);
        }
        try {
            if (this.invokeID != null) {
                aos.writeIntegerData(this.invokeID.intValue());
            }
            if (this.allRequests) {
                aos.writeNullData();
            }
            if (this.callSegmentToCancel != null) {
                ((CallSegmentToCancelImpl)this.callSegmentToCancel).encodeData(aos);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding CancelRequest: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.invokeID != null) {
            sb.append(", invokeID=");
            sb.append(this.invokeID);
        }
        if (this.allRequests) {
            sb.append(", allRequests");
        }
        if (this.callSegmentToCancel != null) {
            sb.append(", allSegmentToCancel=");
            sb.append(this.callSegmentToCancel.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

