/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl.message;

import java.nio.ByteBuffer;
import javolution.text.TextBuilder;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.message.M3UAMessage;
import org.mobicents.protocols.ss7.m3ua.parameter.Parameter;

public abstract class M3UAMessageImpl
implements M3UAMessage {
    private int messageClass;
    private int messageType;
    private String message;
    protected FastMap<Short, Parameter> parameters = new FastMap();
    private ParameterFactoryImpl factory = new ParameterFactoryImpl();
    int initialPosition = 0;

    public M3UAMessageImpl(String message) {
        this.message = message;
    }

    protected M3UAMessageImpl(int messageClass, int messageType, String message) {
        this(message);
        this.messageClass = messageClass;
        this.messageType = messageType;
    }

    protected abstract void encodeParams(ByteBuffer var1);

    public void encode(ByteBuffer buffer) {
        this.initialPosition = buffer.position();
        buffer.position(this.initialPosition + 8);
        this.encodeParams(buffer);
        int length = buffer.position() - this.initialPosition;
        buffer.put(this.initialPosition++, (byte)1);
        buffer.put(this.initialPosition++, (byte)0);
        buffer.put(this.initialPosition++, (byte)this.messageClass);
        buffer.put(this.initialPosition++, (byte)this.messageType);
        buffer.putInt(this.initialPosition++, length);
    }

    protected void decode(byte[] data) {
        this.decode(data, 0);
    }

    protected void decode(byte[] data, int initialPos) {
        int pos = initialPos;
        while (pos < data.length) {
            short tag = (short)((data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF);
            short len = (short)((data[pos + 2] & 0xFF) << 8 | data[pos + 3] & 0xFF);
            byte[] value = new byte[len - 4];
            System.arraycopy(data, pos + 4, value, 0, value.length);
            this.parameters.put(tag, this.factory.createParameter(tag, value));
            int padding = 4 - (pos += len) % 4;
            if (padding >= 4) continue;
            pos += padding;
        }
    }

    @Override
    public int getMessageClass() {
        return this.messageClass;
    }

    @Override
    public int getMessageType() {
        return this.messageType;
    }

    public String toString() {
        TextBuilder tb = new TextBuilder();
        tb.append(this.message).append(" Params(");
        FastCollection.Record e = this.parameters.head();
        FastMap.Entry<Short, Parameter> end = this.parameters.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Parameter value = (Parameter)((FastMap.Entry)e).getValue();
            tb.append(value.toString());
            tb.append(", ");
        }
        tb.append(")");
        return tb.toString();
    }
}

