/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.isup;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.GenericNumberCap;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.GenericNumberImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.GenericNumber;

public class GenericNumberCapImpl
implements GenericNumberCap,
CAPAsnPrimitive {
    public static final String _PrimitiveName = "GenericNumberCap";
    private static final String ISUP_GENERIC_NUMBER_XML = "genericNumber";
    private byte[] data;
    protected static final XMLFormat<GenericNumberCapImpl> GENERIC_NUMBER_CAP_XML = new XMLFormat<GenericNumberCapImpl>(GenericNumberCapImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, GenericNumberCapImpl genericNumber) throws XMLStreamException {
            try {
                genericNumber.setGenericNumber(xml.get(GenericNumberCapImpl.ISUP_GENERIC_NUMBER_XML, GenericNumberImpl.class));
            }
            catch (CAPException e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public void write(GenericNumberCapImpl genericNumber, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                xml.add((GenericNumberImpl)genericNumber.getGenericNumber(), GenericNumberCapImpl.ISUP_GENERIC_NUMBER_XML, GenericNumberImpl.class);
            }
            catch (CAPException e) {
                throw new XMLStreamException(e);
            }
        }
    };

    public GenericNumberCapImpl() {
    }

    public GenericNumberCapImpl(byte[] data) {
        this.data = data;
    }

    public GenericNumberCapImpl(GenericNumber genericNumber) throws CAPException {
        this.setGenericNumber(genericNumber);
    }

    public void setGenericNumber(GenericNumber genericNumber) throws CAPException {
        if (genericNumber == null) {
            throw new CAPException("The genericNumber parameter must not be null");
        }
        try {
            this.setData(((GenericNumberImpl)genericNumber).encode());
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when encoding genericNumber: " + e.getMessage(), e);
        }
    }

    private void setData(byte[] data) throws CAPException {
        if (data == null) {
            throw new CAPException("Generic Number data field must not be null");
        }
        if (data.length < 3 || data.length > 11) {
            throw new CAPException("Generic Number data field length must be from 3 to 11 octets. Provided octets: " + data.length);
        }
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public GenericNumber getGenericNumber() throws CAPException {
        if (this.data == null) {
            throw new CAPException("The data has not been filled");
        }
        try {
            GenericNumberImpl ocn = new GenericNumberImpl();
            ocn.decode(this.data);
            return ocn;
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when decoding GenericNumber: " + e.getMessage(), e);
        }
    }

    public int getTag() throws CAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding GenericNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding GenericNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (CAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding GenericNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding GenericNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding GenericNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (CAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding GenericNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        try {
            this.setData(ansIS.readOctetStringData(length));
        }
        catch (CAPException e) {
            throw new CAPParsingComponentException("Error while decoding GenericNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding GenericNumberCap: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        this.setData(this.data);
        asnOs.writeOctetStringData(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.data != null) {
            sb.append("data=[");
            sb.append(this.printDataArr(this.data));
            sb.append("]");
            try {
                GenericNumber gn = this.getGenericNumber();
                sb.append(", ");
                sb.append(gn.toString());
            }
            catch (CAPException cAPException) {
                // empty catch block
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

