/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.indicator.AddressIndicator;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.parameter.AbstractGlobalTitle;
import org.mobicents.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

public class SccpAddressImpl
extends AbstractParameter
implements XMLSerializable,
SccpAddress {
    private static final byte ROUTE_ON_PC_FLAG = 64;
    private static final short REMOVE_PC_FLAG = 254;
    private static final short REMOVE_PC_FLAG_ANSI = 253;
    private static final byte PC_PRESENT_FLAG = 1;
    private static final byte PC_PRESENT_FLAG_ANSI = 2;
    private static final String GLOBAL_TITLE = "gt";
    private static final String POINT_CODE = "pc";
    private static final String SUBSYSTEM_NUMBER = "ssn";
    private static final String AI = "ai";
    private GlobalTitle gt;
    private int pc = 0;
    private int ssn = -1;
    private AddressIndicator ai;
    private boolean translated;
    protected static final XMLFormat<SccpAddress> XML = new XMLFormat<SccpAddress>(SccpAddress.class){

        @Override
        public void write(SccpAddress ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(SccpAddressImpl.POINT_CODE, ai.getSignalingPointCode());
            xml.setAttribute(SccpAddressImpl.SUBSYSTEM_NUMBER, ai.getSubsystemNumber());
            xml.add(ai.getAddressIndicator(), SccpAddressImpl.AI, AddressIndicator.class);
            xml.add(ai.getGlobalTitle(), SccpAddressImpl.GLOBAL_TITLE);
        }

        @Override
        public void read(XMLFormat.InputElement xml, SccpAddress ai) throws XMLStreamException {
            SccpAddressImpl impl = (SccpAddressImpl)ai;
            impl.pc = xml.getAttribute(SccpAddressImpl.POINT_CODE).toInt();
            impl.ssn = xml.getAttribute(SccpAddressImpl.SUBSYSTEM_NUMBER).toInt();
            impl.ai = xml.get(SccpAddressImpl.AI, AddressIndicator.class);
            impl.gt = (GlobalTitle)xml.get(SccpAddressImpl.GLOBAL_TITLE);
        }
    };

    public SccpAddressImpl() {
    }

    public SccpAddressImpl(RoutingIndicator ri, GlobalTitle gt, int dpc, int ssn) {
        this.gt = gt;
        this.pc = dpc;
        this.ssn = ssn;
        this.ai = new AddressIndicator(dpc > 0, ssn > 0, ri, gt == null ? GlobalTitleIndicator.NO_GLOBAL_TITLE_INCLUDED : gt.getGlobalTitleIndicator());
    }

    public boolean isTranslated() {
        return this.translated;
    }

    public void setTranslated(boolean translated) {
        this.translated = translated;
    }

    public AddressIndicator getAddressIndicator() {
        return this.ai;
    }

    public int getSignalingPointCode() {
        return this.pc;
    }

    public int getSubsystemNumber() {
        return this.ssn;
    }

    public GlobalTitle getGlobalTitle() {
        return this.gt;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SccpAddressImpl other = (SccpAddressImpl)obj;
        if (this.gt == null ? other.gt != null : !this.gt.equals(other.gt)) {
            return false;
        }
        if (this.pc != other.pc) {
            return false;
        }
        return this.ssn == other.ssn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ai == null ? 0 : this.ai.hashCode());
        result = 31 * result + (this.gt == null ? 0 : this.gt.hashCode());
        result = 31 * result + this.pc;
        result = 31 * result + this.ssn;
        return result;
    }

    public String toString() {
        return new StringBuffer().append("pc=").append(this.pc).append(",ssn=").append(this.ssn).append(",AI=").append(this.ai.getValue(SccpProtocolVersion.ITU)).append(",gt=").append(this.gt).toString();
    }

    public void decode(InputStream bin, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            int b = bin.read() & 0xFF;
            this.ai = new AddressIndicator((byte)b, sccpProtocolVersion);
            if (sccpProtocolVersion == SccpProtocolVersion.ANSI) {
                if (this.ai.isSSNPresent()) {
                    this.ssn = bin.read() & 0xFF;
                }
                if (this.ai.isPCPresent()) {
                    int b1 = bin.read() & 0xFF;
                    int b2 = bin.read() & 0xFF;
                    int b3 = bin.read() & 0xFF;
                    this.pc = b3 << 16 | b2 << 8 | b1;
                }
            } else {
                if (this.ai.isPCPresent()) {
                    int b1 = bin.read() & 0xFF;
                    int b2 = bin.read() & 0xFF;
                    this.pc = (b2 & 0x3F) << 8 | b1;
                }
                if (this.ai.isSSNPresent()) {
                    this.ssn = bin.read() & 0xFF;
                }
            }
            if (this.ai.getGlobalTitleIndicator() != GlobalTitleIndicator.NO_GLOBAL_TITLE_INCLUDED) {
                this.gt = factory.createGlobalTitle(this.ai.getGlobalTitleIndicator());
                ((AbstractGlobalTitle)this.gt).decode(bin, factory, sccpProtocolVersion);
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public void encode(OutputStream os, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte aiValue = this.ai.getValue(sccpProtocolVersion);
            if (sccpProtocolVersion == SccpProtocolVersion.ANSI) {
                if (removeSpc && (aiValue & 0x40) == 0) {
                    aiValue = (byte)(aiValue & 0xFD);
                }
                os.write(aiValue);
                if (this.ai.isSSNPresent()) {
                    os.write((byte)this.ssn);
                }
                if ((aiValue & 2) == 2) {
                    byte b1 = (byte)this.pc;
                    byte b2 = (byte)(this.pc >> 8);
                    byte b3 = (byte)(this.pc >> 16);
                    os.write(b1);
                    os.write(b2);
                    os.write(b3);
                }
            } else {
                if (removeSpc && (aiValue & 0x40) == 0) {
                    aiValue = (byte)(aiValue & 0xFE);
                }
                os.write(aiValue);
                if ((aiValue & 1) == 1) {
                    byte b1 = (byte)this.pc;
                    byte b2 = (byte)(this.pc >> 8 & 0x3F);
                    os.write(b1);
                    os.write(b2);
                }
                if (this.ai.isSSNPresent()) {
                    os.write((byte)this.ssn);
                }
            }
            if (this.ai.getGlobalTitleIndicator() != GlobalTitleIndicator.NO_GLOBAL_TITLE_INCLUDED) {
                ((AbstractGlobalTitle)this.gt).encode(os, removeSpc, sccpProtocolVersion);
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public void decode(byte[] b, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        this.decode(bin, factory, sccpProtocolVersion);
    }

    public byte[] encode(boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos, removeSPC, sccpProtocolVersion);
        return baos.toByteArray();
    }
}

