package uk.co.pentest.SHELLING;

import burp.ITab;
import java.awt.Color;
import java.util.Objects;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;

public class ShellingTab implements ITab {
    public ShellingPanel2 shellingPanel = new ShellingPanel2();
    Integer tabIndex;
    JTabbedPane tabPane;
    
    public void findTab() {
        if(tabIndex != null)
            return;
        tabPane = (JTabbedPane) shellingPanel.getParent();
        if(tabPane == null)
            return;
        for(int i = 0; i < tabPane.getTabCount(); i++)
            if(Objects.equals(tabPane.getTitleAt(i), getTabCaption()))
                tabIndex = i;
        tabPane.addChangeListener((ChangeEvent e1) -> {
            if(tabPane.getSelectedIndex() == tabIndex)
                tabPane.setBackgroundAt(tabIndex, Color.BLACK);
        });
    }

    void alertTab() {
        tabPane.setBackgroundAt(tabIndex, new Color((float) 0.894, (float) 0.535, (float) 0.0));
    }
    
    @Override
    public String getTabCaption() {
        return "SHELLING";
    }

    @Override
    public ShellingPanel2 getUiComponent() {        
        return shellingPanel;
    }
    
}
