/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package uk.co.pentest.SHELLING;

import burp.IHttpRequestResponse;
import burp.IIntruderAttack;
import burp.IIntruderPayloadGenerator;
import burp.IIntruderPayloadGeneratorFactory;
/*
 * @author ewilded
 */

public class PayloadFactory implements IIntruderPayloadGeneratorFactory{

    private final ShellingTab tab;
    private final String payloadType;
    
    public PayloadFactory(ShellingTab tab, String payloadType) {
        this.tab = tab;
        this.payloadType = payloadType;
    }
    
    @Override
    public String getGeneratorName() {
        if (payloadType.equals("mark")) {
            return "Payload marker";            
        } 
        if(payloadType.equals("cmd"))
        {
            return "Command injection";
        }
        if(payloadType.equals("byte2"))
        {
            return "Byte (SHELLING)";
        }
        return "Invalid type";
    }

    @Override
    public IIntruderPayloadGenerator createNewInstance(IIntruderAttack attack) 
    {
        if("byte2".equals(payloadType))
        {
            return new IntruderPayloadGeneratorByte(tab);
        }
        // this is what the attack object contains:
        // attack.getHttpService() is the HTTP service
        // attack.getRequestTemplate() is the HTTP request template
        // hence, it's all we need to track down vulnerable page with an asynchronous payload
        //
        // https://portswigger.net/burp/extender/api/burp/IIntruderAttack.html#getHttpService()
        IHttpRequestResponse req = SHELLING.callbacks.makeHttpRequest(attack.getHttpService(),attack.getRequestTemplate());        
        return new IntruderPayloadGenerator(payloadType,tab,"intruder",req, "manual insertion point (intruder)"); // I guess this will perform a vanilla template request before starting IntruderPayloadGenerator.
    }
    
}