/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.BinaryPayloadIssue;
import burp.BuildUnencodedRequest;
import burp.IBurpExtenderCallbacks;
import burp.IHttpRequestResponse;
import burp.IRequestInfo;
import burp.IScanIssue;
import burp.IScannerInsertionPoint;
import burp.ShellingScannerCheck;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.co.pentest.SHELLING.IntruderPayloadGenerator;
import uk.co.pentest.SHELLING.ShellingTab;

public class DirectScannerCheck
extends ShellingScannerCheck {
    private ShellingTab tab;
    private boolean last400Avoid = false;
    private List<IScanIssue> issues;
    private IHttpRequestResponse attackReq;

    public DirectScannerCheck(IBurpExtenderCallbacks cb, ShellingTab tab) {
        super(cb, tab);
        this.tab = tab;
        this.checkHttpService = null;
    }

    @Override
    public int consolidateDuplicateIssues(IScanIssue existingIssue, IScanIssue newIssue) {
        return -1;
    }

    @Override
    public List<IScanIssue> doActiveScan(IHttpRequestResponse baseRequestResponse, IScannerInsertionPoint insertionPoint) {
        this.issues = null;
        if (!this.tab.shellingPanel.scannerChecks) {
            return this.issues;
        }
        this.tab.shellingPanel.checkCollabInteractions(false);
        IRequestInfo reqInfo = this.helpers.analyzeRequest(baseRequestResponse);
        URL url = reqInfo.getUrl();
        int port = url.getPort();
        String loc = "";
        int delaySeconds = this.tab.shellingPanel.getDelay();
        delaySeconds -= 4;
        boolean https = false;
        String host = url.getHost();
        if (url.getProtocol() == "https") {
            https = true;
        }
        String urlStr = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + url.getPath();
        if (!this.createCheckHttpService(host, port, https)) {
            this.callbacks.printError("HTTP connection failed");
            this.callbacks.issueAlert("HTTP connection failed");
            return this.issues;
        }
        this.generator = new IntruderPayloadGenerator("cmd", this.tab, "scanner", baseRequestResponse, insertionPoint.getInsertionPointName());
        if (this.tab.shellingPanel.feedbackChannel == "DNS") {
            loc = this.generator.loc;
        }
        this.generator.setBase(baseRequestResponse);
        int counter = 0;
        while (this.generator.hasMorePayloads() && !this.tab.shellingPanel.stopAllRunningScans.isSelected()) {
            byte[] payload = this.generator.getNextPayloadSmart(insertionPoint.getBaseValue().getBytes(), this.last400Avoid);
            if (payload.length == 1) {
                this.callbacks.printError("Payload generation failed!");
                this.callbacks.issueAlert("Payload generation failed!");
                return this.issues;
            }
            byte[] req = null;
            try {
                req = new BuildUnencodedRequest(this.helpers).buildUnencodedRequest(insertionPoint, payload);
            }
            catch (Exception ex) {
                Logger.getLogger(DirectScannerCheck.class.getName()).log(Level.SEVERE, null, ex);
            }
            long millisBefore = System.currentTimeMillis();
            this.attackReq = this.callbacks.makeHttpRequest(baseRequestResponse.getHttpService(), req);
            byte[] resp = this.attackReq.getResponse();
            if (this.attackReq.getStatusCode() == 400 && this.tab.shellingPanel.includeLiteralWhites.isSelected() && this.tab.shellingPanel.smart400Avoidance.isSelected()) {
                for (int l = 0; l < payload.length; ++l) {
                    if (!this.tab.shellingPanel.containsBaddies(payload)) continue;
                    this.last400Avoid = true;
                    this.tab.shellingPanel.logOutput("A baddie detected, turning 400 avoidance on (means no more literal white chars in this scan task)!");
                    break;
                }
            }
            long millisAfter = System.currentTimeMillis();
            long diff = millisAfter - millisBefore;
            if (this.tab.shellingPanel.feedbackChannel == "time" && diff > (long)(delaySeconds * 1000)) {
                this.issues = new ArrayList<IScanIssue>(1);
                String details = "A potential OS command injection vulnerability was detected using time as the feedback channel.<br><br>";
                details = details + "The following payload was supplied to the <b>" + insertionPoint.getInsertionPointName() + "</b> input parameter: <b>" + this.helpers.bytesToString(payload) + "</b><br><br>";
                details = details + "The server took <b>" + Long.toString(diff) + "</b> miliseconds to respond.<br><br>";
                details = details + "Please be aware that delayed response can happen for multiple reasons, therefore comparing response time with the expected time of additional delay introduced by payloads like <b>sleep 25</b> or <b>ping -n25 localhost</b> is prone to false positives. Investigate this instance manually.<br><br>If you are getting too many false positivies, try to increase the delay in SHELLING -> Global settings or consider using a different feedback channel, e.g. DNS.";
                BinaryPayloadIssue issue = new BinaryPayloadIssue(this.callbacks, this.attackReq, details, "time");
                this.issues.add(issue);
                return this.issues;
            }
            if (this.tab.shellingPanel.feedbackChannel != "DNS" || ++counter % 200 != 0) continue;
            this.tab.shellingPanel.checkCollabInteractions(false);
        }
        if (this.tab.shellingPanel.feedbackChannel == "DNS") {
            try {
                Thread.sleep(10L);
                this.tab.shellingPanel.checkCollabInteractions(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

