/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry;

import eu.hansolo.fx.geometry.Path;
import eu.hansolo.fx.geometry.PathIterator;
import eu.hansolo.fx.geometry.QuadCurve;
import eu.hansolo.fx.geometry.transform.BaseTransform;
import java.util.NoSuchElementException;

class QuadIterator
implements PathIterator {
    QuadCurve quadCurve;
    BaseTransform transform;
    int index;

    QuadIterator(QuadCurve QUAD_CURVE, BaseTransform TRANSFORM) {
        this.quadCurve = QUAD_CURVE;
        this.transform = TRANSFORM;
    }

    @Override
    public Path.WindingRule getWindingRule() {
        return Path.WindingRule.WIND_NON_ZERO;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(double[] coords) {
        int type;
        if (this.isDone()) {
            throw new NoSuchElementException("quadCurve iterator iterator out of bounds");
        }
        if (this.index == 0) {
            coords[0] = this.quadCurve.x1;
            coords[1] = this.quadCurve.y1;
            type = 0;
        } else {
            coords[0] = this.quadCurve.ctrlx;
            coords[1] = this.quadCurve.ctrly;
            coords[2] = this.quadCurve.x2;
            coords[3] = this.quadCurve.y2;
            type = 2;
        }
        if (this.transform != null) {
            this.transform.transform(coords, 0, coords, 0, this.index == 0 ? 1 : 2);
        }
        return type;
    }
}

