/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry;

import eu.hansolo.fx.geometry.EllipseIterator;
import eu.hansolo.fx.geometry.PathIterator;
import eu.hansolo.fx.geometry.RectBounds;
import eu.hansolo.fx.geometry.RectangularShape;
import eu.hansolo.fx.geometry.transform.BaseTransform;

public class Ellipse
extends RectangularShape {
    public double x;
    public double y;
    public double width;
    public double height;

    public Ellipse() {
    }

    public Ellipse(double X, double Y, double WIDTH, double HEIGHT) {
        this.set(X, Y, WIDTH, HEIGHT);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public double getCenterX() {
        return (this.x + this.width) / 2.0;
    }

    @Override
    public double getCenterY() {
        return (this.y + this.height) / 2.0;
    }

    public double getRadiusX() {
        return this.width / 2.0;
    }

    public double getRadiusY() {
        return this.height / 2.0;
    }

    @Override
    public boolean isEmpty() {
        return Double.compare(this.width, 0.0) <= 0 || Double.compare(this.height, 0.0) <= 0;
    }

    @Override
    public void set(double X, double Y, double WIDTH, double HEIGHT) {
        this.x = X;
        this.y = Y;
        this.width = WIDTH;
        this.height = HEIGHT;
    }

    @Override
    public RectBounds getBounds() {
        return new RectBounds(this.x, this.y, this.x + this.width, this.y + this.height);
    }

    @Override
    public boolean intersects(double X, double Y, double WIDTH, double HEIGHT) {
        if (WIDTH <= 0.0 || HEIGHT <= 0.0) {
            return false;
        }
        double ellw = this.width;
        if (ellw <= 0.0) {
            return false;
        }
        double normx0 = (X - this.x) / ellw - 0.5;
        double normx1 = normx0 + WIDTH / ellw;
        double ellh = this.height;
        if (ellh <= 0.0) {
            return false;
        }
        double normy0 = (Y - this.y) / ellh - 0.5;
        double normy1 = normy0 + HEIGHT / ellh;
        double nearx = normx0 > 0.0 ? normx0 : (normx1 < 0.0 ? normx1 : 0.0);
        double neary = normy0 > 0.0 ? normy0 : (normy1 < 0.0 ? normy1 : 0.0);
        return nearx * nearx + neary * neary < 0.25;
    }

    @Override
    public boolean contains(double X, double Y) {
        double ellw = this.width;
        if (ellw <= 0.0) {
            return false;
        }
        double normx = (X - this.x) / ellw - 0.5;
        double ellh = this.height;
        if (ellh <= 0.0) {
            return false;
        }
        double normy = (Y - this.y) / ellh - 0.5;
        return normx * normx + normy * normy < 0.25;
    }

    @Override
    public boolean contains(double X, double Y, double WIDTH, double HEIGHT) {
        return this.contains(X, Y) && this.contains(X + WIDTH, Y) && this.contains(X, Y + HEIGHT) && this.contains(X + WIDTH, Y + HEIGHT);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform TRANSFORM) {
        return new EllipseIterator(this, TRANSFORM);
    }

    @Override
    public Ellipse copy() {
        return new Ellipse(this.x, this.y, this.width, this.height);
    }

    public boolean equals(Object OBJECT) {
        if (OBJECT == this) {
            return true;
        }
        if (OBJECT instanceof Ellipse) {
            Ellipse e2d = (Ellipse)OBJECT;
            return this.x == e2d.x && this.y == e2d.y && this.width == e2d.width && this.height == e2d.height;
        }
        return false;
    }
}

