/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.tools;

import eu.hansolo.fx.charts.tools.Helper;

public class CtxBounds {
    private double x;
    private double y;
    private double width;
    private double height;
    private double oldX;
    private double oldY;
    private double oldWidth;
    private double oldHeight;

    public CtxBounds() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public CtxBounds(double WIDTH, double HEIGHT) {
        this(0.0, 0.0, WIDTH, HEIGHT);
    }

    public CtxBounds(double X, double Y, double WIDTH, double HEIGHT) {
        this.x = X;
        this.y = Y;
        this.width = WIDTH;
        this.height = HEIGHT;
    }

    public double getOldX() {
        return this.oldX;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double X) {
        this.oldX = this.x;
        this.x = X;
    }

    public double getOldY() {
        return this.oldY;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double Y) {
        this.oldY = this.y;
        this.y = Y;
    }

    public double getOldMinX() {
        return this.oldX;
    }

    public double getMinX() {
        return this.x;
    }

    public double getOldMaxX() {
        return this.oldX + this.oldWidth;
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public double getOldMinY() {
        return this.oldY;
    }

    public double getMinY() {
        return this.y;
    }

    public double getOldMaxY() {
        return this.oldY + this.oldHeight;
    }

    public double getMaxY() {
        return this.y + this.height;
    }

    public double getOldWidth() {
        return this.oldWidth;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double WIDTH) {
        this.oldWidth = this.width;
        this.width = Helper.clamp(0.0, Double.MAX_VALUE, WIDTH);
    }

    public double getOldHeight() {
        return this.oldHeight;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double HEIGHT) {
        this.oldHeight = this.height;
        this.height = Helper.clamp(0.0, Double.MAX_VALUE, HEIGHT);
    }

    public void shiftX(double SHIFT_X) {
        this.setX(this.x + SHIFT_X);
    }

    public void shiftY(double SHIFT_Y) {
        this.setY(this.x + SHIFT_Y);
    }

    public double getCenterX() {
        return this.x + this.width * 0.5;
    }

    public double getCenterY() {
        return this.y + this.height * 0.5;
    }

    public void set(CtxBounds BOUNDS) {
        this.setX(BOUNDS.getX());
        this.setY(BOUNDS.getY());
        this.setWidth(BOUNDS.getWidth());
        this.setHeight(BOUNDS.getHeight());
    }

    public void set(double X, double Y, double WIDTH, double HEIGHT) {
        this.setX(X);
        this.setY(Y);
        this.setWidth(WIDTH);
        this.setHeight(HEIGHT);
    }

    public boolean contains(double X, double Y) {
        return Double.compare(X, this.getMinX()) >= 0 && Double.compare(X, this.getMaxX()) <= 0 && Double.compare(Y, this.getMinY()) >= 0 && Double.compare(Y, this.getMaxY()) <= 0;
    }

    public String toString() {
        return "{\n" + "  \"minX\"  : " + this.getMinX() + ",\n" + "  \"minY\"  : " + this.getMinY() + ",\n" + "  \"maxX\"  : " + this.getMaxX() + ",\n" + "  \"maxY\"  : " + this.getMaxY() + ",\n" + "  \"width\" : " + this.getWidth() + ",\n" + "  \"height\": " + this.getHeight() + "\n" + "}";
    }
}

