/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.series;

import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.event.EventType;
import eu.hansolo.fx.charts.event.SeriesEvent;
import eu.hansolo.fx.charts.event.SeriesEventListener;
import eu.hansolo.fx.charts.tools.Helper;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.LongProperty;
import javafx.beans.property.LongPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public abstract class Series<T extends Item> {
    public final SeriesEvent UPDATE_EVENT = new SeriesEvent(this, EventType.UPDATE);
    protected String _name;
    protected StringProperty name;
    protected Paint _fill;
    protected ObjectProperty<Paint> fill;
    protected Paint _stroke;
    protected ObjectProperty<Paint> stroke;
    protected Color _textFill;
    protected ObjectProperty<Color> textFill;
    protected Color _symbolFill;
    protected ObjectProperty<Color> symbolFill;
    protected Color _symbolStroke;
    protected ObjectProperty<Color> symbolStroke;
    protected Symbol _symbol;
    protected ObjectProperty<Symbol> symbol;
    protected boolean _symbolsVisible;
    protected BooleanProperty symbolsVisible;
    protected double _symbolSize;
    protected DoubleProperty symbolSize;
    protected double _strokeWidth;
    protected DoubleProperty strokeWidth;
    protected boolean _animated;
    protected BooleanProperty animated;
    protected long _animationDuration;
    protected LongProperty animationDuration;
    protected ChartType chartType;
    protected ObservableList<T> items;
    private CopyOnWriteArrayList<SeriesEventListener> listeners;
    private ListChangeListener<T> itemListener;

    public Series() {
        this(null, ChartType.SCATTER, "", (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, Symbol.CIRCLE);
    }

    public Series(T ... ITEMS) {
        this(Arrays.asList(ITEMS), ChartType.SCATTER, "", (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, Symbol.CIRCLE);
    }

    public Series(ChartType TYPE, T ... ITEMS) {
        this(Arrays.asList(ITEMS), TYPE, "", (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, Symbol.CIRCLE);
    }

    public Series(List<T> ITEMS, ChartType TYPE) {
        this(ITEMS, TYPE, "", (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, Symbol.CIRCLE);
    }

    public Series(ChartType TYPE, String NAME, T ... ITEMS) {
        this(Arrays.asList(ITEMS), TYPE, NAME, (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, Symbol.CIRCLE);
    }

    public Series(List<T> ITEMS, ChartType TYPE, String NAME) {
        this(ITEMS, TYPE, NAME, (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, Symbol.CIRCLE);
    }

    public Series(List<T> ITEMS, ChartType TYPE, String NAME, Symbol SYMBOL) {
        this(ITEMS, TYPE, NAME, (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Color.BLACK, Color.BLACK, SYMBOL);
    }

    public Series(ChartType TYPE, String NAME, Paint FILL, Paint STROKE, Symbol SYMBOL, T ... ITEMS) {
        this(Arrays.asList(ITEMS), TYPE, NAME, FILL, STROKE, Color.BLACK, Color.BLACK, SYMBOL);
    }

    public Series(List<T> ITEMS, ChartType TYPE, String NAME, Paint FILL, Paint STROKE, Symbol SYMBOL) {
        this(ITEMS, TYPE, NAME, FILL, STROKE, Color.BLACK, Color.BLACK, SYMBOL);
    }

    public Series(List<T> ITEMS, ChartType TYPE, String NAME, Paint FILL, Paint STROKE, Color SYMBOL_FILL, Color SYMBOL_STROKE, Symbol SYMBOL) {
        this._name = NAME;
        this._fill = FILL;
        this._stroke = STROKE;
        this._textFill = Color.BLACK;
        this._symbolFill = SYMBOL_FILL;
        this._symbolStroke = SYMBOL_STROKE;
        this._symbol = SYMBOL;
        this._symbolsVisible = true;
        this._symbolSize = -1.0;
        this._strokeWidth = -1.0;
        this._animated = false;
        this._animationDuration = 800L;
        this.chartType = TYPE;
        this.items = FXCollections.observableArrayList();
        this.listeners = new CopyOnWriteArrayList();
        if (null != ITEMS) {
            this.items.setAll(ITEMS);
        }
    }

    private void init() {
        this.itemListener = change -> this.fireSeriesEvent(this.UPDATE_EVENT);
    }

    private void registerListeners() {
        this.items.addListener(this.itemListener);
    }

    public ObservableList<T> getItems() {
        return this.items;
    }

    public void setItems(T ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<T> ITEMS) {
        this.items.setAll(ITEMS);
    }

    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String NAME) {
        if (null == this.name) {
            this._name = NAME;
            this.fireSeriesEvent(this.UPDATE_EVENT);
        } else {
            this.name.set((Object)NAME);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    Series.this.fireSeriesEvent(Series.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    public Paint getFill() {
        return null == this.fill ? this._fill : (Paint)this.fill.get();
    }

    public void setFill(Paint PAINT) {
        if (null == this.fill) {
            this._fill = PAINT;
            this.refresh();
        } else {
            this.fill.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> fillProperty() {
        if (null == this.fill) {
            this.fill = new ObjectPropertyBase<Paint>(this._fill){

                protected void invalidated() {
                    Series.this.refresh();
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    public Paint getStroke() {
        return null == this.stroke ? this._stroke : (Paint)this.stroke.get();
    }

    public void setStroke(Paint PAINT) {
        if (null == this.stroke) {
            this._stroke = PAINT;
            this.refresh();
        } else {
            this.stroke.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> strokeProperty() {
        if (null == this.stroke) {
            this.stroke = new ObjectPropertyBase<Paint>(this._stroke){

                protected void invalidated() {
                    Series.this.refresh();
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    public Color getTextFill() {
        return null == this.textFill ? this._textFill : (Color)this.textFill.get();
    }

    public void setTextFill(Color COLOR) {
        if (null == this.textFill) {
            this._textFill = COLOR;
            this.refresh();
        } else {
            this.textFill.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textFillProperty() {
        if (null == this.textFill) {
            this.textFill = new ObjectPropertyBase<Color>(this._textFill){

                protected void invalidated() {
                    Series.this.refresh();
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "textFill";
                }
            };
            this._textFill = null;
        }
        return this.textFill;
    }

    public Color getSymbolFill() {
        return null == this.symbolFill ? this._symbolFill : (Color)this.symbolFill.get();
    }

    public void setSymbolFill(Color COLOR) {
        if (null == this.symbolFill) {
            this._symbolFill = COLOR;
            this.refresh();
        } else {
            this.symbolFill.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> symbolFillProperty() {
        if (null == this.symbolFill) {
            this.symbolFill = new ObjectPropertyBase<Color>(this._symbolFill){

                protected void invalidated() {
                    Series.this.refresh();
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "symbolFill";
                }
            };
            this._symbolFill = null;
        }
        return this.symbolFill;
    }

    public Color getSymbolStroke() {
        return null == this.symbolStroke ? this._symbolStroke : (Color)this.symbolStroke.get();
    }

    public void setSymbolStroke(Color COLOR) {
        if (null == this.symbolStroke) {
            this._symbolStroke = COLOR;
            this.refresh();
        } else {
            this.symbolStroke.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> symbolStrokeProperty() {
        if (null == this.symbolStroke) {
            this.symbolStroke = new ObjectPropertyBase<Color>(this._symbolStroke){

                protected void invalidated() {
                    Series.this.refresh();
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "symbolStroke";
                }
            };
            this._symbolStroke = null;
        }
        return this.symbolStroke;
    }

    public Symbol getSymbol() {
        return null == this.symbol ? this._symbol : (Symbol)((Object)this.symbol.get());
    }

    public void setSymbol(Symbol SYMBOL) {
        if (null == this.symbol) {
            this._symbol = SYMBOL;
            this.fireSeriesEvent(this.UPDATE_EVENT);
        } else {
            this.symbol.set((Object)SYMBOL);
        }
    }

    public ObjectProperty<Symbol> symbolProperty() {
        if (null == this.symbol) {
            this.symbol = new ObjectPropertyBase<Symbol>(this._symbol){

                protected void invalidated() {
                    Series.this.fireSeriesEvent(Series.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "symbol";
                }
            };
            this._symbol = null;
        }
        return this.symbol;
    }

    public boolean getSymbolsVisible() {
        return null == this.symbolsVisible ? this._symbolsVisible : this.symbolsVisible.get();
    }

    public void setSymbolsVisible(boolean VISIBLE) {
        if (null == this.symbolsVisible) {
            this._symbolsVisible = VISIBLE;
            this.fireSeriesEvent(this.UPDATE_EVENT);
        } else {
            this.symbolsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty symbolsVisibleProperty() {
        if (null == this.symbolsVisible) {
            this.symbolsVisible = new BooleanPropertyBase(this._symbolsVisible){

                protected void invalidated() {
                    Series.this.fireSeriesEvent(Series.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "symbolsVisible";
                }
            };
        }
        return this.symbolsVisible;
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public void setChartType(ChartType TYPE) {
        this.chartType = TYPE;
        this.refresh();
    }

    public double getSymbolSize() {
        return null == this.symbolSize ? this._symbolSize : this.symbolSize.get();
    }

    public void setSymbolSize(double SIZE) {
        if (null == this.symbolSize) {
            this._symbolSize = Helper.clamp(1.0, 24.0, SIZE);
            this.fireSeriesEvent(this.UPDATE_EVENT);
        } else {
            this.symbolSize.set(SIZE);
        }
    }

    public DoubleProperty symbolSizeProperty() {
        if (null == this.symbolSize) {
            this.symbolSize = new DoublePropertyBase(this._symbolSize){

                protected void invalidated() {
                    this.set(Helper.clamp(1.0, 24.0, this.get()));
                    Series.this.fireSeriesEvent(Series.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "symbolSize";
                }
            };
        }
        return this.symbolSize;
    }

    public double getStrokeWidth() {
        return null == this.strokeWidth ? this._strokeWidth : this.strokeWidth.get();
    }

    public void setStrokeWidth(double WIDTH) {
        if (null == this.strokeWidth) {
            this._strokeWidth = Helper.clamp(1.0, 24.0, WIDTH);
            this.fireSeriesEvent(this.UPDATE_EVENT);
        } else {
            this.strokeWidth.set(WIDTH);
        }
    }

    public DoubleProperty strokeWidthProperty() {
        if (null == this.strokeWidth) {
            this.strokeWidth = new DoublePropertyBase(this._strokeWidth){

                protected void invalidated() {
                    this.set(Helper.clamp(1.0, 24.0, this.get()));
                    Series.this.fireSeriesEvent(Series.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "strokeWidth";
                }
            };
        }
        return this.strokeWidth;
    }

    public boolean isAnimated() {
        return null == this.animated ? this._animated : this.animated.get();
    }

    public void setAnimated(boolean ANIMATED) {
        if (null == this.animated) {
            this._animated = ANIMATED;
        } else {
            this.animated.set(ANIMATED);
        }
    }

    public BooleanProperty animatedProperty() {
        if (null == this.animated) {
            this.animated = new BooleanPropertyBase(this._animated){

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "animated";
                }
            };
        }
        return this.animated;
    }

    public long getAnimationDuration() {
        return null == this.animationDuration ? this._animationDuration : this.animationDuration.get();
    }

    public void setAnimationDuration(long DURATION) {
        if (null == this.animationDuration) {
            this._animationDuration = Helper.clamp(10L, 10000L, DURATION);
        } else {
            this.animationDuration.set(Helper.clamp(10L, 10000L, DURATION));
        }
    }

    public LongProperty animationDurationProperty() {
        if (null == this.animationDuration) {
            this.animationDuration = new LongPropertyBase(this._animationDuration){

                public Object getBean() {
                    return Series.this;
                }

                public String getName() {
                    return "animationDuration";
                }
            };
        }
        return this.animationDuration;
    }

    public int getNoOfItems() {
        return this.items.size();
    }

    public void dispose() {
        this.items.remove(this.itemListener);
    }

    public void refresh() {
        this.fireSeriesEvent(this.UPDATE_EVENT);
    }

    public void setOnSeriesEvent(SeriesEventListener LISTENER) {
        this.addSeriesEventListener(LISTENER);
    }

    public void addSeriesEventListener(SeriesEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeSeriesEventListener(SeriesEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void fireSeriesEvent(SeriesEvent EVENT) {
        for (SeriesEventListener listener : this.listeners) {
            listener.onModelEvent(EVENT);
        }
    }
}

