/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.SunburstChart;
import eu.hansolo.fx.charts.data.TreeNode;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class SunburstChartBuilder<B extends SunburstChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected SunburstChartBuilder() {
    }

    public static final SunburstChartBuilder create() {
        return new SunburstChartBuilder();
    }

    public final B tree(TreeNode TREE) {
        this.properties.put("tree", (Property)new SimpleObjectProperty((Object)TREE));
        return (B)this;
    }

    public final B visibleData(SunburstChart.VisibleData VISIBLE_DATA) {
        this.properties.put("visibleData", (Property)new SimpleObjectProperty((Object)VISIBLE_DATA));
        return (B)this;
    }

    public final B textOrientation(SunburstChart.TextOrientation ORIENTATION) {
        this.properties.put("textOrientation", (Property)new SimpleObjectProperty((Object)ORIENTATION));
        return (B)this;
    }

    public final B backgroundColor(Color COLOR) {
        this.properties.put("backgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B useColorFromParent(boolean USE) {
        this.properties.put("useColorFromParent", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B interactive(boolean INTERACTIVE) {
        this.properties.put("interactive", (Property)new SimpleBooleanProperty(INTERACTIVE));
        return (B)this;
    }

    public final B autoTextColor(boolean AUTOMATIC) {
        this.properties.put("autoTextColor", (Property)new SimpleBooleanProperty(AUTOMATIC));
        return (B)this;
    }

    public final B brightTextColor(Color COLOR) {
        this.properties.put("brightTextColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B darkTextColor(Color COLOR) {
        this.properties.put("darkTextColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B useChartItemTextColor(boolean USE) {
        this.properties.put("useChartItemTextColor", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final SunburstChart build() {
        SunburstChart CONTROL = this.properties.containsKey("tree") ? new SunburstChart((TreeNode)((ObjectProperty)this.properties.get("tree")).get()) : new SunburstChart();
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                CONTROL.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("visibleData".equals(key)) {
                CONTROL.setVisibleData((SunburstChart.VisibleData)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("textOrientation".equals(key)) {
                CONTROL.setTextOrientation((SunburstChart.TextOrientation)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("backgroundColor".equals(key)) {
                CONTROL.setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textColor".equals(key)) {
                CONTROL.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("useColorFromParent".equals(key)) {
                CONTROL.setUseColorFromParent(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("decimals".equals(key)) {
                CONTROL.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("interactive".equals(key)) {
                CONTROL.setInteractive(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("autoTextColor".equals(key)) {
                CONTROL.setAutoTextColor(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("brightTextColor".equals(key)) {
                CONTROL.setBrightTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("darkTextColor".equals(key)) {
                CONTROL.setDarkTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"useChartItemTextColor".equals(key)) continue;
            CONTROL.setUseChartItemTextColor(((BooleanProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

