/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.EventType;
import eu.hansolo.fx.charts.event.ItemEventListener;
import eu.hansolo.fx.charts.event.SelectionEvent;
import eu.hansolo.fx.charts.event.SelectionEventListener;
import eu.hansolo.fx.charts.font.Fonts;
import eu.hansolo.fx.charts.series.Series;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.InfoPopup;
import eu.hansolo.fx.charts.tools.NumberFormat;
import eu.hansolo.fx.charts.tools.Order;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class ConcentricRingChart
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;
    private ObservableList<ChartItem> items = FXCollections.observableArrayList();
    private Color _barBackgroundFill;
    private ObjectProperty<Color> barBackgroundFill;
    private boolean _sorted;
    private BooleanProperty sorted;
    private Order _order;
    private ObjectProperty<Order> order;
    private NumberFormat _numberFormat;
    private ObjectProperty<NumberFormat> numberFormat;
    private Color _itemLabelFill;
    private ObjectProperty<Color> itemLabelFill;
    private ListChangeListener<ChartItem> chartItemListener;
    private ItemEventListener itemEventListener;
    private EventHandler<MouseEvent> mouseHandler;
    private CopyOnWriteArrayList<SelectionEventListener> listeners;
    private InfoPopup popup;

    public ConcentricRingChart() {
        this(new ArrayList<ChartItem>());
    }

    public ConcentricRingChart(ChartItem ... ITEMS) {
        this(Arrays.asList(ITEMS));
    }

    public ConcentricRingChart(List<ChartItem> ITEMS) {
        this.items.setAll(ITEMS);
        this._barBackgroundFill = Color.rgb((int)230, (int)230, (int)230);
        this._sorted = false;
        this._order = Order.ASCENDING;
        this._numberFormat = NumberFormat.NUMBER;
        this._itemLabelFill = Color.BLACK;
        this.listeners = new CopyOnWriteArrayList();
        this.popup = new InfoPopup();
        this.itemEventListener = e -> {
            EventType TYPE = e.getEventType();
            switch (TYPE) {
                case UPDATE: {
                    this.drawChart();
                    break;
                }
                case FINISHED: {
                    this.drawChart();
                }
            }
        };
        this.chartItemListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedItem -> addedItem.addItemEventListener(this.itemEventListener));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedItem -> removedItem.removeItemEventListener(this.itemEventListener));
            }
            this.drawChart();
        };
        this.mouseHandler = e -> this.handleMouseEvents((MouseEvent)e);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.getStyleClass().add((Object)"concentric-ring-chart");
        this.canvas = new Canvas(this.size * 0.9, 0.9);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.items.forEach(chartitem -> chartitem.addItemEventListener(this.itemEventListener));
        this.items.addListener(this.chartItemListener);
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.setOnSelectionEvent(e -> {
            this.popup.update(e);
            this.popup.animatedShow(this.getScene().getWindow());
        });
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public List<ChartItem> getItems() {
        return this.items;
    }

    public void setItems(Series<ChartItem> SERIES) {
        ObservableList<ChartItem> seriesItems = SERIES.getItems();
        boolean animated = SERIES.isAnimated();
        long animationDuration = SERIES.getAnimationDuration();
        Paint fill = SERIES.getFill();
        boolean isColor = fill instanceof Color;
        Color barColor = isColor ? (Color)fill : null;
        Color textFill = SERIES.getTextFill();
        seriesItems.forEach(item -> {
            if (animated) {
                item.setAnimated(animated);
            }
            item.setAnimationDuration(animationDuration);
            if (isColor) {
                item.setFill(barColor);
            }
            item.setTextFill(textFill);
        });
        this.setItems((List<ChartItem>)seriesItems);
    }

    public void setItems(ChartItem ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<ChartItem> ITEMS) {
        this.items.setAll(ITEMS);
    }

    public void addItem(ChartItem ITEM) {
        if (!this.items.contains((Object)ITEM)) {
            this.items.add((Object)ITEM);
        }
    }

    public void addItems(ChartItem ... ITEMS) {
        this.addItems(Arrays.asList(ITEMS));
    }

    public void addItems(List<ChartItem> ITEMS) {
        ITEMS.forEach(item -> this.addItem((ChartItem)item));
    }

    public void removeItem(ChartItem ITEM) {
        if (this.items.contains((Object)ITEM)) {
            this.items.remove((Object)ITEM);
        }
    }

    public void removeItems(ChartItem ... ITEMS) {
        this.removeItems(Arrays.asList(ITEMS));
    }

    public void removeItems(List<ChartItem> ITEMS) {
        ITEMS.forEach(item -> this.removeItem((ChartItem)item));
    }

    public Color getBarBackgroundFill() {
        return null == this.barBackgroundFill ? this._barBackgroundFill : (Color)this.barBackgroundFill.get();
    }

    public void setBarBackgroundFill(Color FILL) {
        if (null == this.barBackgroundFill) {
            this._barBackgroundFill = FILL;
            this.redraw();
        } else {
            this.barBackgroundFill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> barBackgroundFillProperty() {
        if (null == this.barBackgroundFill) {
            this.barBackgroundFill = new ObjectPropertyBase<Color>(this._barBackgroundFill){

                protected void invalidated() {
                    ConcentricRingChart.this.redraw();
                }

                public Object getBean() {
                    return ConcentricRingChart.this;
                }

                public String getName() {
                    return "barBackgroundFill";
                }
            };
            this._barBackgroundFill = null;
        }
        return this.barBackgroundFill;
    }

    public boolean isSorted() {
        return null == this.sorted ? this._sorted : this.sorted.get();
    }

    public void setSorted(boolean SORTED) {
        if (null == this.sorted) {
            this._sorted = SORTED;
            this.redraw();
        } else {
            this.sorted.set(SORTED);
        }
    }

    public BooleanProperty sortedProperty() {
        if (null == this.sorted) {
            this.sorted = new BooleanPropertyBase(this._sorted){

                protected void invalidated() {
                    ConcentricRingChart.this.redraw();
                }

                public Object getBean() {
                    return ConcentricRingChart.this;
                }

                public String getName() {
                    return "sorted";
                }
            };
        }
        return this.sorted;
    }

    public Order getOrder() {
        return null == this.order ? this._order : (Order)((Object)this.order.get());
    }

    public void setOrder(Order ORDER) {
        if (null == this.order) {
            this._order = ORDER;
            this.redraw();
        } else {
            this.order.set((Object)ORDER);
        }
    }

    public ObjectProperty<Order> orderProperty() {
        if (null == this.order) {
            this.order = new ObjectPropertyBase<Order>(this._order){

                protected void invalidated() {
                    ConcentricRingChart.this.redraw();
                }

                public Object getBean() {
                    return ConcentricRingChart.this;
                }

                public String getName() {
                    return "order";
                }
            };
            this._order = null;
        }
        return this.order;
    }

    public NumberFormat getNumberFormat() {
        return null == this.numberFormat ? this._numberFormat : (NumberFormat)((Object)this.numberFormat.get());
    }

    public void setNumberFormat(NumberFormat FORMAT) {
        if (null == this.numberFormat) {
            this._numberFormat = FORMAT;
            this.updatePopup();
            this.redraw();
        } else {
            this.numberFormat.set((Object)FORMAT);
        }
    }

    public ObjectProperty<NumberFormat> numberFormatProperty() {
        if (null == this.numberFormat) {
            this.numberFormat = new ObjectPropertyBase<NumberFormat>(this._numberFormat){

                protected void invalidated() {
                    ConcentricRingChart.this.updatePopup();
                    ConcentricRingChart.this.redraw();
                }

                public Object getBean() {
                    return ConcentricRingChart.this;
                }

                public String getName() {
                    return "numberFormat";
                }
            };
            this._numberFormat = null;
        }
        return this.numberFormat;
    }

    public Color getItemLabelFill() {
        return null == this.itemLabelFill ? this._itemLabelFill : (Color)this.itemLabelFill.get();
    }

    public void setItemLabelFill(Color FILL) {
        if (null == this.itemLabelFill) {
            this._itemLabelFill = FILL;
            this.redraw();
        } else {
            this.itemLabelFill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> itemLabelFillProperty() {
        if (null == this.itemLabelFill) {
            this.itemLabelFill = new ObjectPropertyBase<Color>(this._itemLabelFill){

                protected void invalidated() {
                    ConcentricRingChart.this.redraw();
                }

                public Object getBean() {
                    return ConcentricRingChart.this;
                }

                public String getName() {
                    return "itemLabelFill";
                }
            };
            this._itemLabelFill = null;
        }
        return this.itemLabelFill;
    }

    private void handleMouseEvents(MouseEvent EVT) {
        double maxValue;
        double centerX;
        double x = EVT.getX();
        double y = EVT.getY();
        double centerY = centerX = this.size * 0.5;
        double radius = this.size * 0.5;
        double innerSpacer = radius * 0.18;
        double barSpacer = (radius - innerSpacer) * 0.005;
        int noOfItems = this.items.size();
        double barWidth = (radius - innerSpacer - (double)(noOfItems - 1) * barSpacer) / (double)noOfItems;
        double startAngle = 0.0;
        double d = maxValue = noOfItems == 0 ? 0.0 : this.items.stream().max(Comparator.comparingDouble(ChartItem::getValue)).get().getValue();
        Object sortedItems = this.isSorted() ? (Order.ASCENDING == this.getOrder() ? this.items.stream().sorted(Comparator.comparingDouble(ChartItem::getValue)).collect(Collectors.toList()) : this.items.stream().sorted(Comparator.comparingDouble(ChartItem::getValue).reversed()).collect(Collectors.toList())) : this.items;
        for (int i = 0; i < noOfItems; ++i) {
            double barWH = this.size - barWidth - ((double)(2 * i) * barWidth - barSpacer) - (double)(2 * i) * barSpacer;
            ChartItem item = (ChartItem)sortedItems.get(i);
            double value = Helper.clamp(0.0, Double.MAX_VALUE, item.getValue());
            double angle = value / maxValue * 270.0;
            boolean hit = Helper.isInRingSegment(x, y, centerX, centerY, (barWH + barWidth) * 0.5, (barWH - barWidth) * 0.5, startAngle, angle);
            if (!hit) continue;
            this.popup.setX(EVT.getScreenX());
            this.popup.setY(EVT.getScreenY() - this.popup.getHeight());
            this.fireSelectionEvent(new SelectionEvent<ChartItem>(item));
            break;
        }
    }

    private void updatePopup() {
        switch (this.getNumberFormat()) {
            case NUMBER: {
                this.popup.setDecimals(0);
                break;
            }
            case FLOAT_1_DECIMAL: {
                this.popup.setDecimals(1);
                break;
            }
            case FLOAT_2_DECIMALS: {
                this.popup.setDecimals(2);
                break;
            }
            case FLOAT: {
                this.popup.setDecimals(8);
                break;
            }
            case PERCENTAGE: {
                this.popup.setDecimals(0);
                break;
            }
            case PERCENTAGE_1_DECIMAL: {
                this.popup.setDecimals(1);
            }
        }
    }

    public void setOnSelectionEvent(SelectionEventListener LISTENER) {
        this.addSelectionEventListener(LISTENER);
    }

    public void addSelectionEventListener(SelectionEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeSelectionEventListener(SelectionEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void removeAllSelectionEventListeners() {
        this.listeners.clear();
    }

    public void fireSelectionEvent(SelectionEvent EVENT) {
        for (SelectionEventListener listener : this.listeners) {
            listener.onSelectionEvent(EVENT);
        }
    }

    private void drawChart() {
        double centerX;
        double centerY = centerX = this.size * 0.5;
        double radius = this.size * 0.5;
        double innerSpacer = radius * 0.18;
        double barSpacer = (radius - innerSpacer) * 0.005;
        int noOfItems = this.items.size();
        double barWidth = (radius - innerSpacer - (double)(noOfItems - 1) * barSpacer) / (double)noOfItems;
        double maxValue = noOfItems == 0 ? 0.0 : this.items.stream().max(Comparator.comparingDouble(ChartItem::getValue)).get().getValue();
        double nameX = radius * 0.975;
        double nameWidth = radius * 0.95;
        NumberFormat numberFormat = this.getNumberFormat();
        Color barBackgroundFill = this.getBarBackgroundFill();
        Color itemLabelFill = this.getItemLabelFill();
        List<Object> sortedItems = this.isSorted() ? (Order.ASCENDING == this.getOrder() ? this.items.stream().sorted(Comparator.comparingDouble(ChartItem::getValue)).collect(Collectors.toList()) : this.items.stream().sorted(Comparator.comparingDouble(ChartItem::getValue).reversed()).collect(Collectors.toList())) : this.items;
        this.ctx.clearRect(0.0, 0.0, this.size, this.size);
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.ctx.setTextAlign(TextAlignment.RIGHT);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setFont(Fonts.latoRegular(barWidth * 0.5));
        for (int i = 0; i < noOfItems; ++i) {
            ChartItem item = (ChartItem)sortedItems.get(i);
            double value = Helper.clamp(0.0, Double.MAX_VALUE, item.getValue());
            double barXY = barWidth * 0.5 + (double)i * barWidth + (double)i * barSpacer + 1.0;
            double barWH = this.size - barWidth - ((double)(2 * i) * barWidth - barSpacer) - (double)(2 * i) * barSpacer - 2.0;
            double angle = value / maxValue * 270.0;
            this.ctx.setLineWidth(barWidth);
            this.ctx.setStroke((Paint)barBackgroundFill);
            this.ctx.strokeArc(barXY, barXY, barWH, barWH, 90.0, -270.0, ArcType.OPEN);
            this.ctx.setStroke((Paint)item.getFill());
            this.ctx.strokeArc(barXY, barXY, barWH, barWH, 90.0, -angle, ArcType.OPEN);
            this.ctx.setFill((Paint)itemLabelFill);
            this.ctx.setTextAlign(TextAlignment.RIGHT);
            this.ctx.fillText(item.getName(), nameX, barXY, nameWidth);
            this.ctx.setTextAlign(TextAlignment.LEFT);
            this.ctx.setFill((Paint)item.getTextFill());
            if (NumberFormat.PERCENTAGE == numberFormat || NumberFormat.PERCENTAGE_1_DECIMAL == numberFormat) {
                this.drawTextAlongArc(this.ctx, String.format(Locale.US, numberFormat.formatString(), value / maxValue * 100.0), centerX, centerY, barWH * 0.5, angle);
                continue;
            }
            this.drawTextAlongArc(this.ctx, String.format(Locale.US, numberFormat.formatString(), value), centerX, centerY, barWH * 0.5, angle);
        }
    }

    private void drawTextAlongArc(GraphicsContext CTX, String TEXT, double CENTER_X, double CENTER_Y, double RADIUS, double ANGLE) {
        double charSpacer = 7.0 / RADIUS * this.size * 0.13;
        int length = TEXT.length();
        double textAngle = charSpacer * ((double)length + 0.5);
        if (ANGLE > textAngle) {
            CTX.save();
            CTX.translate(CENTER_X, CENTER_Y);
            CTX.rotate(ANGLE - charSpacer * ((double)length + 0.5));
            for (int i = 0; i < length; ++i) {
                CTX.save();
                CTX.translate(0.0, -1.0 * RADIUS);
                char c = TEXT.charAt(i);
                CTX.fillText(Character.toString(c), 0.0, 0.0);
                CTX.restore();
                CTX.rotate(charSpacer);
            }
            CTX.restore();
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.redraw();
        }
    }

    private void redraw() {
        this.drawChart();
    }
}

