/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.EventType;
import eu.hansolo.fx.charts.event.ItemEventListener;
import eu.hansolo.fx.charts.event.SelectionEvent;
import eu.hansolo.fx.charts.event.SelectionEventListener;
import eu.hansolo.fx.charts.font.Fonts;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.series.Series;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.InfoPopup;
import eu.hansolo.fx.charts.tools.NumberFormat;
import eu.hansolo.fx.charts.tools.Order;
import java.util.Comparator;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class ComparisonRingChart
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;
    private ChartItemSeries<ChartItem> series1;
    private ChartItemSeries<ChartItem> series2;
    private Color _barBackgroundFill;
    private ObjectProperty<Color> barBackgroundFill;
    private boolean _sorted;
    private BooleanProperty sorted;
    private Order _order;
    private ObjectProperty<Order> order;
    private NumberFormat _numberFormat;
    private ObjectProperty<NumberFormat> numberFormat;
    private ListChangeListener<ChartItem> chartItemListener;
    private ItemEventListener itemEventListener;
    private EventHandler<MouseEvent> mouseHandler;
    private CopyOnWriteArrayList<SelectionEventListener> listeners;
    private InfoPopup popup;

    public ComparisonRingChart(ChartItemSeries SERIES_1, ChartItemSeries SERIES_2) {
        this.series1 = SERIES_1;
        this.series2 = SERIES_2;
        this._barBackgroundFill = Color.rgb((int)230, (int)230, (int)230);
        this._sorted = true;
        this._order = Order.DESCENDING;
        this._numberFormat = NumberFormat.NUMBER;
        this.listeners = new CopyOnWriteArrayList();
        this.popup = new InfoPopup();
        this.itemEventListener = e -> {
            EventType TYPE = e.getEventType();
            switch (TYPE) {
                case UPDATE: {
                    this.drawChart();
                    break;
                }
                case FINISHED: {
                    this.drawChart();
                }
            }
        };
        this.chartItemListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedItem -> addedItem.addItemEventListener(this.itemEventListener));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedItem -> removedItem.removeItemEventListener(this.itemEventListener));
            }
            this.drawChart();
        };
        this.mouseHandler = e -> this.handleMouseEvents((MouseEvent)e);
        this.prepareSeries(this.series1);
        this.prepareSeries(this.series2);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.getStyleClass().add((Object)"comparison-ring-chart");
        this.canvas = new Canvas(this.size * 0.9, 0.9);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.series1.getItems().forEach(item -> item.addItemEventListener(this.itemEventListener));
        this.series2.getItems().forEach(item -> item.addItemEventListener(this.itemEventListener));
        this.series1.getItems().addListener(this.chartItemListener);
        this.series2.getItems().addListener(this.chartItemListener);
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.setOnSelectionEvent(e -> {
            this.popup.update(e);
            this.popup.animatedShow(this.getScene().getWindow());
        });
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public Color getBarBackgroundFill() {
        return null == this.barBackgroundFill ? this._barBackgroundFill : (Color)this.barBackgroundFill.get();
    }

    public void setBarBackgroundFill(Color FILL) {
        if (null == this.barBackgroundFill) {
            this._barBackgroundFill = FILL;
            this.redraw();
        } else {
            this.barBackgroundFill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> barBackgroundFillProperty() {
        if (null == this.barBackgroundFill) {
            this.barBackgroundFill = new ObjectPropertyBase<Color>(this._barBackgroundFill){

                protected void invalidated() {
                    ComparisonRingChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonRingChart.this;
                }

                public String getName() {
                    return "barBackgroundFill";
                }
            };
            this._barBackgroundFill = null;
        }
        return this.barBackgroundFill;
    }

    public boolean isSorted() {
        return null == this.sorted ? this._sorted : this.sorted.get();
    }

    public void setSorted(boolean SORTED) {
        if (null == this.sorted) {
            this._sorted = SORTED;
            this.redraw();
        } else {
            this.sorted.set(SORTED);
        }
    }

    public BooleanProperty sortedProperty() {
        if (null == this.sorted) {
            this.sorted = new BooleanPropertyBase(this._sorted){

                protected void invalidated() {
                    ComparisonRingChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonRingChart.this;
                }

                public String getName() {
                    return "sorted";
                }
            };
        }
        return this.sorted;
    }

    public Order getOrder() {
        return null == this.order ? this._order : (Order)((Object)this.order.get());
    }

    public void setOrder(Order ORDER) {
        if (null == this.order) {
            this._order = ORDER;
            this.redraw();
        } else {
            this.order.set((Object)ORDER);
        }
    }

    public ObjectProperty<Order> orderProperty() {
        if (null == this.order) {
            this.order = new ObjectPropertyBase<Order>(this._order){

                protected void invalidated() {
                    ComparisonRingChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonRingChart.this;
                }

                public String getName() {
                    return "order";
                }
            };
            this._order = null;
        }
        return this.order;
    }

    public NumberFormat getNumberFormat() {
        return null == this.numberFormat ? this._numberFormat : (NumberFormat)((Object)this.numberFormat.get());
    }

    public void setNumberFormat(NumberFormat FORMAT) {
        if (null == this.numberFormat) {
            this._numberFormat = FORMAT;
            this.updatePopup();
            this.redraw();
        } else {
            this.numberFormat.set((Object)FORMAT);
        }
    }

    public ObjectProperty<NumberFormat> numberFormatProperty() {
        if (null == this.numberFormat) {
            this.numberFormat = new ObjectPropertyBase<NumberFormat>(this._numberFormat){

                protected void invalidated() {
                    ComparisonRingChart.this.updatePopup();
                    ComparisonRingChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonRingChart.this;
                }

                public String getName() {
                    return "numberFormat";
                }
            };
            this._numberFormat = null;
        }
        return this.numberFormat;
    }

    private void handleMouseEvents(MouseEvent EVT) {
        double angle;
        double barWH;
        double value;
        ChartItem item;
        int i;
        Object sortedItems2;
        Object sortedItems1;
        double maxValue2;
        double centerX;
        double x = EVT.getX();
        double y = EVT.getY();
        double centerY = centerX = this.size * 0.5;
        double radius = this.size * 0.5;
        double innerSpacer = radius * 0.18;
        double barSpacer = (radius - innerSpacer) * 0.005;
        int noOfItems1 = this.series1.getItems().size();
        int noOfItems2 = this.series2.getItems().size();
        double barWidth1 = (radius - innerSpacer - (double)(noOfItems1 - 1) * barSpacer) / (double)noOfItems1;
        double barWidth2 = (radius - innerSpacer - (double)(noOfItems2 - 1) * barSpacer) / (double)noOfItems2;
        double maxValue1 = noOfItems1 == 0 ? 0.0 : this.series1.getItems().stream().max(Comparator.comparingDouble(ChartItem::getValue)).get().getValue();
        double d = maxValue2 = noOfItems1 == 0 ? 0.0 : this.series2.getItems().stream().max(Comparator.comparingDouble(ChartItem::getValue)).get().getValue();
        if (this.isSorted()) {
            if (Order.ASCENDING == this.getOrder()) {
                sortedItems1 = this.series1.getItems().stream().sorted(Comparator.comparingDouble(ChartItem::getValue)).collect(Collectors.toList());
                sortedItems2 = this.series2.getItems().stream().sorted(Comparator.comparingDouble(ChartItem::getValue)).collect(Collectors.toList());
            } else {
                sortedItems1 = this.series1.getItems().stream().sorted(Comparator.comparingDouble(ChartItem::getValue).reversed()).collect(Collectors.toList());
                sortedItems2 = this.series2.getItems().stream().sorted(Comparator.comparingDouble(ChartItem::getValue).reversed()).collect(Collectors.toList());
            }
        } else {
            sortedItems1 = this.series1.getItems();
            sortedItems2 = this.series2.getItems();
        }
        for (i = 0; i < noOfItems1; ++i) {
            item = (ChartItem)sortedItems1.get(i);
            value = Helper.clamp(0.0, Double.MAX_VALUE, item.getValue());
            barWH = this.size - barWidth1 - ((double)(2 * i) * barWidth1 - barSpacer) - (double)(2 * i) * barSpacer;
            angle = value / maxValue1 * 180.0;
            boolean hitLeft = Helper.isInRingSegment(x, y, centerX, centerY, (barWH + barWidth1) * 0.5, (barWH - barWidth1) * 0.5, 270.0, angle);
            boolean hitRight = Helper.isInRingSegment(x, y, centerX, centerY, (barWH + barWidth1) * 0.5, (barWH - barWidth1) * 0.5, 0.0, angle);
            if (!hitLeft && !hitRight) continue;
            this.popup.setX(EVT.getScreenX());
            this.popup.setY(EVT.getScreenY() - this.popup.getHeight());
            this.fireSelectionEvent(new SelectionEvent<ChartItem>(this.series1, item));
            break;
        }
        for (i = 0; i < noOfItems2; ++i) {
            barWH = this.size - barWidth2 - ((double)(2 * i) * barWidth2 - barSpacer) - (double)(2 * i) * barSpacer;
            item = (ChartItem)sortedItems2.get(i);
            value = Helper.clamp(0.0, Double.MAX_VALUE, item.getValue());
            angle = value / maxValue2 * 180.0;
            boolean hit = Helper.isInRingSegment(x, y, centerX, centerY, (barWH + barWidth2) * 0.5, (barWH - barWidth2) * 0.5, 90.0, angle);
            if (!hit) continue;
            this.popup.setX(EVT.getScreenX());
            this.popup.setY(EVT.getScreenY() - this.popup.getHeight());
            this.fireSelectionEvent(new SelectionEvent<ChartItem>(this.series2, item));
            break;
        }
    }

    private void updatePopup() {
        switch (this.getNumberFormat()) {
            case NUMBER: {
                this.popup.setDecimals(0);
                break;
            }
            case FLOAT_1_DECIMAL: {
                this.popup.setDecimals(1);
                break;
            }
            case FLOAT_2_DECIMALS: {
                this.popup.setDecimals(2);
                break;
            }
            case FLOAT: {
                this.popup.setDecimals(8);
                break;
            }
            case PERCENTAGE: {
                this.popup.setDecimals(0);
                break;
            }
            case PERCENTAGE_1_DECIMAL: {
                this.popup.setDecimals(1);
            }
        }
    }

    public void setOnSelectionEvent(SelectionEventListener LISTENER) {
        this.addSelectionEventListener(LISTENER);
    }

    public void addSelectionEventListener(SelectionEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeSelectionEventListener(SelectionEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void removeAllSelectionEventListeners() {
        this.listeners.clear();
    }

    public void fireSelectionEvent(SelectionEvent EVENT) {
        for (SelectionEventListener listener : this.listeners) {
            listener.onSelectionEvent(EVENT);
        }
    }

    private void prepareSeries(Series<ChartItem> SERIES) {
        boolean animated = SERIES.isAnimated();
        long animationDuration = SERIES.getAnimationDuration();
        Paint fill = SERIES.getFill();
        boolean isColor = fill instanceof Color;
        Color barColor = isColor ? (Color)fill : null;
        Color textFill = SERIES.getTextFill();
        SERIES.getItems().forEach(item -> {
            if (animated) {
                item.setAnimated(animated);
            }
            item.setAnimationDuration(animationDuration);
            if (isColor) {
                item.setFill(barColor);
            }
            item.setTextFill(textFill);
        });
    }

    private void drawChart() {
        double angle;
        double barWH;
        double barXY;
        double value;
        ChartItem item;
        int i;
        Object sortedItems2;
        Object sortedItems1;
        double centerX;
        double centerY = centerX = this.size * 0.5;
        double radius = this.size * 0.5;
        double innerSpacer = radius * 0.18;
        double barSpacer = (radius - innerSpacer) * 0.005;
        int noOfItems1 = this.series1.getItems().size();
        int noOfItems2 = this.series2.getItems().size();
        double barWidth1 = (radius - innerSpacer - (double)(noOfItems1 - 1) * barSpacer) / (double)noOfItems1;
        double barWidth2 = (radius - innerSpacer - (double)(noOfItems2 - 1) * barSpacer) / (double)noOfItems2;
        double maxValue1 = noOfItems1 == 0 ? 0.0 : this.series1.getItems().stream().max(Comparator.comparingDouble(ChartItem::getValue)).get().getValue();
        double maxValue2 = noOfItems1 == 0 ? 0.0 : this.series2.getItems().stream().max(Comparator.comparingDouble(ChartItem::getValue)).get().getValue();
        Color barBackgroundFill = this.getBarBackgroundFill();
        NumberFormat numberFormat = this.getNumberFormat();
        if (this.isSorted()) {
            if (Order.ASCENDING == this.getOrder()) {
                sortedItems1 = this.series1.getItems().stream().sorted(Comparator.comparingDouble(ChartItem::getValue)).collect(Collectors.toList());
                sortedItems2 = this.series2.getItems().stream().sorted(Comparator.comparingDouble(ChartItem::getValue)).collect(Collectors.toList());
            } else {
                sortedItems1 = this.series1.getItems().stream().sorted(Comparator.comparingDouble(ChartItem::getValue).reversed()).collect(Collectors.toList());
                sortedItems2 = this.series2.getItems().stream().sorted(Comparator.comparingDouble(ChartItem::getValue).reversed()).collect(Collectors.toList());
            }
        } else {
            sortedItems1 = this.series1.getItems();
            sortedItems2 = this.series2.getItems();
        }
        this.ctx.clearRect(0.0, 0.0, this.size, this.size);
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.ctx.setTextAlign(TextAlignment.RIGHT);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setFont(Fonts.latoRegular(barWidth1 * 0.5));
        for (i = 0; i < noOfItems1; ++i) {
            item = (ChartItem)sortedItems1.get(i);
            value = Helper.clamp(0.0, Double.MAX_VALUE, item.getValue());
            barXY = barWidth1 * 0.5 + (double)i * barWidth1 + (double)i * barSpacer + 1.0;
            barWH = this.size - barWidth1 - ((double)(2 * i) * barWidth1 - barSpacer) - (double)(2 * i) * barSpacer - 2.0;
            angle = value / maxValue1 * 180.0;
            this.ctx.setLineWidth(barWidth1);
            this.ctx.setStroke((Paint)barBackgroundFill);
            this.ctx.strokeArc(barXY, barXY, barWH, barWH, 180.0, -180.0, ArcType.OPEN);
            this.ctx.setStroke((Paint)item.getFill());
            this.ctx.strokeArc(barXY, barXY, barWH, barWH, 180.0, -angle, ArcType.OPEN);
            this.ctx.setTextAlign(TextAlignment.LEFT);
            this.ctx.setFill((Paint)item.getTextFill());
            if (NumberFormat.PERCENTAGE == numberFormat || NumberFormat.PERCENTAGE_1_DECIMAL == numberFormat) {
                this.drawTextAlongArc(true, this.ctx, String.format(Locale.US, numberFormat.formatString(), value / maxValue1 * 100.0), centerX, centerY, barWH * 0.5, angle - 90.0);
                continue;
            }
            this.drawTextAlongArc(true, this.ctx, String.format(Locale.US, numberFormat.formatString(), value), centerX, centerY, barWH * 0.5, angle - 90.0);
        }
        for (i = 0; i < noOfItems2; ++i) {
            item = (ChartItem)sortedItems2.get(i);
            value = Helper.clamp(0.0, Double.MAX_VALUE, item.getValue());
            barXY = barWidth2 * 0.5 + (double)i * barWidth2 + (double)i * barSpacer + 1.0;
            barWH = this.size - barWidth2 - ((double)(2 * i) * barWidth2 - barSpacer) - (double)(2 * i) * barSpacer - 2.0;
            angle = value / maxValue2 * 180.0;
            this.ctx.setLineWidth(barWidth2);
            this.ctx.setStroke((Paint)barBackgroundFill);
            this.ctx.strokeArc(barXY, barXY, barWH, barWH, 0.0, -180.0, ArcType.OPEN);
            this.ctx.setStroke((Paint)item.getFill());
            this.ctx.strokeArc(barXY, barXY, barWH, barWH, 0.0, -angle, ArcType.OPEN);
            this.ctx.setTextAlign(TextAlignment.LEFT);
            this.ctx.setFill((Paint)item.getTextFill());
            if (NumberFormat.PERCENTAGE == numberFormat || NumberFormat.PERCENTAGE_1_DECIMAL == numberFormat) {
                this.drawTextAlongArc(false, this.ctx, String.format(Locale.US, numberFormat.formatString(), value / maxValue2 * 100.0), centerX, centerY, barWH * 0.5, angle + 90.0);
                continue;
            }
            this.drawTextAlongArc(false, this.ctx, String.format(Locale.US, numberFormat.formatString(), value), centerX, centerY, barWH * 0.5, angle + 90.0);
        }
    }

    private void drawTextAlongArc(boolean UPPER, GraphicsContext CTX, String TEXT, double CENTER_X, double CENTER_Y, double RADIUS, double ANGLE) {
        double offset;
        int length = TEXT.length();
        double charSpacer = 7.0 / RADIUS * this.size * 0.13;
        double textAngle = charSpacer * ((double)length + 0.5);
        double d = offset = UPPER ? 90.0 : -90.0;
        if (ANGLE + offset > textAngle) {
            CTX.save();
            CTX.translate(CENTER_X, CENTER_Y);
            CTX.rotate(ANGLE - charSpacer * ((double)length + 0.5));
            for (int i = 0; i < length; ++i) {
                CTX.save();
                CTX.translate(0.0, -1.0 * RADIUS);
                char c = TEXT.charAt(i);
                CTX.fillText(Character.toString(c), 0.0, 0.0);
                CTX.restore();
                CTX.rotate(charSpacer);
            }
            CTX.restore();
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.redraw();
        }
    }

    private void redraw() {
        this.drawChart();
    }
}

