/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.mp3;

import net.sourceforge.lame.mp3.GrInfo;
import net.sourceforge.lame.mp3.IIISideInfo;
import net.sourceforge.lame.mp3.III_psy_ratio;
import net.sourceforge.lame.mp3.IIterationLoop;
import net.sourceforge.lame.mp3.LameGlobalFlags;
import net.sourceforge.lame.mp3.LameInternalFlags;
import net.sourceforge.lame.mp3.MeanBits;
import net.sourceforge.lame.mp3.Quantize;

public final class VBROldIterationLoop
implements IIterationLoop {
    private final Quantize quantize;

    VBROldIterationLoop(Quantize quantize) {
        this.quantize = quantize;
    }

    @Override
    public void iteration_loop(LameGlobalFlags gfp, float[][] pe, float[] ms_ener_ratio, III_psy_ratio[][] ratio) {
        LameInternalFlags gfc = gfp.internal_flags;
        float[][][] l3_xmin = new float[2][2][39];
        float[] xrpow = new float[576];
        int[][] bands = new int[2][2];
        int[] frameBits = new int[15];
        int[][] min_bits = new int[2][2];
        int[][] max_bits = new int[2][2];
        int mean_bits = 0;
        IIISideInfo l3_side = gfc.l3_side;
        int analog_silence = this.quantize.VBR_old_prepare(gfp, pe, ms_ener_ratio, ratio, l3_xmin, frameBits, min_bits, max_bits, bands);
        while (true) {
            int used_bits = 0;
            for (int gr = 0; gr < gfc.mode_gr; ++gr) {
                for (int ch = 0; ch < gfc.channels_out; ++ch) {
                    GrInfo cod_info = l3_side.tt[gr][ch];
                    boolean ret = this.quantize.init_xrpow(gfc, cod_info, xrpow);
                    if (!ret || max_bits[gr][ch] == 0) continue;
                    this.quantize.VBR_encode_granule(gfp, cod_info, l3_xmin[gr][ch], xrpow, ch, min_bits[gr][ch], max_bits[gr][ch]);
                    if ((gfc.substep_shaping & 1) != 0) {
                        this.quantize.trancate_smallspectrums(gfc, l3_side.tt[gr][ch], l3_xmin[gr][ch], xrpow);
                    }
                    int usedB = cod_info.part2_3_length + cod_info.part2_length;
                    used_bits += usedB;
                }
            }
            gfc.bitrate_index = analog_silence != 0 && 0 == gfp.VBR_hard_min ? 1 : gfc.VBR_min_bitrate;
            while (gfc.bitrate_index < gfc.VBR_max_bitrate && used_bits > frameBits[gfc.bitrate_index]) {
                ++gfc.bitrate_index;
            }
            MeanBits mb = new MeanBits(mean_bits);
            int bits = this.quantize.rv.ResvFrameBegin(gfp, mb);
            mean_bits = mb.bits;
            if (used_bits <= bits) break;
            this.quantize.bitpressure_strategy(gfc, l3_xmin, min_bits, max_bits);
        }
        for (int gr = 0; gr < gfc.mode_gr; ++gr) {
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                this.quantize.iteration_finish_one(gfc, gr, ch);
            }
        }
        this.quantize.rv.ResvFrameEnd(gfc, mean_bits);
    }
}

