/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.mp3;

import net.sourceforge.lame.mp3.GrInfo;
import net.sourceforge.lame.mp3.LameInternalFlags;
import net.sourceforge.lame.mp3.VBRQuantize;

final class ShortBlockConstrain
implements VBRQuantize.alloc_sf_f {
    private final VBRQuantize vbrQuantize;

    ShortBlockConstrain(VBRQuantize vbrQuantize) {
        this.vbrQuantize = vbrQuantize;
    }

    @Override
    public void alloc(VBRQuantize.algo_t that, int[] vbrsf, int[] vbrsfmin, int vbrmax) {
        int sfb;
        GrInfo cod_info = that.cod_info;
        LameInternalFlags gfc = that.gfc;
        int maxminsfb = that.mingain_l;
        int maxover0 = 0;
        int maxover1 = 0;
        int delta = 0;
        int psymax = cod_info.psymax;
        for (sfb = 0; sfb < psymax; ++sfb) {
            assert (vbrsf[sfb] >= vbrsfmin[sfb]);
            int v = vbrmax - vbrsf[sfb];
            if (delta < v) {
                delta = v;
            }
            int v0 = v - (56 + 2 * VBRQuantize.max_range_short[sfb]);
            int v1 = v - (56 + 4 * VBRQuantize.max_range_short[sfb]);
            if (maxover0 < v0) {
                maxover0 = v0;
            }
            if (maxover1 >= v1) continue;
            maxover1 = v1;
        }
        int mover = gfc.noise_shaping == 2 ? Math.min(maxover0, maxover1) : maxover0;
        if (delta > mover) {
            delta = mover;
        }
        vbrmax -= delta;
        maxover1 -= mover;
        if ((maxover0 -= mover) == 0) {
            cod_info.scalefac_scale = 0;
        } else if (maxover1 == 0) {
            cod_info.scalefac_scale = 1;
        }
        if (vbrmax < maxminsfb) {
            vbrmax = maxminsfb;
        }
        cod_info.global_gain = vbrmax;
        if (cod_info.global_gain < 0) {
            cod_info.global_gain = 0;
        } else if (cod_info.global_gain > 255) {
            cod_info.global_gain = 255;
        }
        int[] sf_temp = new int[39];
        for (sfb = 0; sfb < 39; ++sfb) {
            sf_temp[sfb] = vbrsf[sfb] - vbrmax;
        }
        this.vbrQuantize.set_subblock_gain(cod_info, that.mingain_s, sf_temp);
        this.vbrQuantize.set_scalefacs(cod_info, vbrsfmin, sf_temp, VBRQuantize.max_range_short);
        assert (this.vbrQuantize.checkScalefactor(cod_info, vbrsfmin));
    }
}

