/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.mp3;

import net.sourceforge.lame.mp3.GrInfo;
import net.sourceforge.lame.mp3.IIISideInfo;
import net.sourceforge.lame.mp3.III_psy_ratio;
import net.sourceforge.lame.mp3.IIterationLoop;
import net.sourceforge.lame.mp3.LameGlobalFlags;
import net.sourceforge.lame.mp3.LameInternalFlags;
import net.sourceforge.lame.mp3.MeanBits;
import net.sourceforge.lame.mp3.Quantize;

public final class CBRNewIterationLoop
implements IIterationLoop {
    private final Quantize quantize;

    CBRNewIterationLoop(Quantize quantize) {
        this.quantize = quantize;
    }

    @Override
    public void iteration_loop(LameGlobalFlags gfp, float[][] pe, float[] ms_ener_ratio, III_psy_ratio[][] ratio) {
        LameInternalFlags gfc = gfp.internal_flags;
        float[] l3_xmin = new float[39];
        float[] xrpow = new float[576];
        int[] targ_bits = new int[2];
        int mean_bits = 0;
        IIISideInfo l3_side = gfc.l3_side;
        MeanBits mb = new MeanBits(mean_bits);
        this.quantize.rv.ResvFrameBegin(gfp, mb);
        mean_bits = mb.bits;
        for (int gr = 0; gr < gfc.mode_gr; ++gr) {
            int max_bits = this.quantize.qupvt.on_pe(gfp, pe, targ_bits, mean_bits, gr, gr);
            if (gfc.mode_ext == 2) {
                this.quantize.ms_convert(gfc.l3_side, gr);
                this.quantize.qupvt.reduce_side(targ_bits, ms_ener_ratio[gr], mean_bits, max_bits);
            }
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                float masking_lower_db;
                float adjust;
                GrInfo cod_info = l3_side.tt[gr][ch];
                if (cod_info.block_type != 2) {
                    adjust = 0.0f;
                    masking_lower_db = gfc.PSY.mask_adjust - adjust;
                } else {
                    adjust = 0.0f;
                    masking_lower_db = gfc.PSY.mask_adjust_short - adjust;
                }
                gfc.masking_lower = (float)Math.pow(10.0, (double)masking_lower_db * 0.1);
                this.quantize.init_outer_loop(gfc, cod_info);
                if (this.quantize.init_xrpow(gfc, cod_info, xrpow)) {
                    this.quantize.qupvt.calc_xmin(gfp, ratio[gr][ch], cod_info, l3_xmin);
                    this.quantize.outer_loop(gfp, cod_info, l3_xmin, xrpow, ch, targ_bits[ch]);
                }
                this.quantize.iteration_finish_one(gfc, gr, ch);
                assert (cod_info.part2_3_length <= 4095);
                assert (cod_info.part2_3_length <= targ_bits[ch]);
            }
        }
        this.quantize.rv.ResvFrameEnd(gfc, mean_bits);
    }
}

