/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters;

import java.util.HashSet;
import java.util.Set;
import net.coderazzi.filters.Filter;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.IFilterObserver;

public abstract class ComposedFilter
extends Filter
implements IFilterObserver {
    protected Set<IFilter> filters;
    private Set<IFilter> disabledFilters = new HashSet<IFilter>();

    protected ComposedFilter() {
        this.filters = new HashSet<IFilter>();
    }

    protected ComposedFilter(IFilter ... observables) {
        this();
        this.addFilter(observables);
    }

    public void addFilter(IFilter ... filtersToAdd) {
        for (IFilter filter : filtersToAdd) {
            if (!this.filters.add(filter)) continue;
            filter.addFilterObserver(this);
            if (filter.isEnabled()) {
                super.setEnabled(true);
                continue;
            }
            this.disabledFilters.add(filter);
        }
    }

    public void removeFilter(IFilter ... filtersToRemove) {
        boolean report = false;
        for (IFilter filter : filtersToRemove) {
            if (!this.filters.remove(filter)) continue;
            filter.removeFilterObserver(this);
            this.disabledFilters.remove(filter);
            report = true;
        }
        if (report) {
            if (this.isEnabled() && !this.filters.isEmpty() && this.disabledFilters.size() == this.filters.size()) {
                super.setEnabled(false);
            } else {
                this.reportFilterUpdatedToObservers();
            }
        }
    }

    public Set<IFilter> getFilters() {
        return new HashSet<IFilter>(this.filters);
    }

    @Override
    public void filterUpdated(IFilter filter) {
        boolean enabled = this.isEnabled();
        boolean changeState = false;
        if (filter.isEnabled()) {
            changeState = this.disabledFilters.remove(filter) && !enabled;
        } else {
            boolean bl = changeState = this.disabledFilters.add(filter) && this.disabledFilters.size() == this.filters.size();
        }
        if (changeState) {
            super.setEnabled(!enabled);
        } else {
            this.reportFilterUpdatedToObservers();
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        if (this.filters.isEmpty()) {
            super.setEnabled(enable);
        } else {
            for (IFilter filter : this.filters) {
                filter.setEnabled(enable);
            }
        }
    }

    protected boolean isDisabled(IFilter filter) {
        return this.disabledFilters.contains(filter);
    }
}

