/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.swing.SwingUtilities;
import org.apache.commons.math3.util.FastMath;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileCache;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.util.GeoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTileFactory
extends TileFactory {
    private static final Logger mLog = LoggerFactory.getLogger(AbstractTileFactory.class);
    private boolean mSSLSuitesLogged = false;
    private int threadPoolSize = 4;
    private ExecutorService service;
    private Map<String, Tile> tileMap = new HashMap<String, Tile>();
    private TileCache cache = new TileCache();
    private static BlockingQueue<Tile> tileQueue = new PriorityBlockingQueue<Tile>(5, new Comparator<Tile>(){

        @Override
        public int compare(Tile o1, Tile o2) {
            if (o1.getPriority() == Tile.Priority.Low && o2.getPriority() == Tile.Priority.High) {
                return 1;
            }
            if (o1.getPriority() == Tile.Priority.High && o2.getPriority() == Tile.Priority.Low) {
                return -1;
            }
            return 0;
        }
    });

    public AbstractTileFactory(TileFactoryInfo info) {
        super(info);
    }

    @Override
    public Tile getTile(int x, int y, int zoom) {
        return this.getTile(x, y, zoom, true);
    }

    private Tile getTile(int tpx, int tpy, int zoom, boolean eagerLoad) {
        int tileX = tpx;
        int numTilesWide = (int)this.getMapSize(zoom).getWidth();
        if (tileX < 0) {
            tileX = numTilesWide - FastMath.abs((int)tileX) % numTilesWide;
        }
        int tileY = tpy;
        String url = this.getInfo().getTileUrl(tileX %= numTilesWide, tileY, zoom);
        Tile.Priority pri = Tile.Priority.High;
        if (!eagerLoad) {
            pri = Tile.Priority.Low;
        }
        Tile tile = null;
        if (!this.tileMap.containsKey(url)) {
            if (!GeoUtil.isValidTile(tileX, tileY, zoom, this.getInfo())) {
                tile = new Tile(tileX, tileY, zoom);
            } else {
                tile = new Tile(tileX, tileY, zoom, url, pri, this);
                this.startLoading(tile);
            }
            this.tileMap.put(url, tile);
        } else {
            tile = this.tileMap.get(url);
            if (tile.getPriority() == Tile.Priority.Low && eagerLoad && !tile.isLoaded()) {
                this.promote(tile);
            }
        }
        return tile;
    }

    public TileCache getTileCache() {
        return this.cache;
    }

    public void setTileCache(TileCache cache) {
        this.cache = cache;
    }

    protected synchronized ExecutorService getService() {
        if (this.service == null) {
            this.service = Executors.newFixedThreadPool(this.threadPoolSize, new ThreadFactory(this){
                private int count = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "map tile fetcher-pool-" + this.count++);
                    t.setPriority(1);
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return this.service;
    }

    @Override
    public void dispose() {
        if (this.service != null) {
            this.service.shutdown();
            this.service = null;
        }
    }

    public void setThreadPoolSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size invalid: " + size + ". The size of the threadpool must be greater than 0.");
        }
        this.threadPoolSize = size;
    }

    @Override
    protected synchronized void startLoading(Tile tile) {
        if (tile.isLoading()) {
            System.out.println("already loading. bailing");
            return;
        }
        tile.setLoading(true);
        try {
            tileQueue.put(tile);
            this.getService().submit(this.createTileRunner(tile));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected Runnable createTileRunner(Tile tile) {
        return new TileRunner();
    }

    public synchronized void promote(Tile tile) {
        if (tileQueue.contains(tile)) {
            try {
                tileQueue.remove(tile);
                tile.setPriority(Tile.Priority.High);
                tileQueue.put(tile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String a = "https://tile.openstreetmap.org/12/1178/1504.png";
        try {
            int n;
            URL url = new URL(a);
            System.out.println("Fetching URL: " + String.valueOf(url.getClass()) + " " + url.toString());
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.addRequestProperty("User-Agent", "sdrtrunk");
            InputStream is = conn.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((n = is.read(buf)) != -1) {
                bout.write(buf, 0, n);
            }
            System.out.println("Bytes:" + Arrays.toString(bout.toByteArray()));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private class TileRunner
    implements Runnable {
        private TileRunner() {
        }

        protected URI getURI(Tile tile) throws URISyntaxException {
            if (tile.getURL() == null) {
                return null;
            }
            return new URI(tile.getURL());
        }

        @Override
        public void run() {
            final Tile tile = (Tile)tileQueue.remove();
            int trys = 3;
            while (!tile.isLoaded() && trys > 0) {
                try {
                    BufferedImage img = null;
                    URI uri = this.getURI(tile);
                    img = AbstractTileFactory.this.cache.get(uri);
                    if (img == null) {
                        byte[] bimg = this.cacheInputStream(uri.toURL());
                        img = ImageIO.read(new ByteArrayInputStream(bimg));
                        AbstractTileFactory.this.cache.put(uri, bimg, img);
                        img = AbstractTileFactory.this.cache.get(uri);
                    }
                    if (img == null) {
                        --trys;
                        continue;
                    }
                    final BufferedImage i = img;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            tile.image = new SoftReference<BufferedImage>(i);
                            tile.setLoaded(true);
                            AbstractTileFactory.this.fireTileLoadedEvent(tile);
                        }
                    });
                }
                catch (OutOfMemoryError memErr) {
                    AbstractTileFactory.this.cache.needMoreMemory();
                }
                catch (SSLException ssle) {
                    if (ssle.getMessage() != null && ssle.getMessage().startsWith("No PSK available")) continue;
                    mLog.error("SSL Exception");
                }
                catch (Throwable e) {
                    if (trys == 0) {
                        mLog.error("Failed to load a tile at url: " + tile.getURL() + ", stopping", e);
                        continue;
                    }
                    mLog.error("Failed to load a tile at url: " + tile.getURL() + ", retrying", e);
                    --trys;
                }
            }
            tile.setLoading(false);
        }

        private byte[] cacheInputStream(URL url) throws IOException {
            int n;
            if (url.toString().startsWith("https://tile.openstreetmap.org")) {
                int n2;
                HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
                conn.addRequestProperty("User-Agent", "sdrtrunk");
                try {
                    SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                    sslContext.init(null, null, new SecureRandom());
                    conn.setSSLSocketFactory(sslContext.getSocketFactory());
                }
                catch (KeyManagementException kme) {
                    mLog.error("Error initializing SSL context");
                }
                catch (NoSuchAlgorithmException nsae) {
                    mLog.error("Unable to use TLSv1.2 for openstreetmap tiles");
                }
                InputStream is = conn.getInputStream();
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] buf = new byte[256];
                while ((n2 = is.read(buf)) != -1) {
                    bout.write(buf, 0, n2);
                }
                conn.disconnect();
                return bout.toByteArray();
            }
            InputStream ins = url.openStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((n = ins.read(buf)) != -1) {
                bout.write(buf, 0, n);
            }
            return bout.toByteArray();
        }
    }
}

