/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate.filter;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.dsp.filter.fir.real.RealFIRFilter;
import io.github.dsheirer.dsp.filter.fir.real.VectorRealFIRFilter128Bit;
import io.github.dsheirer.dsp.filter.fir.real.VectorRealFIRFilter256Bit;
import io.github.dsheirer.dsp.filter.fir.real.VectorRealFIRFilter512Bit;
import io.github.dsheirer.dsp.filter.fir.real.VectorRealFIRFilter64Bit;
import io.github.dsheirer.dsp.filter.fir.real.VectorRealFIRFilterDefaultBit;
import io.github.dsheirer.dsp.window.WindowType;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.VectorSpecies;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class FirFilterCalibration
extends Calibration {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_PREFERRED;
    private static final int BUFFER_SIZE = 2048;
    private static final int ITERATION_DURATION_MS = 1000;
    private static final int WARMUP_ITERATIONS = 5;
    private static final int TEST_ITERATIONS = 5;
    private IRealFilter mScalar;
    private IRealFilter mVectorPreferred;
    private IRealFilter mVector512;
    private IRealFilter mVector256;
    private IRealFilter mVector128;
    private IRealFilter mVector64;

    public FirFilterCalibration() {
        super(CalibrationType.FILTER_FIR);
        try {
            float[] coefficients = FilterFactory.getSinc(0.25, 31, WindowType.BLACKMAN);
            this.mScalar = new RealFIRFilter(coefficients);
            this.mVectorPreferred = new VectorRealFIRFilterDefaultBit(coefficients);
            this.mVector64 = new VectorRealFIRFilter64Bit(coefficients);
            this.mVector128 = new VectorRealFIRFilter128Bit(coefficients);
            this.mVector256 = new VectorRealFIRFilter256Bit(coefficients);
            this.mVector512 = new VectorRealFIRFilter512Bit(coefficients);
        }
        catch (FilterDesignException fde) {
            mLog.error("Error creating sinc filter for real FIR filter calibration");
        }
    }

    @Override
    public void calibrate() throws CalibrationException {
        long score;
        int x;
        long score2;
        if (this.mScalar == null) {
            return;
        }
        float[] samples = this.getFloatSamples(2048);
        Mean scalarMean = new Mean();
        for (int x2 = 0; x2 < 5; ++x2) {
            long score3 = this.testScalar(samples);
            scalarMean.increment((double)score3);
        }
        mLog.info("FIR FILTER WARMUP - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        Mean vectorPreferredMean = new Mean();
        for (int x3 = 0; x3 < 5; ++x3) {
            long score4 = this.testVectorPreferred(samples);
            vectorPreferredMean.increment((double)score4);
        }
        mLog.info("FIR FILTER WARMUP - VECTOR PREFERRED: " + DECIMAL_FORMAT.format(vectorPreferredMean.getResult()));
        Mean vector512Mean = new Mean();
        if (VECTOR_SPECIES.length() >= 16) {
            for (int x4 = 0; x4 < 5; ++x4) {
                long score5 = this.testVector512(samples);
                vector512Mean.increment((double)score5);
            }
            mLog.info("FIR FILTER WARMUP - VECTOR 512: " + DECIMAL_FORMAT.format(vector512Mean.getResult()));
        }
        Mean vector256Mean = new Mean();
        if (VECTOR_SPECIES.length() >= 8) {
            for (int x5 = 0; x5 < 5; ++x5) {
                long score6 = this.testVector256(samples);
                vector256Mean.increment((double)score6);
            }
            mLog.info("FIR FILTER WARMUP - VECTOR 256: " + DECIMAL_FORMAT.format(vector256Mean.getResult()));
        }
        Mean vector128Mean = new Mean();
        if (VECTOR_SPECIES.length() >= 4) {
            for (int x6 = 0; x6 < 5; ++x6) {
                long score7 = this.testVector128(samples);
                vector128Mean.increment((double)score7);
            }
            mLog.info("FIR FILTER WARMUP - VECTOR 128: " + DECIMAL_FORMAT.format(vector128Mean.getResult()));
        }
        Mean vector64Mean = new Mean();
        if (VECTOR_SPECIES.length() >= 2) {
            for (int x7 = 0; x7 < 5; ++x7) {
                score2 = this.testVector64(samples);
                vector64Mean.increment((double)score2);
            }
            mLog.info("FIR FILTER WARMUP - VECTOR 64: " + DECIMAL_FORMAT.format(vector64Mean.getResult()));
        }
        scalarMean.clear();
        for (int x8 = 0; x8 < 5; ++x8) {
            score2 = this.testScalar(samples);
            scalarMean.increment((double)score2);
        }
        mLog.info("FIR FILTER - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        double bestScore = scalarMean.getResult();
        this.setImplementation(Implementation.SCALAR);
        vectorPreferredMean.clear();
        for (x = 0; x < 5; ++x) {
            score = this.testVectorPreferred(samples);
            vectorPreferredMean.increment((double)score);
        }
        mLog.info("FIR FILTER - VECTOR PREFERRED: " + DECIMAL_FORMAT.format(vectorPreferredMean.getResult()));
        if (vectorPreferredMean.getResult() > bestScore) {
            bestScore = vectorPreferredMean.getResult();
            this.setImplementation(Implementation.VECTOR_SIMD_PREFERRED);
        }
        if (VECTOR_SPECIES.length() >= 16) {
            vector512Mean.clear();
            for (x = 0; x < 5; ++x) {
                score = this.testVector512(samples);
                vector512Mean.increment((double)score);
            }
            mLog.info("FIR FILTER - VECTOR 512: " + DECIMAL_FORMAT.format(vector512Mean.getResult()));
            if (vector512Mean.getResult() > bestScore) {
                bestScore = vector512Mean.getResult();
                this.setImplementation(Implementation.VECTOR_SIMD_512);
            }
        }
        if (VECTOR_SPECIES.length() >= 8) {
            vector256Mean.clear();
            for (x = 0; x < 5; ++x) {
                score = this.testVector256(samples);
                vector256Mean.increment((double)score);
            }
            mLog.info("FIR FILTER - VECTOR 256: " + DECIMAL_FORMAT.format(vector256Mean.getResult()));
            if (vector256Mean.getResult() > bestScore) {
                bestScore = vector256Mean.getResult();
                this.setImplementation(Implementation.VECTOR_SIMD_256);
            }
        }
        if (VECTOR_SPECIES.length() >= 4) {
            vector128Mean.clear();
            for (x = 0; x < 5; ++x) {
                score = this.testVector128(samples);
                vector128Mean.increment((double)score);
            }
            mLog.info("FIR FILTER - VECTOR 128: " + DECIMAL_FORMAT.format(vector128Mean.getResult()));
            if (vector128Mean.getResult() > bestScore) {
                bestScore = vector128Mean.getResult();
                this.setImplementation(Implementation.VECTOR_SIMD_128);
            }
        }
        if (VECTOR_SPECIES.length() >= 2) {
            vector64Mean.clear();
            for (x = 0; x < 5; ++x) {
                score = this.testVector64(samples);
                vector64Mean.increment((double)score);
            }
            mLog.info("FIR FILTER - VECTOR 64: " + DECIMAL_FORMAT.format(vector64Mean.getResult()));
            if (vector64Mean.getResult() > bestScore) {
                this.setImplementation(Implementation.VECTOR_SIMD_64);
            }
        }
        mLog.info("FIR FILTER - SET OPTIMAL IMPLEMENTATION TO: " + String.valueOf((Object)this.getImplementation()));
    }

    private long testScalar(float[] samples) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mScalar.filter(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector64(float[] samples) {
        double accumulator = 0.0;
        long start = System.currentTimeMillis();
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mVector64.filter(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector128(float[] samples) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mVector128.filter(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector256(float[] samples) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mVector256.filter(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVector512(float[] samples) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mVector512.filter(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }

    private long testVectorPreferred(float[] samples) {
        double accumulator = 0.0;
        long count = 0L;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            float[] filtered = this.mVectorPreferred.filter(samples);
            accumulator += (double)filtered[0];
            ++count;
        }
        return count + (long)(accumulator * 0.0);
    }
}

