/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate.airspy;

import io.github.dsheirer.buffer.airspy.AirspyBufferIteratorScalar;
import io.github.dsheirer.buffer.airspy.AirspyBufferIteratorVector128Bits;
import io.github.dsheirer.buffer.airspy.AirspyBufferIteratorVector256Bits;
import io.github.dsheirer.buffer.airspy.AirspyBufferIteratorVector512Bits;
import io.github.dsheirer.buffer.airspy.AirspyBufferIteratorVector64Bits;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import jdk.incubator.vector.FloatVector;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class AirspyUnpackedCalibration
extends Calibration {
    private static final int BUFFER_SIZE = 131072;
    private static final int ITERATION_DURATION_MS = 1000;
    private static final int WARMUP_ITERATIONS = 5;
    private static final int TEST_ITERATIONS = 5;

    public AirspyUnpackedCalibration() {
        super(CalibrationType.AIRSPY_UNPACKED_ITERATOR);
    }

    @Override
    public void calibrate() throws CalibrationException {
        short[] samples = this.getShortSamples(131072);
        short[] residualI = this.getShortSamples(11);
        short[] residualQ = this.getShortSamples(23);
        mLog.info("AIRSPY UNPACKED - VECTOR SIMD LANES PREFERRED: " + FloatVector.SPECIES_PREFERRED.length());
        Mean scalarMean = new Mean();
        for (int warmup = 0; warmup < 5; ++warmup) {
            long score = this.testScalar(samples, residualI, residualQ);
            scalarMean.increment((double)score);
        }
        mLog.info("AIRSPY UNPACKED WARMUP - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        switch (FloatVector.SPECIES_PREFERRED.length()) {
            case 16: {
                long score;
                Mean vector512Mean = new Mean();
                for (int warmup = 0; warmup < 5; ++warmup) {
                    score = this.testVector512(samples, residualI, residualQ);
                    vector512Mean.increment((double)score);
                }
                mLog.info("AIRSPY UNPACKED WARMUP - VECTOR 512: " + DECIMAL_FORMAT.format(vector512Mean.getResult()));
            }
            case 8: {
                long score;
                Mean vector256Mean = new Mean();
                for (int warmup = 0; warmup < 5; ++warmup) {
                    score = this.testVector256(samples, residualI, residualQ);
                    vector256Mean.increment((double)score);
                }
                mLog.info("AIRSPY UNPACKED WARMUP - VECTOR 256: " + DECIMAL_FORMAT.format(vector256Mean.getResult()));
            }
            case 4: {
                long score;
                Mean vector128Mean = new Mean();
                for (int warmup = 0; warmup < 5; ++warmup) {
                    score = this.testVector128(samples, residualI, residualQ);
                    vector128Mean.increment((double)score);
                }
                mLog.info("AIRSPY UNPACKED WARMUP - VECTOR 128: " + DECIMAL_FORMAT.format(vector128Mean.getResult()));
            }
            case 2: {
                long score;
                Mean vector64Mean = new Mean();
                for (int warmup = 0; warmup < 5; ++warmup) {
                    score = this.testVector64(samples, residualI, residualQ);
                    vector64Mean.increment((double)score);
                }
                mLog.info("AIRSPY UNPACKED WARMUP - VECTOR 64: " + DECIMAL_FORMAT.format(vector64Mean.getResult()));
            }
        }
        scalarMean.clear();
        for (int test = 0; test < 5; ++test) {
            long score = this.testScalar(samples, residualI, residualQ);
            scalarMean.increment((double)score);
        }
        double bestScore = scalarMean.getResult();
        this.setImplementation(Implementation.SCALAR);
        mLog.info("AIRSPY UNPACKED - SCALAR: " + DECIMAL_FORMAT.format(scalarMean.getResult()));
        switch (FloatVector.SPECIES_PREFERRED.length()) {
            case 16: {
                long score;
                int test;
                Mean vector512Mean = new Mean();
                for (test = 0; test < 5; ++test) {
                    score = this.testVector512(samples, residualI, residualQ);
                    vector512Mean.increment((double)score);
                }
                mLog.info("AIRSPY UNPACKED - VECTOR 512: " + DECIMAL_FORMAT.format(vector512Mean.getResult()));
                if (vector512Mean.getResult() > bestScore) {
                    bestScore = vector512Mean.getResult();
                    this.setImplementation(Implementation.VECTOR_SIMD_512);
                }
            }
            case 8: {
                long score;
                int test;
                Mean vector256Mean = new Mean();
                for (test = 0; test < 5; ++test) {
                    score = this.testVector256(samples, residualI, residualQ);
                    vector256Mean.increment((double)score);
                }
                mLog.info("AIRSPY UNPACKED - VECTOR 256: " + DECIMAL_FORMAT.format(vector256Mean.getResult()));
                if (vector256Mean.getResult() > bestScore) {
                    bestScore = vector256Mean.getResult();
                    this.setImplementation(Implementation.VECTOR_SIMD_256);
                }
            }
            case 4: {
                long score;
                int test;
                Mean vector128Mean = new Mean();
                for (test = 0; test < 5; ++test) {
                    score = this.testVector128(samples, residualI, residualQ);
                    vector128Mean.increment((double)score);
                }
                mLog.info("AIRSPY UNPACKED - VECTOR 128: " + DECIMAL_FORMAT.format(vector128Mean.getResult()));
                if (vector128Mean.getResult() > bestScore) {
                    bestScore = vector128Mean.getResult();
                    this.setImplementation(Implementation.VECTOR_SIMD_128);
                }
            }
            case 2: {
                long score;
                int test;
                Mean vector64Mean = new Mean();
                for (test = 0; test < 5; ++test) {
                    score = this.testVector64(samples, residualI, residualQ);
                    vector64Mean.increment((double)score);
                }
                mLog.info("AIRSPY UNPACKED - VECTOR 64: " + DECIMAL_FORMAT.format(vector64Mean.getResult()));
                if (!(vector64Mean.getResult() > bestScore)) break;
                this.setImplementation(Implementation.VECTOR_SIMD_64);
            }
        }
        mLog.info("AIRSPY UNPACKED - SET OPTIMAL IMPLEMENTATION TO: " + String.valueOf((Object)this.getImplementation()));
    }

    private long testScalar(short[] samples, short[] residualI, short[] residualQ) {
        long start = System.currentTimeMillis();
        long accumulator = 0L;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            AirspyBufferIteratorScalar iterator = new AirspyBufferIteratorScalar(samples, residualI, residualQ, 0.0f, System.currentTimeMillis(), 0.0f);
            while (iterator.hasNext() && System.currentTimeMillis() - start < 1000L) {
                accumulator = (long)((float)accumulator + iterator.next().i()[2]);
                ++count;
            }
        }
        return count + accumulator * 0L;
    }

    private long testVector64(short[] samples, short[] residualI, short[] residualQ) {
        long start = System.currentTimeMillis();
        long accumulator = 0L;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            AirspyBufferIteratorVector64Bits iterator = new AirspyBufferIteratorVector64Bits(samples, residualI, residualQ, 0.0f, System.currentTimeMillis(), 0.0f);
            while (iterator.hasNext() && System.currentTimeMillis() - start < 1000L) {
                accumulator = (long)((float)accumulator + iterator.next().i()[2]);
                ++count;
            }
        }
        return count + accumulator * 0L;
    }

    private long testVector128(short[] samples, short[] residualI, short[] residualQ) {
        long start = System.currentTimeMillis();
        long accumulator = 0L;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            AirspyBufferIteratorVector128Bits iterator = new AirspyBufferIteratorVector128Bits(samples, residualI, residualQ, 0.0f, System.currentTimeMillis(), 0.0f);
            while (iterator.hasNext() && System.currentTimeMillis() - start < 1000L) {
                accumulator = (long)((float)accumulator + iterator.next().i()[2]);
                ++count;
            }
        }
        return count + accumulator * 0L;
    }

    private long testVector256(short[] samples, short[] residualI, short[] residualQ) {
        long start = System.currentTimeMillis();
        long accumulator = 0L;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            AirspyBufferIteratorVector256Bits iterator = new AirspyBufferIteratorVector256Bits(samples, residualI, residualQ, 0.0f, System.currentTimeMillis(), 0.0f);
            while (iterator.hasNext() && System.currentTimeMillis() - start < 1000L) {
                accumulator = (long)((float)accumulator + iterator.next().i()[2]);
                ++count;
            }
        }
        return count + accumulator * 0L;
    }

    private long testVector512(short[] samples, short[] residualI, short[] residualQ) {
        long start = System.currentTimeMillis();
        long accumulator = 0L;
        long count = 0L;
        while (System.currentTimeMillis() - start < 1000L) {
            AirspyBufferIteratorVector512Bits iterator = new AirspyBufferIteratorVector512Bits(samples, residualI, residualQ, 0.0f, System.currentTimeMillis(), 0.0f);
            while (iterator.hasNext() && System.currentTimeMillis() - start < 1000L) {
                accumulator = (long)((float)accumulator + iterator.next().i()[2]);
                ++count;
            }
        }
        return count + accumulator * 0L;
    }
}

