/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector;

import io.github.dsheirer.sample.complex.ComplexSamples;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.VectorMask;
import jdk.incubator.vector.VectorSpecies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorUtilities {
    private static final Logger mLog = LoggerFactory.getLogger(VectorUtilities.class);
    private static boolean mSpeciesMismatchLogged = false;

    public static void checkSpecies(VectorSpecies<Float> species) {
        if (FloatVector.SPECIES_PREFERRED.length() < species.length() && !mSpeciesMismatchLogged) {
            mLog.warn("CPU supports maximum SIMD instructions of " + String.valueOf(FloatVector.SPECIES_PREFERRED));
            mSpeciesMismatchLogged = true;
        }
    }

    public static void checkComplexArrayLength(float[] i, float[] q, VectorSpecies<Float> species) {
        if (i.length % species.length() != 0) {
            throw new IllegalArgumentException("I/Q buffer lengths [" + i.length + "] must be a power of 2 multiple of SIMD lane width [" + species.length() + "]");
        }
    }

    public static void checkArrayLength(float[] array, VectorSpecies<Float> species) {
        if (array.length % species.length() != 0) {
            throw new IllegalArgumentException("Buffer array length [" + array.length + "] must be a power of 2 multiple of SIMD lane width [" + species.length() + "]");
        }
    }

    public static void checkComplexArrayLength(ComplexSamples samples, VectorSpecies<Float> species) {
        VectorUtilities.checkComplexArrayLength(samples.i(), samples.q(), species);
    }

    public static VectorMask<Float> getIVectorMask(VectorSpecies<Float> species) {
        switch (species.length()) {
            case 2: {
                return VectorMask.fromArray(species, (boolean[])new boolean[]{true, false}, (int)0);
            }
            case 4: {
                return VectorMask.fromArray(species, (boolean[])new boolean[]{true, false, true, false}, (int)0);
            }
            case 8: {
                return VectorMask.fromArray(species, (boolean[])new boolean[]{true, false, true, false, true, false, true, false}, (int)0);
            }
            case 16: {
                return VectorMask.fromArray(species, (boolean[])new boolean[]{true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false}, (int)0);
            }
        }
        throw new IllegalArgumentException("Unrecognized vector species: " + String.valueOf(species));
    }

    public static VectorMask<Float> getQVectorMask(VectorSpecies<Float> species) {
        switch (species.length()) {
            case 2: {
                return VectorMask.fromArray(species, (boolean[])new boolean[]{false, true}, (int)0);
            }
            case 4: {
                return VectorMask.fromArray(species, (boolean[])new boolean[]{false, true, false, true}, (int)0);
            }
            case 8: {
                return VectorMask.fromArray(species, (boolean[])new boolean[]{false, true, false, true, false, true, false, true}, (int)0);
            }
            case 16: {
                return VectorMask.fromArray(species, (boolean[])new boolean[]{false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true}, (int)0);
            }
        }
        throw new IllegalArgumentException("Unrecognized vector species: " + String.valueOf(species));
    }

    public static int[] getIIndexMap(VectorSpecies<Float> species) {
        switch (species.length()) {
            case 2: {
                return new int[]{0, 2};
            }
            case 4: {
                return new int[]{0, 2, 4, 6};
            }
            case 8: {
                return new int[]{0, 2, 4, 6, 8, 10, 12, 14};
            }
            case 16: {
                return new int[]{0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30};
            }
        }
        throw new IllegalArgumentException("Unrecognized vector species: " + String.valueOf(species));
    }

    public static int[] getQIndexMap(VectorSpecies<Float> species) {
        switch (species.length()) {
            case 2: {
                return new int[]{1, 3};
            }
            case 4: {
                return new int[]{1, 3, 5, 7};
            }
            case 8: {
                return new int[]{1, 3, 5, 7, 9, 11, 13, 15};
            }
            case 16: {
                return new int[]{1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31};
            }
        }
        throw new IllegalArgumentException("Unrecognized vector species: " + String.valueOf(species));
    }

    public static float[] interleave(FloatVector iVector, FloatVector qVector) {
        float[] interleaved = new float[iVector.length() * 2];
        float[] i = new float[iVector.length()];
        float[] q = new float[qVector.length()];
        iVector.intoArray(i, 0);
        qVector.intoArray(q, 0);
        for (int x = 0; x < i.length; ++x) {
            interleaved[2 * x] = i[x];
            interleaved[2 * x + 1] = q[x];
        }
        return interleaved;
    }
}

