/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.util;

import io.github.dsheirer.controller.NamingThreadFactory;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.heartbeat.HeartbeatManager;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher<E>
implements Listener<E> {
    private static final Logger mLog = LoggerFactory.getLogger(Dispatcher.class);
    private final LinkedTransferQueue<E> mQueue = new LinkedTransferQueue();
    private Listener<E> mListener;
    private final AtomicBoolean mRunning = new AtomicBoolean();
    private final String mThreadName;
    private ScheduledExecutorService mExecutorService;
    private ScheduledFuture<?> mScheduledFuture;
    private final long mInterval;
    private HeartbeatManager mHeartbeatManager;

    public Dispatcher(String threadName, long interval, HeartbeatManager heartbeatManager) {
        this(threadName, interval);
        this.mHeartbeatManager = heartbeatManager;
    }

    public Dispatcher(String threadName, long interval) {
        this.mThreadName = threadName;
        this.mInterval = interval;
    }

    public void setListener(Listener<E> listener) {
        this.mListener = listener;
    }

    @Override
    public void receive(E e) {
        if (this.mRunning.get()) {
            this.mQueue.add(e);
        }
    }

    public void start() {
        if (this.mRunning.compareAndSet(false, true)) {
            if (this.mScheduledFuture != null) {
                this.mScheduledFuture.cancel(true);
            }
            if (this.mExecutorService != null) {
                this.mExecutorService.shutdown();
                this.mExecutorService = null;
            }
            this.mQueue.clear();
            this.mExecutorService = Executors.newSingleThreadScheduledExecutor(new NamingThreadFactory(this.mThreadName));
            Runnable r = this.mHeartbeatManager != null ? new ProcessorWithHeartbeat() : new Processor();
            this.mScheduledFuture = this.mExecutorService.scheduleAtFixedRate(r, 0L, this.mInterval, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.mRunning.compareAndSet(true, false)) {
            if (this.mScheduledFuture != null) {
                this.mScheduledFuture.cancel(true);
                this.mScheduledFuture = null;
                this.mQueue.clear();
            }
            if (this.mExecutorService != null) {
                this.mExecutorService.shutdown();
                this.mExecutorService = null;
            }
        }
    }

    public boolean isRunning() {
        return this.mRunning.get();
    }

    private void process() {
        ArrayList elements = new ArrayList();
        this.mQueue.drainTo(elements);
        for (Object element : elements) {
            if (!this.mRunning.get() || this.mListener == null) continue;
            try {
                this.mListener.receive(element);
            }
            catch (Throwable t) {
                mLog.error("Error while dispatching element [" + String.valueOf(element.getClass()) + "] to listener [" + String.valueOf(this.mListener.getClass()) + "]", t);
            }
        }
    }

    class ProcessorWithHeartbeat
    implements Runnable {
        private final AtomicBoolean mRunning = new AtomicBoolean();

        ProcessorWithHeartbeat() {
        }

        @Override
        public void run() {
            if (this.mRunning.compareAndSet(false, true)) {
                Dispatcher.this.process();
                try {
                    Dispatcher.this.mHeartbeatManager.broadcast();
                }
                catch (Throwable t) {
                    mLog.error("Error broadcasting heartbeat during Dispatcher processing interval", t);
                }
                this.mRunning.set(false);
            }
        }
    }

    class Processor
    implements Runnable {
        private final AtomicBoolean mRunning = new AtomicBoolean();

        Processor() {
        }

        @Override
        public void run() {
            if (this.mRunning.compareAndSet(false, true)) {
                Dispatcher.this.process();
                this.mRunning.set(false);
            }
        }
    }
}

