/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum.menu;

import io.github.dsheirer.spectrum.SpectralDisplayAdjuster;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SmoothingItem
extends JSlider
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private SpectralDisplayAdjuster mAdjuster;
    private int mDefaultValue;

    public SmoothingItem(SpectralDisplayAdjuster adjuster, int defaultValue) {
        super(0, 3, 29, adjuster.getSmoothing());
        this.mDefaultValue = defaultValue;
        this.mAdjuster = adjuster;
        this.setSnapToTicks(true);
        this.setMajorTickSpacing(6);
        this.setMinorTickSpacing(2);
        this.setPaintTicks(true);
        this.setPaintLabels(true);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(3, new JLabel("3"));
        labels.put(9, new JLabel("9"));
        labels.put(15, new JLabel("15"));
        labels.put(21, new JLabel("21"));
        labels.put(27, new JLabel("27"));
        this.setLabelTable(labels);
        this.addChangeListener(this);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    SmoothingItem.this.setValue(SmoothingItem.this.mDefaultValue);
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        int value = ((JSlider)event.getSource()).getValue();
        if (value % 2 == 1) {
            this.mAdjuster.setSmoothing(value);
        }
    }
}

