/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum;

import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.ui.DiscoveredTunerModel;
import io.github.dsheirer.spectrum.SpectralDisplayPanel;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;

public class SpectrumFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private SpectralDisplayPanel mSpectralDisplayPanel;

    public SpectrumFrame(PlaylistManager playlistManager, SettingsManager settingsManager, DiscoveredTunerModel discoveredTunerModel, Tuner tuner) {
        this.setTitle("SDRTRunk [" + tuner.getPreferredName() + "]");
        this.setBounds(100, 100, 1280, 600);
        this.setDefaultCloseOperation(2);
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow]", "[grow]"));
        this.mSpectralDisplayPanel = new SpectralDisplayPanel(playlistManager, settingsManager, discoveredTunerModel);
        this.mSpectralDisplayPanel.showTuner(tuner);
        this.add((Component)this.mSpectralDisplayPanel, "grow");
        this.addWindowListener(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpectrumFrame.this.setVisible(true);
            }
        });
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.mSpectralDisplayPanel.dispose();
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

