/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.usb;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbServices;

public class UsbUtils {
    public static List<UsbDevice> getDevices() throws SecurityException, UsbException, UnsupportedEncodingException {
        UsbServices services = UsbHostManager.getUsbServices();
        UsbHub root2 = services.getRootUsbHub();
        ArrayList<UsbDevice> devices = new ArrayList<UsbDevice>(UsbUtils.getHubDevices(root2));
        return devices;
    }

    public static List<UsbDevice> getHubDevices(UsbHub hub) throws UnsupportedEncodingException, UsbException {
        ArrayList<UsbDevice> devices = new ArrayList<UsbDevice>();
        List children = hub.getAttachedUsbDevices();
        for (UsbDevice child : children) {
            if (child.isUsbHub()) {
                devices.addAll(UsbUtils.getHubDevices((UsbHub)child));
                continue;
            }
            devices.add(child);
        }
        return devices;
    }

    public static String getDeviceDetails(UsbDevice device) throws UsbException, UnsupportedEncodingException, UsbDisconnectedException {
        StringBuilder sb = new StringBuilder();
        sb.append(device.getUsbDeviceDescriptor().toString()).append("\n\n");
        for (Object configObject : device.getUsbConfigurations()) {
            UsbConfiguration config = (UsbConfiguration)configObject;
            sb.append(config.getUsbConfigurationDescriptor().toString()).append("\n\n");
            for (Object interfaceObject : config.getUsbInterfaces()) {
                UsbInterface iface = (UsbInterface)interfaceObject;
                sb.append(iface.getUsbInterfaceDescriptor().toString()).append("\n\n");
                for (Object endpointObject : iface.getUsbEndpoints()) {
                    UsbEndpoint endpoint = (UsbEndpoint)endpointObject;
                    sb.append(endpoint.getUsbEndpointDescriptor().toString()).append("\n\n");
                }
            }
        }
        return sb.toString();
    }

    public static String getDeviceClass(byte deviceClass) {
        switch (deviceClass) {
            case 0: {
                return "Unknown Device - Class 0";
            }
            case 2: {
                return "Communications Device";
            }
            case 3: {
                return "HID Device";
            }
            case 5: {
                return "Physical Device";
            }
            case 6: {
                return "Still Imaging Device";
            }
            case 7: {
                return "Printer Device";
            }
            case 8: {
                return "Mass Storage Device";
            }
            case 9: {
                return "Hub Device";
            }
            case 10: {
                return "Communications Device";
            }
            case 11: {
                return "Smart Card Device";
            }
            case 13: {
                return "Content Security Device";
            }
            case 14: {
                return "Video Device";
            }
            case 15: {
                return "Personal Healthcare Device";
            }
            case 16: {
                return "Audio/Video Device";
            }
            case -36: {
                return "Diagnostic Device";
            }
            case -32: {
                return "Wireless Controller Device";
            }
            case -17: {
                return "Miscellaneous Device";
            }
        }
        return "Unknown Device - Class " + deviceClass;
    }
}

