/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.test;

import io.github.dsheirer.buffer.FloatNativeBuffer;
import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.dsp.oscillator.AWGNOscillator;
import io.github.dsheirer.dsp.oscillator.IComplexOscillator;
import io.github.dsheirer.dsp.oscillator.OscillatorFactory;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.util.ThreadPool;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleGenerator {
    private static final Logger mLog = LoggerFactory.getLogger(SampleGenerator.class);
    private Broadcaster<INativeBuffer> mNativeBufferBroadcaster = new Broadcaster();
    private IComplexOscillator mComplexOscillator;
    private int mSweepUpdateInterval;
    private long mInterval;
    private int mSamplesPerInterval = 65536;
    private ScheduledFuture<?> mScheduledFuture;

    public SampleGenerator(int sampleRate, long frequency, int sweepUpdateRate) {
        if (FastMath.abs((int)sweepUpdateRate) >= sampleRate) {
            throw new IllegalArgumentException("Sweep update rate cannot be greater than sample rate");
        }
        IComplexOscillator oscillator = OscillatorFactory.getComplexOscillator(frequency, sampleRate);
        this.mComplexOscillator = new AWGNOscillator(oscillator, 0.003f);
        this.mInterval = 1000 / (sampleRate / this.mSamplesPerInterval);
        this.mSweepUpdateInterval = sweepUpdateRate;
    }

    public SampleGenerator(int sampleRate, long frequency) {
        this(sampleRate, frequency, 0);
    }

    private void start() {
        if (this.mScheduledFuture != null) {
            throw new IllegalStateException("Sample generator is already started");
        }
        this.mScheduledFuture = ThreadPool.SCHEDULED.scheduleAtFixedRate(new Generator(), 0L, this.mInterval, TimeUnit.MILLISECONDS);
    }

    private void stop() {
        if (this.mScheduledFuture == null) {
            throw new IllegalStateException("Sample generator is already stopped");
        }
        this.mScheduledFuture.cancel(true);
        this.mScheduledFuture = null;
    }

    public void addListener(Listener<INativeBuffer> listener) {
        this.mNativeBufferBroadcaster.addListener(listener);
        if (this.mNativeBufferBroadcaster.getListenerCount() == 1) {
            this.start();
        }
    }

    public void removeListener(Listener<INativeBuffer> listener) {
        this.mNativeBufferBroadcaster.removeListener(listener);
        if (this.mNativeBufferBroadcaster.getListenerCount() == 0) {
            this.stop();
        }
    }

    public void setFrequency(long frequency) {
        this.mComplexOscillator.setFrequency(frequency);
    }

    public long getFrequency() {
        return (long)this.mComplexOscillator.getFrequency();
    }

    public void setSampleRate(int sampleRate) {
        this.mComplexOscillator.setSampleRate(sampleRate);
        this.mInterval = 1000 / (sampleRate / this.mSamplesPerInterval);
    }

    public double getSampleRate() {
        return this.mComplexOscillator.getSampleRate();
    }

    public class Generator
    implements Runnable {
        private int mTriggerInterval = 0;

        @Override
        public void run() {
            try {
                if (SampleGenerator.this.mNativeBufferBroadcaster.hasListeners()) {
                    float[] samples = SampleGenerator.this.mComplexOscillator.generate(SampleGenerator.this.mSamplesPerInterval);
                    long now = System.currentTimeMillis();
                    FloatNativeBuffer buffer = new FloatNativeBuffer(samples, now, 0.0f);
                    SampleGenerator.this.mNativeBufferBroadcaster.broadcast(buffer);
                    if (SampleGenerator.this.mSweepUpdateInterval != 0) {
                        ++this.mTriggerInterval;
                        if (this.mTriggerInterval >= 10) {
                            this.mTriggerInterval = 0;
                            long updatedFrequency = (long)SampleGenerator.this.mComplexOscillator.getFrequency() + (long)SampleGenerator.this.mSweepUpdateInterval;
                            if ((double)updatedFrequency > SampleGenerator.this.mComplexOscillator.getSampleRate() / 2.0) {
                                SampleGenerator.this.mComplexOscillator.setFrequency(SampleGenerator.this.mComplexOscillator.getSampleRate() / -2.0);
                            } else if ((double)updatedFrequency < SampleGenerator.this.mComplexOscillator.getSampleRate() / -2.0) {
                                SampleGenerator.this.mComplexOscillator.setFrequency(SampleGenerator.this.mComplexOscillator.getSampleRate() / 2.0);
                            } else {
                                SampleGenerator.this.mComplexOscillator.setFrequency(updatedFrequency);
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

