/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDx;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.sdrplay.DiscoveredRspTuner;
import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.RspTuner;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerEditor;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.AgcMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.HdrModeBandwidth;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.RspDxAntenna;
import io.github.dsheirer.source.tuner.sdrplay.rspDx.IControlRspDx;
import io.github.dsheirer.source.tuner.sdrplay.rspDx.RspDxTunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.rspDx.RspDxTunerController;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RspDxTunerEditor
extends RspTunerEditor<RspDxTunerConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(RspDxTunerEditor.class);
    private JComboBox<RspSampleRate> mSampleRateCombo;
    private JCheckBox mBiasTCheckBox;
    private JCheckBox mRfDabNotchCheckBox;
    private JCheckBox mRfNotchCheckBox;
    private JComboBox<RspDxAntenna> mAntennaCombo;
    private JCheckBox mHdrModeCheckBox;
    private JComboBox<HdrModeBandwidth> mHdrModeBandwidthCombo;

    public RspDxTunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredRspTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add((Component)this.getTunerIdLabel(), "wrap");
        this.add(new JLabel("Status:"));
        this.add((Component)this.getTunerStatusLabel(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
        this.add(new JLabel("Sample Rate:"));
        this.add(this.getSampleRateCombo(), "wrap");
        this.add(new JLabel("IF AGC Mode:"));
        JPanel gainPanel = new JPanel();
        gainPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow,fill][]", ""));
        gainPanel.add(this.getAgcButton());
        gainPanel.add(this.getGainOverloadButton());
        this.add((Component)gainPanel, "wrap");
        this.add(new JLabel("Gain:"));
        this.add(this.getGainSlider());
        this.add(this.getGainValueLabel());
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel());
        this.add(this.getAntennaCombo(), "wrap");
        this.add(new JLabel());
        this.add((Component)this.getBiasTCheckBox(), "wrap");
        this.add(new JLabel());
        this.add((Component)this.getRfDabNotchCheckBox(), "wrap");
        this.add(new JLabel());
        this.add((Component)this.getRfNotchCheckBox(), "wrap");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel());
        this.add((Component)this.getHdrModeCheckBox(), "wrap");
        this.add(new JLabel("HDR Mode Bandwidth"));
        this.add(this.getHdrModeBandwidthCombo(), "wrap");
    }

    private RspDxTunerController getTunerController() {
        if (this.hasTuner()) {
            return (RspDxTunerController)((RspTuner)this.getTuner()).getTunerController();
        }
        return null;
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(!locked);
        this.updateSampleRateToolTip();
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId());
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(this.hasTuner() && !((RspTuner)this.getTuner()).getTunerController().isLockedSampleRate());
        this.getSampleRateCombo().setSelectedItem((Object)(this.hasTuner() ? ((IControlRspDx)this.getTunerController().getControlRsp()).getSampleRateEnumeration() : null));
        this.updateSampleRateToolTip();
        this.getAgcButton().setEnabled(this.hasTuner());
        if (this.hasTuner()) {
            AgcMode current = ((IControlRspDx)this.getTunerController().getControlRsp()).getAgcMode();
            this.getAgcButton().setSelected(current == null || current.equals((Object)AgcMode.ENABLE));
            ((IControlRspDx)this.getTunerController().getControlRsp()).setGainOverloadListener(this);
        }
        this.getGainSlider().setEnabled(this.hasTuner());
        this.getGainValueLabel().setEnabled(this.hasTuner());
        this.getGainSlider().setValue(this.hasTuner() ? ((IControlRspDx)this.getTunerController().getControlRsp()).getGain() : 0);
        this.getBiasTCheckBox().setEnabled(this.hasTuner());
        try {
            this.getBiasTCheckBox().setSelected(this.hasTuner() && ((IControlRspDx)this.getTunerController().getControlRsp()).isBiasT());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting Bias-T enabled state in editor");
        }
        this.getHdrModeCheckBox().setEnabled(this.hasTuner());
        try {
            this.getHdrModeCheckBox().setSelected(this.hasTuner() && ((IControlRspDx)this.getTunerController().getControlRsp()).isHighDynamicRange());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting HDR mode enabled state in editor");
        }
        this.getRfNotchCheckBox().setEnabled(this.hasTuner());
        try {
            this.getRfNotchCheckBox().setSelected(this.hasTuner() && ((IControlRspDx)this.getTunerController().getControlRsp()).isRfNotch());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting RF Notch enabled state in editor");
        }
        this.getRfDabNotchCheckBox().setEnabled(this.hasTuner());
        try {
            this.getRfDabNotchCheckBox().setSelected(this.hasTuner() && ((IControlRspDx)this.getTunerController().getControlRsp()).isRfDabNotch());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting RF DAB Notch enabled state in editor");
        }
        this.getAntennaCombo().setEnabled(this.hasTuner());
        try {
            this.getAntennaCombo().setSelectedItem((Object)(this.hasTuner() ? ((IControlRspDx)this.getTunerController().getControlRsp()).getAntenna() : null));
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting antenna selection in editor");
        }
        this.setLoading(false);
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            ((RspDxTunerConfiguration)this.getConfiguration()).setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            ((RspDxTunerConfiguration)this.getConfiguration()).setFrequencyCorrection(value);
            ((RspDxTunerConfiguration)this.getConfiguration()).setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            ((RspDxTunerConfiguration)this.getConfiguration()).setSampleRate((RspSampleRate)((Object)this.getSampleRateCombo().getSelectedItem()));
            ((RspDxTunerConfiguration)this.getConfiguration()).setBiasT(this.getBiasTCheckBox().isSelected());
            ((RspDxTunerConfiguration)this.getConfiguration()).setHdrMode(this.getHdrModeCheckBox().isSelected());
            ((RspDxTunerConfiguration)this.getConfiguration()).setRfDabNotch(this.getRfNotchCheckBox().isSelected());
            ((RspDxTunerConfiguration)this.getConfiguration()).setRfNotch(this.getRfNotchCheckBox().isSelected());
            ((RspDxTunerConfiguration)this.getConfiguration()).setAntenna((RspDxAntenna)((Object)this.getAntennaCombo().getSelectedItem()));
            ((RspDxTunerConfiguration)this.getConfiguration()).setGain(this.getGainSlider().getValue());
            ((RspDxTunerConfiguration)this.getConfiguration()).setAgcMode(this.getAgcButton().isSelected() ? AgcMode.ENABLE : AgcMode.DISABLE);
            this.saveConfiguration();
        }
    }

    private JComboBox<RspSampleRate> getSampleRateCombo() {
        if (this.mSampleRateCombo == null) {
            RspSampleRate[] rspSampleRates = RspSampleRate.SINGLE_TUNER_SAMPLE_RATES.toArray(new RspSampleRate[RspSampleRate.SINGLE_TUNER_SAMPLE_RATES.size()]);
            this.mSampleRateCombo = new JComboBox<RspSampleRate>(rspSampleRates);
            this.mSampleRateCombo.setEnabled(false);
            this.mSampleRateCombo.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    RspSampleRate selected = (RspSampleRate)((Object)((Object)this.mSampleRateCombo.getSelectedItem()));
                    try {
                        this.getTunerController().setSampleRate(selected);
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Error setting sample rate for RSP2 tuner", (Throwable)se);
                    }
                }
            });
        }
        return this.mSampleRateCombo;
    }

    private JCheckBox getBiasTCheckBox() {
        if (this.mBiasTCheckBox == null) {
            this.mBiasTCheckBox = new JCheckBox("ANT B Bias-T Power");
            this.mBiasTCheckBox.setEnabled(false);
            this.mBiasTCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRspDx)this.getTunerController().getControlRsp()).setBiasT(this.mBiasTCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSP2 Bias-T enabled to " + this.mBiasTCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mBiasTCheckBox;
    }

    private JCheckBox getHdrModeCheckBox() {
        if (this.mHdrModeCheckBox == null) {
            this.mHdrModeCheckBox = new JCheckBox("HDR Mode (1 kHz - 2 MHz)");
            this.mHdrModeCheckBox.setEnabled(false);
            this.mHdrModeCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRspDx)this.getTunerController().getControlRsp()).setHighDynamicRange(this.mHdrModeCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSPd HDR mode enabled to " + this.mHdrModeCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mHdrModeCheckBox;
    }

    private JCheckBox getRfNotchCheckBox() {
        if (this.mRfNotchCheckBox == null) {
            this.mRfNotchCheckBox = new JCheckBox("FM Broadcast Band Filter (77-115 MHz)");
            this.mRfNotchCheckBox.setEnabled(false);
            this.mRfNotchCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRspDx)this.getTunerController().getControlRsp()).setRfNotch(this.mRfNotchCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSP2 RF notch enabled to " + this.mRfNotchCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mRfNotchCheckBox;
    }

    private JCheckBox getRfDabNotchCheckBox() {
        if (this.mRfDabNotchCheckBox == null) {
            this.mRfDabNotchCheckBox = new JCheckBox("DAB Broadcast Band Filter (155-235 MHz)");
            this.mRfDabNotchCheckBox.setEnabled(false);
            this.mRfDabNotchCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRspDx)this.getTunerController().getControlRsp()).setRfDabNotch(this.mRfDabNotchCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSPdx RF DAB notch enabled to " + this.mRfDabNotchCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mRfDabNotchCheckBox;
    }

    private JComboBox<RspDxAntenna> getAntennaCombo() {
        if (this.mAntennaCombo == null) {
            this.mAntennaCombo = new JComboBox<RspDxAntenna>(RspDxAntenna.values());
            this.mAntennaCombo.setEnabled(false);
            this.mAntennaCombo.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    RspDxAntenna selected = (RspDxAntenna)((Object)((Object)this.mAntennaCombo.getSelectedItem()));
                    try {
                        ((IControlRspDx)this.getTunerController().getControlRsp()).setAntenna(selected);
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Error setting Antenna selection for RSPdx", (Throwable)se);
                    }
                }
            });
        }
        return this.mAntennaCombo;
    }

    private JComboBox<HdrModeBandwidth> getHdrModeBandwidthCombo() {
        if (this.mHdrModeBandwidthCombo == null) {
            this.mHdrModeBandwidthCombo = new JComboBox<HdrModeBandwidth>(HdrModeBandwidth.values());
            this.mHdrModeBandwidthCombo.setEnabled(false);
            this.mHdrModeBandwidthCombo.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    HdrModeBandwidth selected = (HdrModeBandwidth)((Object)((Object)this.mHdrModeBandwidthCombo.getSelectedItem()));
                    try {
                        ((IControlRspDx)this.getTunerController().getControlRsp()).setHdrModeBandwidth(selected);
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Error setting HDR mode bandwidth for RSPdx", (Throwable)se);
                    }
                }
            });
        }
        return this.mHdrModeBandwidthCombo;
    }

    private void updateSampleRateToolTip() {
        if (this.hasTuner() && ((RspTuner)this.getTuner()).getTunerController().isLockedSampleRate()) {
            this.getSampleRateCombo().setToolTipText("Sample Rate is locked.  Disable decoding channels to unlock.");
        } else if (this.hasTuner()) {
            this.getSampleRateCombo().setToolTipText("Select a sample rate for the tuner");
        } else {
            this.getSampleRateCombo().setToolTipText("No tuner available");
        }
    }
}

