/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDuo;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerController;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.IControlRspDuoTuner1;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.RspDuoTuner1Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RspDuoTuner1Controller
extends RspTunerController<IControlRspDuoTuner1> {
    private Logger mLog = LoggerFactory.getLogger(RspDuoTuner1Controller.class);

    public RspDuoTuner1Controller(IControlRspDuoTuner1 device, ITunerErrorListener tunerErrorListener) {
        super(device, tunerErrorListener);
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.RSP_DUO_1;
    }

    @Override
    public void apply(TunerConfiguration config) throws SourceException {
        if (config instanceof RspDuoTuner1Configuration) {
            RspDuoTuner1Configuration rtc = (RspDuoTuner1Configuration)config;
            super.apply(config);
            try {
                ((IControlRspDuoTuner1)this.getControlRsp()).setAgcMode(rtc.getAgcMode());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSP IF AGC Mode to " + String.valueOf((Object)rtc.getAgcMode()));
            }
            try {
                ((IControlRspDuoTuner1)this.getControlRsp()).setRfNotch(rtc.isRfNotch());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPduo tuner 1 RF notch enabled to " + rtc.isRfNotch());
            }
            try {
                ((IControlRspDuoTuner1)this.getControlRsp()).setRfDabNotch(rtc.isRfDabNotch());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPduo tuner 1 RF DAB notch enabled to " + rtc.isRfDabNotch());
            }
            try {
                ((IControlRspDuoTuner1)this.getControlRsp()).setAmNotch(rtc.isAmNotch());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPduo tuner 1 AM notch enabled to " + rtc.isAmNotch());
            }
            try {
                ((IControlRspDuoTuner1)this.getControlRsp()).setAmPort(rtc.getAmPort());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPduo tuner 1 AM port to " + String.valueOf((Object)rtc.getAmPort()));
            }
            try {
                ((IControlRspDuoTuner1)this.getControlRsp()).setExternalReferenceOutput(rtc.isExternalReferenceOutput());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPduo tuner 1 external reference output enabled to " + rtc.isExternalReferenceOutput());
            }
        } else {
            this.mLog.error("Invalid RSPduo tuner configuration type: " + String.valueOf(config.getClass()));
        }
    }

    @Override
    public void setSampleRate(RspSampleRate rspSampleRate) throws SDRPlayException {
        if (((IControlRspDuoTuner1)this.getControlRsp()).getDeviceSelectionMode().isSingleTunerMode()) {
            if (rspSampleRate.isDualTunerSampleRate()) {
                super.setSampleRate(RspTunerConfiguration.DEFAULT_SINGLE_TUNER_SAMPLE_RATE);
            } else {
                super.setSampleRate(rspSampleRate);
            }
        } else if (rspSampleRate.isDualTunerSampleRate()) {
            super.setSampleRate(rspSampleRate);
        } else {
            super.setSampleRate(RspTunerConfiguration.DEFAULT_DUAL_TUNER_SAMPLE_RATE);
        }
    }
}

