/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rsp1;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerController;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.rsp1.IControlRsp1;
import io.github.dsheirer.source.tuner.sdrplay.rsp1.Rsp1TunerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rsp1TunerController
extends RspTunerController<IControlRsp1> {
    private Logger mLog = LoggerFactory.getLogger(Rsp1TunerController.class);

    public Rsp1TunerController(IControlRsp1 control, ITunerErrorListener tunerErrorListener) {
        super(control, tunerErrorListener);
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.RSP_1;
    }

    @Override
    public void apply(TunerConfiguration config) throws SourceException {
        if (config instanceof Rsp1TunerConfiguration) {
            Rsp1TunerConfiguration rtc = (Rsp1TunerConfiguration)config;
            super.apply(config);
            try {
                ((IControlRsp1)this.getControlRsp()).setAgcMode(rtc.getAgcMode());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSP IF AGC Mode to " + String.valueOf((Object)rtc.getAgcMode()));
            }
        } else {
            this.mLog.error("Invalid RSP1 tuner configuration type: " + String.valueOf(config.getClass()));
        }
    }
}

