/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner;

import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.util.Flag;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_RfFreqT;
import java.lang.foreign.MemorySegment;

public class RfFrequency {
    private static final double MINIMUM_FREQUENCY = 1200.0;
    private static final double MAXIMUM_FREQUENCY = 2.0E9;
    private MemorySegment mMemorySegment;

    public RfFrequency(MemorySegment memorySegment) {
        this.mMemorySegment = memorySegment;
    }

    private MemorySegment getMemorySegment() {
        return this.mMemorySegment;
    }

    public double getFrequency() {
        return sdrplay_api_RfFreqT.rfHz$get(this.getMemorySegment());
    }

    public void setFrequency(double frequency, boolean synchronousUpdate) throws SDRPlayException {
        if (!(1200.0 < frequency) || !(frequency <= 2.0E9)) {
            throw new SDRPlayException("Invalid frequency: " + frequency + " - valid range: 1200.0-2.0E9");
        }
        sdrplay_api_RfFreqT.rfHz$set(this.getMemorySegment(), frequency);
        sdrplay_api_RfFreqT.syncUpdate$set(this.getMemorySegment(), Flag.of(synchronousUpdate));
    }

    public void setFrequency(double frequency) throws SDRPlayException {
        this.setFrequency(frequency, true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Frequency:").append(this.getFrequency());
        return sb.toString();
    }
}

