/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner;

import java.util.EnumSet;

public enum FrequencyBand {
    BAND_0_12(1000L, 12000000L, "0.001-12 MHz"),
    BAND_12_60(12000000L, 60000000L, "12-60 MHz"),
    BAND_60_250(60000000L, 250000000L, "60-250 MHz"),
    BAND_250_420(250000000L, 420000000L, "250-420 MHz"),
    BAND_420_1000(420000000L, 1000000000L, "420-1000 MHz"),
    BAND_1000_2000(1000000000L, 2000000000L, "1000-2000 MHz"),
    UNKNOWN(-1L, 0L, "UNKNOWN");

    private long mMinimum;
    private long mMaximum;
    private String mDescription;
    public static EnumSet<FrequencyBand> VALID_FREQUENCY_BANDS;

    private FrequencyBand(long min, long max, String description) {
        this.mMinimum = min;
        this.mMaximum = max;
        this.mDescription = description;
    }

    public long getMinimum() {
        return this.mMinimum;
    }

    public long getMaximum() {
        return this.mMaximum;
    }

    public static FrequencyBand fromValue(long frequency) {
        for (FrequencyBand band : FrequencyBand.values()) {
            if (!band.contains(frequency)) continue;
            return band;
        }
        return UNKNOWN;
    }

    public boolean contains(long frequency) {
        return this.getMinimum() <= frequency && frequency < this.getMaximum();
    }

    public String toString() {
        return this.mDescription;
    }

    static {
        VALID_FREQUENCY_BANDS = EnumSet.range(BAND_0_12, BAND_1000_2000);
    }
}

