/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.device;

import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceType;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.DeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.Rsp1DeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.Rsp1aDeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.Rsp2DeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.RspDuoDeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.RspDxDeviceParameters;
import java.lang.foreign.MemorySegment;

public class DeviceParametersFactory {
    public static DeviceParameters create(DeviceType deviceType, MemorySegment memorySegment) {
        switch (deviceType) {
            case RSP1: {
                return new Rsp1DeviceParameters(memorySegment);
            }
            case RSP1A: {
                return new Rsp1aDeviceParameters(memorySegment);
            }
            case RSP2: {
                return new Rsp2DeviceParameters(memorySegment);
            }
            case RSPduo: {
                return new RspDuoDeviceParameters(memorySegment);
            }
            case RSPdx: {
                return new RspDxDeviceParameters(memorySegment);
            }
        }
        throw new IllegalArgumentException("Unrecognized Device Type: " + String.valueOf((Object)deviceType));
    }
}

