/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite;

import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceType;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.CompositeParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.Rsp1CompositeParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.Rsp1aCompositeParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.Rsp2CompositeParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.RspDuoCompositeParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.RspDxCompositeParameters;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;

public class CompositeParametersFactory {
    public static CompositeParameters create(DeviceType deviceType, MemorySegment memorySegment, Arena arena) {
        switch (deviceType) {
            case RSP1: {
                return new Rsp1CompositeParameters(memorySegment, arena);
            }
            case RSP1A: {
                return new Rsp1aCompositeParameters(memorySegment, arena);
            }
            case RSP2: {
                return new Rsp2CompositeParameters(memorySegment, arena);
            }
            case RSPduo: {
                return new RspDuoCompositeParameters(memorySegment, arena);
            }
            case RSPdx: {
                return new RspDxCompositeParameters(memorySegment, arena);
            }
        }
        throw new IllegalArgumentException("Unrecognized device type: " + String.valueOf((Object)deviceType));
    }
}

