/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite;

import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceType;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.ControlParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.DeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.DeviceParametersFactory;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.TunerParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.TunerParametersFactory;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_DevParamsT;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_DeviceParamsT;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_RxChannelParamsT;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;

public class CompositeParameters<D extends DeviceParameters, T extends TunerParameters> {
    private D mDeviceParameters;
    private T mTunerAParameters;
    private ControlParameters mControlAParameters;

    public CompositeParameters(DeviceType deviceType, MemorySegment memorySegment, Arena arena) {
        MemorySegment parametersMemoryAddress = sdrplay_api_DeviceParamsT.devParams$get(memorySegment);
        MemorySegment parametersMemorySegment = sdrplay_api_DevParamsT.ofAddress(parametersMemoryAddress, arena.scope());
        this.mDeviceParameters = DeviceParametersFactory.create(deviceType, parametersMemorySegment);
        MemorySegment memoryAddressRxA = sdrplay_api_DeviceParamsT.rxChannelA$get(memorySegment);
        MemorySegment memorySegmentRxA = sdrplay_api_RxChannelParamsT.ofAddress(memoryAddressRxA, arena.scope());
        this.mTunerAParameters = TunerParametersFactory.create(deviceType, memorySegmentRxA);
        MemorySegment tunerAControlParametersMemorySegment = sdrplay_api_RxChannelParamsT.ctrlParams$slice(memorySegmentRxA);
        this.mControlAParameters = new ControlParameters(tunerAControlParametersMemorySegment);
    }

    public D getDeviceParameters() {
        return this.mDeviceParameters;
    }

    public T getTunerAParameters() {
        return this.mTunerAParameters;
    }

    public ControlParameters getControlAParameters() {
        return this.mControlAParameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Composite Parameters\n");
        sb.append("\tDevice Parameters:\n").append(this.getDeviceParameters()).append("\n");
        sb.append("\tTuner A Parameters:\n").append(this.getTunerAParameters()).append("\n");
        return sb.toString();
    }
}

