/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.error;

import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_ErrorInfoT;
import java.lang.foreign.MemorySegment;

public class ErrorInformation {
    private String mFile;
    private String mFunction;
    private int mLine;
    private String mMessage;

    public ErrorInformation(MemorySegment memorySegment) {
        this.mFile = sdrplay_api_ErrorInfoT.file$slice(memorySegment).getUtf8String(0L);
        this.mFunction = sdrplay_api_ErrorInfoT.function$slice(memorySegment).getUtf8String(0L);
        this.mLine = sdrplay_api_ErrorInfoT.line$get(memorySegment);
        this.mMessage = sdrplay_api_ErrorInfoT.message$slice(memorySegment).getUtf8String(0L);
    }

    public String getFile() {
        return this.mFile;
    }

    public String getFunction() {
        return this.mFunction;
    }

    public int getLine() {
        return this.mLine;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Error Information:").append("\n");
        sb.append("\t    File: ").append(this.getFile()).append("\n");
        sb.append("\tFunction: ").append(this.getFunction()).append("\n");
        sb.append("\t    Line: ").append(this.getLine()).append("\n");
        sb.append("\t Message: ").append(this.getMessage()).append("\n");
        return sb.toString();
    }
}

