/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.device;

import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRplay;
import io.github.dsheirer.source.tuner.sdrplay.api.UpdateReason;
import io.github.dsheirer.source.tuner.sdrplay.api.async.AsyncUpdateFuture;
import io.github.dsheirer.source.tuner.sdrplay.api.device.Device;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.AgcMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.ControlParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.DeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.Bandwidth;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.Gain;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.GainReduction;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.IfMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.LoMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.TunerParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RspTuner<D extends DeviceParameters, T extends TunerParameters> {
    private static final Logger mLog = LoggerFactory.getLogger(RspTuner.class);
    private final SDRplay mSDRplay;
    private final Device mDevice;
    private final TunerSelect mTunerSelect;
    private final D mDeviceParameters;
    private final T mTunerParameters;
    private final ControlParameters mControlParameters;
    private GainReduction mGainReduction;

    RspTuner(Device device, SDRplay sdrplay, TunerSelect tunerSelect, D deviceParameters, T tunerParameters, ControlParameters controlParameters) {
        this.mDevice = device;
        this.mSDRplay = sdrplay;
        this.mTunerSelect = tunerSelect;
        this.mDeviceParameters = deviceParameters;
        this.mTunerParameters = tunerParameters;
        this.mControlParameters = controlParameters;
    }

    private SDRplay getSDRplay() {
        return this.mSDRplay;
    }

    private Device getDevice() {
        return this.mDevice;
    }

    public TunerSelect getTunerSelect() {
        return this.mTunerSelect;
    }

    protected D getDeviceParameters() {
        return this.mDeviceParameters;
    }

    public T getTunerParameters() {
        return this.mTunerParameters;
    }

    protected ControlParameters getControlParameters() {
        return this.mControlParameters;
    }

    protected void update(UpdateReason ... updateReasons) throws SDRPlayException {
        this.getDevice().update(this.getTunerSelect(), updateReasons);
    }

    protected AsyncUpdateFuture updateAsync(UpdateReason updateReason, UpdateReason expectedResponse) {
        return this.getDevice().updateAsync(this.getTunerSelect(), updateReason, expectedResponse);
    }

    public Bandwidth getBandwidth() {
        return ((TunerParameters)this.getTunerParameters()).getBandwidth();
    }

    public void setBandwidth(Bandwidth bandwidth) throws SDRPlayException {
        ((TunerParameters)this.getTunerParameters()).setBandwidth(bandwidth);
        this.update(UpdateReason.TUNER_BANDWIDTH_TYPE);
    }

    public long getFrequency() {
        return (long)((TunerParameters)this.getTunerParameters()).getRfFrequency().getFrequency();
    }

    public AsyncUpdateFuture setFrequency(long frequency) {
        try {
            ((TunerParameters)this.getTunerParameters()).getRfFrequency().setFrequency(frequency, false);
            this.updateGainReduction(frequency);
            return this.updateAsync(UpdateReason.TUNER_FREQUENCY_RF, UpdateReason.TUNER_FREQUENCY_RF);
        }
        catch (SDRPlayException se) {
            AsyncUpdateFuture future = new AsyncUpdateFuture(this.getTunerSelect(), UpdateReason.TUNER_FREQUENCY_RF, UpdateReason.TUNER_FREQUENCY_RF);
            future.setError(se);
            return future;
        }
    }

    public GainReduction getGainReduction() {
        if (this.mGainReduction == null) {
            this.updateGainReduction(this.getFrequency());
        }
        return this.mGainReduction;
    }

    private void updateGainReduction(long frequency) {
        if (this.mGainReduction == null || !this.mGainReduction.isValidFor(frequency)) {
            this.mGainReduction = GainReduction.lookup(this.getDevice().getDeviceType(), frequency);
        }
    }

    public void setGain(int index) throws SDRPlayException {
        ((TunerParameters)this.getTunerParameters()).getGain().setGain(this.getGainReduction(), index);
        this.update(UpdateReason.TUNER_GAIN_REDUCTION);
    }

    public void setAGC(AgcMode mode) throws SDRPlayException {
        this.getControlParameters().getAgc().setAgcMode(mode);
        this.update(UpdateReason.CONTROL_AGC);
    }

    public AgcMode getAGC() {
        return this.getControlParameters().getAgc().getAgcMode();
    }

    public Gain getGain() {
        return ((TunerParameters)this.getTunerParameters()).getGain();
    }

    public int getGainIndex() {
        int gainDb = this.getGain().getGainReductionDb();
        return this.getGainReduction().getGainIndex(gainDb);
    }

    public void setDCCorrection(boolean enable) throws SDRPlayException {
        this.getControlParameters().getDcOffset().setDC(enable);
        this.update(UpdateReason.CONTROL_DC_OFFSET_IQ_IMBALANCE);
    }

    public void setIQCorrection(boolean enable) throws SDRPlayException {
        this.getControlParameters().getDcOffset().setIQ(enable);
        this.update(UpdateReason.CONTROL_DC_OFFSET_IQ_IMBALANCE);
    }

    public AsyncUpdateFuture setPPM(double ppm) throws SDRPlayException {
        ((DeviceParameters)this.getDeviceParameters()).setPPM(ppm);
        return this.updateAsync(UpdateReason.DEVICE_PPM, UpdateReason.DEVICE_SAMPLE_RATE);
    }

    public double getPPM() {
        return ((DeviceParameters)this.getDeviceParameters()).getPPM();
    }

    public void setSynchronousUpdate(int sampleNumber, int period) throws SDRPlayException {
        ((DeviceParameters)this.getDeviceParameters()).getSynchronousUpdate().set(sampleNumber, period);
        this.update(UpdateReason.DEVICE_SYNC_UPDATE);
    }

    public void reset(boolean frequency, boolean sampleRate, boolean gain) throws SDRPlayException {
        ((DeviceParameters)this.getDeviceParameters()).getResetFlags().resetGain(gain);
        ((DeviceParameters)this.getDeviceParameters()).getResetFlags().resetFrequency(frequency);
        ((DeviceParameters)this.getDeviceParameters()).getResetFlags().resetSampleRate(sampleRate);
        this.update(UpdateReason.DEVICE_RESET_FLAGS);
    }

    public void resetFrequency(boolean frequency) throws SDRPlayException {
        this.reset(frequency, false, false);
    }

    public void resetSampleRate(boolean sampleRate) throws SDRPlayException {
        this.reset(false, sampleRate, false);
    }

    public void resetGain(boolean gain) throws SDRPlayException {
        this.reset(false, false, gain);
    }

    public IfMode getIfMode() {
        return ((TunerParameters)this.getTunerParameters()).getIfMode();
    }

    public void setIfMode(IfMode mode) throws SDRPlayException {
        ((TunerParameters)this.getTunerParameters()).setIfMode(mode);
        this.update(UpdateReason.TUNER_IF_TYPE);
    }

    public LoMode getLoMode() {
        return ((TunerParameters)this.getTunerParameters()).getLoMode();
    }

    public void setLoMode(LoMode mode) throws SDRPlayException {
        ((TunerParameters)this.getTunerParameters()).setLoMode(mode);
        this.update(UpdateReason.TUNER_LO_MODE);
    }
}

