/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.device;

import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRplay;
import io.github.dsheirer.source.tuner.sdrplay.api.Version;
import io.github.dsheirer.source.tuner.sdrplay.api.device.Device;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceInfo;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceStruct_v3_07;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceStruct_v3_08;
import io.github.dsheirer.source.tuner.sdrplay.api.device.IDeviceStruct;
import io.github.dsheirer.source.tuner.sdrplay.api.device.Rsp1Device;
import io.github.dsheirer.source.tuner.sdrplay.api.device.Rsp1aDevice;
import io.github.dsheirer.source.tuner.sdrplay.api.device.Rsp2Device;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoDevice;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDxDevice;
import io.github.dsheirer.source.tuner.sdrplay.api.device.UnknownDevice;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_DeviceT;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_h;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceFactory {
    private static final Logger mLog = LoggerFactory.getLogger(DeviceFactory.class);

    public static MemorySegment createDeviceArray(Version version, SegmentAllocator segmentAllocator) {
        if (version.gte(Version.V3_08)) {
            return sdrplay_api_DeviceT.allocateArray(sdrplay_api_h.SDRPLAY_MAX_DEVICES(), segmentAllocator);
        }
        if (version == Version.V3_07) {
            return sdrplay_api_DeviceT.allocateArray(sdrplay_api_h.SDRPLAY_MAX_DEVICES(), segmentAllocator);
        }
        throw new IllegalArgumentException("Unrecognized version: " + String.valueOf((Object)version));
    }

    public static List<DeviceInfo> parseDeviceInfos(List<IDeviceStruct> deviceStructs) {
        ArrayList<DeviceInfo> deviceInfos = new ArrayList<DeviceInfo>();
        for (IDeviceStruct deviceStruct : deviceStructs) {
            deviceInfos.add(new DeviceInfo(deviceStruct));
        }
        return deviceInfos;
    }

    public static List<IDeviceStruct> parseDeviceStructs(Version version, MemorySegment devicesArray, int count) throws SDRPlayException {
        ArrayList<IDeviceStruct> deviceStructs = new ArrayList<IDeviceStruct>();
        if (version.gte(Version.V3_08)) {
            devicesArray.elements(sdrplay_api_DeviceT.$LAYOUT()).limit(count).forEach(memorySegment -> deviceStructs.add(DeviceFactory.createDeviceStruct(version, memorySegment)));
        } else if (version == Version.V3_07) {
            devicesArray.elements(sdrplay_api_DeviceT.$LAYOUT()).limit(count).forEach(memorySegment -> deviceStructs.add(DeviceFactory.createDeviceStruct(version, memorySegment)));
        } else {
            throw new SDRPlayException("Unrecognized version: " + String.valueOf((Object)version));
        }
        return deviceStructs;
    }

    public static Device createDevice(SDRplay sdrPlay, IDeviceStruct deviceStruct) {
        switch (deviceStruct.getDeviceType()) {
            case RSP1: {
                return new Rsp1Device(sdrPlay, deviceStruct);
            }
            case RSP1A: {
                return new Rsp1aDevice(sdrPlay, deviceStruct);
            }
            case RSP2: {
                return new Rsp2Device(sdrPlay, deviceStruct);
            }
            case RSPduo: {
                return new RspDuoDevice(sdrPlay, deviceStruct);
            }
            case RSPdx: {
                return new RspDxDevice(sdrPlay, deviceStruct);
            }
        }
        return new UnknownDevice(sdrPlay, deviceStruct);
    }

    private static IDeviceStruct createDeviceStruct(Version version, MemorySegment deviceMemorySegment) {
        if (version == Version.V3_07) {
            return new DeviceStruct_v3_07(deviceMemorySegment);
        }
        if (version.gte(Version.V3_08)) {
            return new DeviceStruct_v3_08(deviceMemorySegment);
        }
        throw new IllegalArgumentException("Unsupported version: " + String.valueOf((Object)version));
    }
}

